/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedCSVParser;
import org.eclipse.jetty.http.QuotedQualityCSV;

public interface HttpFields
extends Iterable<HttpField> {
    public static final HttpField EXPIRES_01JAN1970 = new PreEncodedHttpField(HttpHeader.EXPIRES, DateGenerator.__01Jan1970);
    public static final HttpField CONNECTION_CLOSE = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
    public static final HttpField CONNECTION_KEEPALIVE = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
    public static final HttpFields EMPTY = HttpFields.build().asImmutable();

    public static Mutable build() {
        return new MutableHttpFields();
    }

    public static Mutable build(int capacity) {
        return new MutableHttpFields(capacity);
    }

    public static Mutable build(HttpFields fields) {
        return new MutableHttpFields(fields);
    }

    public static Mutable build(HttpFields fields, HttpField replaceField) {
        return new MutableHttpFields(fields, replaceField);
    }

    public static Mutable build(HttpFields fields, EnumSet<HttpHeader> removeFields) {
        return new MutableHttpFields(fields, removeFields);
    }

    public static ImmutableHttpFields from(HttpField ... fields) {
        return new ImmutableHttpFields(fields);
    }

    public static ImmutableHttpFields from(HttpFields fields, Function<HttpField, HttpField> mutation) {
        return new ImmutableHttpFields((HttpField[])fields.stream().map(mutation).filter(Objects::nonNull).toArray(HttpField[]::new));
    }

    default public HttpFields asImmutable() {
        return HttpFields.build(this).asImmutable();
    }

    default public HttpFields takeAsImmutable() {
        return HttpFields.build(this).takeAsImmutable();
    }

    default public String asString() {
        StringBuilder buffer = new StringBuilder();
        for (HttpField field : this) {
            if (field == null) continue;
            String tmp = field.getName();
            if (tmp != null) {
                buffer.append(tmp);
            }
            buffer.append(": ");
            tmp = field.getValue();
            if (tmp != null) {
                buffer.append(tmp);
            }
            buffer.append("\r\n");
        }
        buffer.append("\r\n");
        return buffer.toString();
    }

    default public boolean contains(HttpField field) {
        for (HttpField f : this) {
            if (!f.isSameName(field) || !f.equals(field) && !f.contains(field.getValue())) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(HttpHeader header, String value) {
        for (HttpField f : this) {
            if (f.getHeader() != header || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(String name, String value) {
        for (HttpField f : this) {
            if (!f.is(name) || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(HttpHeader header) {
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(EnumSet<HttpHeader> headers) {
        for (HttpField f : this) {
            if (!headers.contains((Object)f.getHeader())) continue;
            return true;
        }
        return false;
    }

    default public boolean contains(String name) {
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            return true;
        }
        return false;
    }

    default public String get(HttpHeader header) {
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            return f.getValue();
        }
        return null;
    }

    default public String get(String header) {
        for (HttpField f : this) {
            if (!f.is(header)) continue;
            return f.getValue();
        }
        return null;
    }

    default public List<String> getCSV(HttpHeader header, boolean keepQuotes) {
        QuotedCSV values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = new QuotedCSV(keepQuotes, new String[0]);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public List<String> getCSV(String name, boolean keepQuotes) {
        QuotedCSV values = null;
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            if (values == null) {
                values = new QuotedCSV(keepQuotes, new String[0]);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public long getDateField(String name) {
        return HttpFields.parseDateField(this.getField(name));
    }

    default public long getDateField(HttpHeader header) {
        return HttpFields.parseDateField(this.getField(header));
    }

    public static long parseDateField(HttpField field) {
        if (field == null) {
            return -1L;
        }
        String val = HttpField.getValueParameters(field.getValue(), null);
        if (val == null) {
            return -1L;
        }
        long date = DateParser.parseDate(val);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        return date;
    }

    default public HttpField getField(int index) {
        int i = 0;
        for (HttpField f : this) {
            if (i++ != index) continue;
            return f;
        }
        return null;
    }

    default public HttpField getField(HttpHeader header) {
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            return f;
        }
        return null;
    }

    default public HttpField getField(String name) {
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            return f;
        }
        return null;
    }

    @Deprecated
    default public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    default public Set<String> getFieldNamesCollection() {
        return this.stream().map(HttpField::getName).collect(Collectors.toSet());
    }

    default public List<HttpField> getFields(HttpHeader header) {
        return this.getFields(header, (f, h) -> f.getHeader() == h);
    }

    default public List<HttpField> getFields(String name) {
        return this.getFields(name, (f, n) -> f.is(name));
    }

    private <T> List<HttpField> getFields(T header, BiPredicate<HttpField, T> predicate) {
        return this.stream().filter(f -> predicate.test((HttpField)f, header)).collect(Collectors.toList());
    }

    default public long getLongField(String name) throws NumberFormatException {
        HttpField field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    default public long getLongField(HttpHeader header) throws NumberFormatException {
        HttpField field = this.getField(header);
        return field == null ? -1L : field.getLongValue();
    }

    default public List<String> getQualityCSV(HttpHeader header) {
        return this.getQualityCSV(header, null);
    }

    default public List<String> getQualityCSV(HttpHeader header, ToIntFunction<String> secondaryOrdering) {
        QuotedQualityCSV values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = new QuotedQualityCSV(secondaryOrdering);
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public List<String> getQualityCSV(String name) {
        QuotedQualityCSV values = null;
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            if (values == null) {
                values = new QuotedQualityCSV();
            }
            values.addValue(f.getValue());
        }
        return values == null ? Collections.emptyList() : values.getValues();
    }

    default public Enumeration<String> getValues(final String name) {
        final Iterator i = this.iterator();
        return new Enumeration<String>(){
            HttpField _field;

            @Override
            public boolean hasMoreElements() {
                if (this._field != null) {
                    return true;
                }
                while (i.hasNext()) {
                    HttpField f = (HttpField)i.next();
                    if (!f.is(name) || f.getValue() == null) continue;
                    this._field = f;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String value = this._field.getValue();
                    this._field = null;
                    return value;
                }
                throw new NoSuchElementException();
            }
        };
    }

    default public List<String> getValuesList(HttpHeader header) {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            list.add(f.getValue());
        }
        return list;
    }

    default public List<String> getValuesList(String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            list.add(f.getValue());
        }
        return list;
    }

    default public boolean isEqualTo(HttpFields that) {
        if (this.size() != that.size()) {
            return false;
        }
        Iterator i = that.iterator();
        for (HttpField f : this) {
            if (!i.hasNext()) {
                return false;
            }
            if (f.equals(i.next())) continue;
            return false;
        }
        return !i.hasNext();
    }

    default public int size() {
        int s = 0;
        for (HttpField f : this) {
            ++s;
        }
        return s;
    }

    default public Stream<HttpField> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), false);
    }

    public static class MutableHttpFields
    implements Mutable {
        private static final int INITIAL_SIZE = 16;
        private static final int SIZE_INCREMENT = 4;
        private HttpField[] _fields;
        private int _size;

        protected MutableHttpFields() {
            this(16);
        }

        protected MutableHttpFields(int capacity) {
            this._fields = new HttpField[capacity];
        }

        protected MutableHttpFields(HttpFields fields) {
            this.add(fields);
        }

        protected MutableHttpFields(HttpFields fields, HttpField replaceField) {
            this._fields = new HttpField[fields.size() + 4];
            this._size = 0;
            boolean put = false;
            for (HttpField f : fields) {
                if (replaceField.isSameName(f)) {
                    if (!put) {
                        this._fields[this._size++] = replaceField;
                    }
                    put = true;
                    continue;
                }
                this._fields[this._size++] = f;
            }
            if (!put) {
                this._fields[this._size++] = replaceField;
            }
        }

        protected MutableHttpFields(HttpFields fields, EnumSet<HttpHeader> removeFields) {
            this._fields = new HttpField[fields.size() + 4];
            this._size = 0;
            for (HttpField f : fields) {
                if (f.getHeader() != null && removeFields.contains((Object)f.getHeader())) continue;
                this._fields[this._size++] = f;
            }
        }

        @Override
        public Mutable add(HttpField field) {
            if (field != null) {
                if (this._fields == null) {
                    this._fields = new HttpField[16];
                }
                if (this._size == this._fields.length) {
                    this._fields = Arrays.copyOf(this._fields, this._size + 4);
                }
                this._fields[this._size++] = field;
            }
            return this;
        }

        @Override
        public Mutable add(HttpFields fields) {
            if (this._fields == null) {
                this._fields = new HttpField[fields.size() + 4];
            } else if (this._size + fields.size() >= this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size + fields.size() + 4);
            }
            if (fields.size() == 0) {
                return this;
            }
            if (fields instanceof ImmutableHttpFields) {
                ImmutableHttpFields immutable = (ImmutableHttpFields)fields;
                System.arraycopy(immutable._fields, 0, this._fields, this._size, immutable._size);
                this._size += immutable._size;
            } else if (fields instanceof MutableHttpFields) {
                MutableHttpFields mutable = (MutableHttpFields)fields;
                System.arraycopy(mutable._fields, 0, this._fields, this._size, mutable._size);
                this._size += mutable._size;
            } else {
                for (HttpField f : fields) {
                    this._fields[this._size++] = f;
                }
            }
            return this;
        }

        @Override
        public HttpFields asImmutable() {
            return new ImmutableHttpFields(Arrays.copyOf(this._fields, this._size));
        }

        @Override
        public HttpFields takeAsImmutable() {
            HttpField[] fields = this._fields == null ? new HttpField[]{} : this._fields;
            int size = this._size;
            this._fields = null;
            this._size = 0;
            return new ImmutableHttpFields(fields, size);
        }

        @Override
        public Mutable clear() {
            this._size = 0;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MutableHttpFields)) {
                return false;
            }
            return this.isEqualTo((HttpFields)o);
        }

        @Override
        public HttpField getField(int index) {
            if (index >= this._size || index < 0) {
                throw new NoSuchElementException();
            }
            return this._fields[index];
        }

        public int hashCode() {
            int hash = 0;
            int i = this._fields.length;
            while (i-- > 0) {
                hash ^= this._fields[i].hashCode();
            }
            return hash;
        }

        @Override
        public Iterator<HttpField> iterator() {
            return new Iterator<HttpField>(){
                int _index = 0;

                @Override
                public boolean hasNext() {
                    return this._index < _size;
                }

                @Override
                public HttpField next() {
                    return _fields[this._index++];
                }

                @Override
                public void remove() {
                    if (_size == 0) {
                        throw new IllegalStateException();
                    }
                    this.remove(--this._index);
                }
            };
        }

        @Override
        public ListIterator<HttpField> listIterator() {
            return new ListItr();
        }

        @Override
        public Mutable put(HttpField field) {
            boolean put = false;
            for (int i = 0; i < this._size; ++i) {
                HttpField f = this._fields[i];
                if (!f.isSameName(field)) continue;
                if (put) {
                    System.arraycopy(this._fields, i + 1, this._fields, i, this._size-- - i-- - 1);
                    continue;
                }
                this._fields[i] = field;
                put = true;
            }
            if (!put) {
                this.add(field);
            }
            return this;
        }

        @Override
        public Mutable put(String name, String value) {
            return value == null ? this.remove(name) : this.put(new HttpField(name, value));
        }

        @Override
        public Mutable put(HttpHeader header, HttpHeaderValue value) {
            return this.put(header, value.toString());
        }

        @Override
        public Mutable put(HttpHeader header, String value) {
            return value == null ? this.remove(header) : this.put(new HttpField(header, value));
        }

        @Override
        public Mutable put(String name, List<String> list) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(list);
            this.remove(name);
            for (String v : list) {
                if (v == null) continue;
                this.add(name, v);
            }
            return this;
        }

        @Override
        public void computeField(HttpHeader header, BiFunction<HttpHeader, List<HttpField>, HttpField> computeFn) {
            this.computeField(header, computeFn, (f, h) -> f.getHeader() == h);
        }

        @Override
        public void computeField(String name, BiFunction<String, List<HttpField>, HttpField> computeFn) {
            this.computeField(name, computeFn, HttpField::is);
        }

        public <T> void computeField(T header, BiFunction<T, List<HttpField>, HttpField> computeFn, BiPredicate<HttpField, T> matcher) {
            int first = -1;
            for (int i = 0; i < this._size; ++i) {
                HttpField f = this._fields[i];
                if (!matcher.test(f, (HttpField)header)) continue;
                first = i;
                break;
            }
            if (first < 0) {
                HttpField newField = computeFn.apply(header, null);
                if (newField != null) {
                    this.add(newField);
                }
                return;
            }
            List<Object> found = null;
            for (int i = first + 1; i < this._size; ++i) {
                HttpField f = this._fields[i];
                if (!matcher.test(f, (HttpField)header)) continue;
                if (found == null) {
                    found = new ArrayList();
                    found.add(this._fields[first]);
                }
                found.add(f);
                this.remove(i--);
            }
            HttpField newField = computeFn.apply(header, found = found == null ? Collections.singletonList(this._fields[first]) : Collections.unmodifiableList(found));
            if (newField == null) {
                this.remove(first);
            } else {
                this._fields[first] = newField;
            }
        }

        @Override
        public Mutable remove(HttpHeader name) {
            for (int i = 0; i < this._size; ++i) {
                HttpField f = this._fields[i];
                if (f.getHeader() != name) continue;
                this.remove(i--);
            }
            return this;
        }

        @Override
        public Mutable remove(EnumSet<HttpHeader> fields) {
            for (int i = 0; i < this._size; ++i) {
                HttpField f = this._fields[i];
                if (!fields.contains((Object)f.getHeader())) continue;
                this.remove(i--);
            }
            return this;
        }

        @Override
        public Mutable remove(String name) {
            for (int i = 0; i < this._size; ++i) {
                HttpField f = this._fields[i];
                if (!f.is(name)) continue;
                this.remove(i--);
            }
            return this;
        }

        private void remove(int i) {
            --this._size;
            System.arraycopy(this._fields, i + 1, this._fields, i, this._size - i);
            this._fields[this._size] = null;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public Stream<HttpField> stream() {
            return Arrays.stream(this._fields, 0, this._size);
        }

        public String toString() {
            return this.asString();
        }

        private class ListItr
        implements ListIterator<HttpField> {
            int _cursor;
            int _current = -1;

            private ListItr() {
            }

            @Override
            public void add(HttpField field) {
                if (field == null) {
                    return;
                }
                int last = MutableHttpFields.this._size++;
                if (MutableHttpFields.this._fields.length < MutableHttpFields.this._size) {
                    MutableHttpFields.this._fields = Arrays.copyOf(MutableHttpFields.this._fields, MutableHttpFields.this._fields.length + 4);
                }
                System.arraycopy(MutableHttpFields.this._fields, this._cursor, MutableHttpFields.this._fields, this._cursor + 1, last - this._cursor);
                MutableHttpFields.this._fields[this._cursor++] = field;
                this._current = -1;
            }

            @Override
            public boolean hasNext() {
                return this._cursor != MutableHttpFields.this._size;
            }

            @Override
            public boolean hasPrevious() {
                return this._cursor > 0;
            }

            @Override
            public HttpField next() {
                if (this._cursor == MutableHttpFields.this._size) {
                    throw new NoSuchElementException();
                }
                this._current = this._cursor++;
                return MutableHttpFields.this._fields[this._current];
            }

            @Override
            public int nextIndex() {
                return this._cursor + 1;
            }

            @Override
            public HttpField previous() {
                if (this._cursor == 0) {
                    throw new NoSuchElementException();
                }
                this._current = --this._cursor;
                return MutableHttpFields.this._fields[this._current];
            }

            @Override
            public int previousIndex() {
                return this._cursor - 1;
            }

            @Override
            public void remove() {
                if (this._current < 0) {
                    throw new IllegalStateException();
                }
                MutableHttpFields.this.remove(this._current);
                this._cursor = this._current;
                this._current = -1;
            }

            @Override
            public void set(HttpField field) {
                if (this._current < 0) {
                    throw new IllegalStateException();
                }
                if (field == null) {
                    this.remove();
                } else {
                    MutableHttpFields.this._fields[this._current] = field;
                }
            }
        }
    }

    public static class ImmutableHttpFields
    implements HttpFields {
        final HttpField[] _fields;
        final int _size;

        protected ImmutableHttpFields(HttpField[] fields) {
            this(fields, fields.length);
        }

        protected ImmutableHttpFields(HttpField[] fields, int size) {
            Objects.requireNonNull(fields);
            this._fields = fields;
            this._size = size;
        }

        @Override
        public HttpFields asImmutable() {
            return this;
        }

        @Override
        public HttpFields takeAsImmutable() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImmutableHttpFields)) {
                return false;
            }
            return this.isEqualTo((HttpFields)o);
        }

        @Override
        public String get(String header) {
            for (HttpField f : this._fields) {
                if (f == null || !f.is(header)) continue;
                return f.getValue();
            }
            return null;
        }

        @Override
        public String get(HttpHeader header) {
            for (HttpField f : this._fields) {
                if (f == null || f.getHeader() != header) continue;
                return f.getValue();
            }
            return null;
        }

        @Override
        public HttpField getField(HttpHeader header) {
            for (HttpField f : this._fields) {
                if (f == null || f.getHeader() != header) continue;
                return f;
            }
            return null;
        }

        @Override
        public HttpField getField(String name) {
            for (HttpField f : this._fields) {
                if (f == null || !f.is(name)) continue;
                return f;
            }
            return null;
        }

        @Override
        public HttpField getField(int index) {
            if (index >= this._fields.length) {
                throw new NoSuchElementException();
            }
            return this._fields[index];
        }

        public int hashCode() {
            int hash = 0;
            int i = this._fields.length;
            while (i-- > 0) {
                hash ^= this._fields[i].hashCode();
            }
            return hash;
        }

        @Override
        public Iterator<HttpField> iterator() {
            return new Iterator<HttpField>(){
                int _index = 0;

                @Override
                public boolean hasNext() {
                    return this._index < _size;
                }

                @Override
                public HttpField next() {
                    return _fields[this._index++];
                }
            };
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public Stream<HttpField> stream() {
            return Arrays.stream(this._fields).filter(Objects::nonNull);
        }

        public String toString() {
            return this.asString();
        }
    }

    public static interface Mutable
    extends Iterable<HttpField>,
    HttpFields {
        default public Mutable add(String name, String value) {
            if (value != null) {
                return this.add(new HttpField(name, value));
            }
            return this;
        }

        default public Mutable add(HttpHeader header, HttpHeaderValue value) {
            return this.add(header, value.toString());
        }

        default public Mutable add(HttpHeader header, String value) {
            if (value == null) {
                throw new IllegalArgumentException("null value");
            }
            HttpField field = new HttpField(header, value);
            return this.add(field);
        }

        default public Mutable add(HttpField field) {
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                i.next();
            }
            i.add(field);
            return this;
        }

        default public Mutable add(HttpFields fields) {
            for (HttpField field : fields) {
                this.add(field);
            }
            return this;
        }

        default public Mutable addCSV(HttpHeader header, String ... values) {
            QuotedCSVParser existing = null;
            for (HttpField f : this) {
                if (f.getHeader() != header) continue;
                if (existing == null) {
                    existing = new QuotedCSV(false, new String[0]);
                }
                existing.addValue(f.getValue());
            }
            String value = Mutable.formatCsvExcludingExisting(existing, values);
            if (value != null) {
                this.add(header, value);
            }
            return this;
        }

        default public Mutable addCSV(String name, String ... values) {
            QuotedCSVParser existing = null;
            for (HttpField f : this) {
                if (!f.is(name)) continue;
                if (existing == null) {
                    existing = new QuotedCSV(false, new String[0]);
                }
                existing.addValue(f.getValue());
            }
            String value = Mutable.formatCsvExcludingExisting(existing, values);
            if (value != null) {
                this.add(name, value);
            }
            return this;
        }

        default public Mutable addDateField(String name, long date) {
            this.add(name, DateGenerator.formatDate(date));
            return this;
        }

        default public Mutable clear() {
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            return this;
        }

        default public void ensureField(HttpField field) {
            if (field.getValue().indexOf(44) < 0) {
                if (field.getHeader() != null) {
                    this.computeField(field.getHeader(), (HttpHeader h, List<HttpField> l) -> Mutable.computeEnsure(field, l));
                } else {
                    this.computeField(field.getName(), (String h, List<HttpField> l) -> Mutable.computeEnsure(field, l));
                }
            } else if (field.getHeader() != null) {
                this.computeField(field.getHeader(), (HttpHeader h, List<HttpField> l) -> Mutable.computeEnsure(field, field.getValues(), l));
            } else {
                this.computeField(field.getName(), (String h, List<HttpField> l) -> Mutable.computeEnsure(field, field.getValues(), l));
            }
        }

        @Override
        default public Iterator<HttpField> iterator() {
            return this.listIterator();
        }

        public ListIterator<HttpField> listIterator();

        default public Mutable put(HttpField field) {
            boolean put = false;
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                if (!f.isSameName(field)) continue;
                if (put) {
                    i.remove();
                    continue;
                }
                i.set(field);
                put = true;
            }
            if (!put) {
                this.add(field);
            }
            return this;
        }

        default public Mutable put(String name, String value) {
            if (value == null) {
                return this.remove(name);
            }
            return this.put(new HttpField(name, value));
        }

        default public Mutable put(HttpHeader header, HttpHeaderValue value) {
            if (value == null) {
                return this.remove(header);
            }
            return this.put(new HttpField(header, value.toString()));
        }

        default public Mutable put(HttpHeader header, String value) {
            if (value == null) {
                return this.remove(header);
            }
            return this.put(new HttpField(header, value));
        }

        default public Mutable put(String name, List<String> list) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(list);
            boolean first = true;
            for (String s : list) {
                HttpField field = new HttpField(name, s);
                if (first) {
                    this.put(field);
                } else {
                    this.add(field);
                }
                first = false;
            }
            return this;
        }

        default public Mutable putDateField(HttpHeader name, long date) {
            return this.put(name, DateGenerator.formatDate(date));
        }

        default public Mutable putDateField(String name, long date) {
            return this.put(name, DateGenerator.formatDate(date));
        }

        default public Mutable putLongField(HttpHeader name, long value) {
            return this.put(new HttpField.LongValueHttpField(name, value));
        }

        default public Mutable putLongField(String name, long value) {
            return this.put(name, Long.toString(value));
        }

        default public void computeField(HttpHeader header, BiFunction<HttpHeader, List<HttpField>, HttpField> computeFn) {
            this.put(computeFn.apply(header, this.stream().filter(f -> f.getHeader() == header).collect(Collectors.toList())));
        }

        default public void computeField(String name, BiFunction<String, List<HttpField>, HttpField> computeFn) {
            this.put(computeFn.apply(name, this.stream().filter(f -> f.is(name)).collect(Collectors.toList())));
        }

        default public Mutable remove(HttpHeader header) {
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                if (f.getHeader() != header) continue;
                i.remove();
            }
            return this;
        }

        default public Mutable remove(EnumSet<HttpHeader> fields) {
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                HttpHeader h = f.getHeader();
                if (h == null || !fields.contains((Object)h)) continue;
                i.remove();
            }
            return this;
        }

        default public Mutable remove(String name) {
            ListIterator<HttpField> i = this.listIterator();
            while (i.hasNext()) {
                HttpField f = i.next();
                if (!f.is(name)) continue;
                i.remove();
            }
            return this;
        }

        public static String formatCsvExcludingExisting(QuotedCSV existing, String ... values) {
            boolean add = true;
            if (existing != null && !existing.isEmpty()) {
                add = false;
                int i = values.length;
                while (i-- > 0) {
                    String unquoted = QuotedCSV.unquote(values[i]);
                    if (existing.getValues().contains(unquoted)) {
                        values[i] = null;
                        continue;
                    }
                    add = true;
                }
            }
            if (add) {
                StringBuilder value = new StringBuilder();
                for (String v : values) {
                    if (v == null) continue;
                    if (value.length() > 0) {
                        value.append(", ");
                    }
                    value.append(v);
                }
                if (value.length() > 0) {
                    return value.toString();
                }
            }
            return null;
        }

        public static HttpField computeEnsure(HttpField ensure, List<HttpField> fields) {
            if (fields == null || fields.isEmpty()) {
                return ensure;
            }
            String ensureValue = ensure.getValue();
            if (fields.size() == 1) {
                HttpField f = fields.get(0);
                return f.contains(ensureValue) ? f : new HttpField(ensure.getHeader(), ensure.getName(), f.getValue() + ", " + ensureValue);
            }
            StringBuilder v = new StringBuilder();
            for (HttpField f : fields) {
                if (v.length() > 0) {
                    v.append(", ");
                }
                v.append(f.getValue());
                if (ensureValue == null || !f.contains(ensureValue)) continue;
                ensureValue = null;
            }
            if (ensureValue != null) {
                v.append(", ").append(ensureValue);
            }
            return new HttpField(ensure.getHeader(), ensure.getName(), v.toString());
        }

        public static HttpField computeEnsure(HttpField ensure, String[] values, List<HttpField> fields) {
            if (fields == null || fields.isEmpty()) {
                return ensure;
            }
            if (fields.size() == 1) {
                HttpField f = fields.get(0);
                int ensured = values.length;
                for (int i = 0; i < values.length; ++i) {
                    if (!f.contains(values[i])) continue;
                    --ensured;
                    values[i] = null;
                }
                if (ensured == 0) {
                    return f;
                }
                if (ensured == values.length) {
                    return new HttpField(ensure.getHeader(), ensure.getName(), f.getValue() + ", " + ensure.getValue());
                }
                StringBuilder v = new StringBuilder(f.getValue());
                for (String value : values) {
                    if (value == null) continue;
                    v.append(", ").append(value);
                }
                return new HttpField(ensure.getHeader(), ensure.getName(), v.toString());
            }
            StringBuilder v = new StringBuilder();
            int ensured = values.length;
            for (HttpField f : fields) {
                if (v.length() > 0) {
                    v.append(", ");
                }
                v.append(f.getValue());
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || !f.contains(values[i])) continue;
                    --ensured;
                    values[i] = null;
                }
            }
            if (ensured == values.length) {
                v.append(", ").append(ensure.getValue());
            } else if (ensured > 0) {
                for (String value : values) {
                    if (value == null) continue;
                    v.append(", ").append(value);
                }
            }
            return new HttpField(ensure.getHeader(), ensure.getName(), v.toString());
        }
    }
}

