/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.compression;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.EncodingException;
import org.eclipse.jetty.http.compression.Huffman;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class HuffmanDecoder {
    private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
    private int _length = 0;
    private int _count = 0;
    private int _node = 0;
    private int _current = 0;
    private int _bits = 0;

    public static String decode(ByteBuffer buffer, int length) throws EncodingException {
        HuffmanDecoder huffmanDecoder = new HuffmanDecoder();
        huffmanDecoder.setLength(length);
        String decoded = huffmanDecoder.decode(buffer);
        if (decoded == null) {
            throw new EncodingException("invalid string encoding");
        }
        huffmanDecoder.reset();
        return decoded;
    }

    public void setLength(int length) {
        if (this._count != 0) {
            throw new IllegalStateException();
        }
        this._length = length;
    }

    public String decode(ByteBuffer buffer) throws EncodingException {
        while (this._count < this._length) {
            if (!buffer.hasRemaining()) {
                return null;
            }
            int b = buffer.get() & 0xFF;
            this._current = this._current << 8 | b;
            this._bits += 8;
            while (this._bits >= 8) {
                int c = this._current >>> this._bits - 8 & 0xFF;
                this._node = Huffman.tree[this._node * 256 + c];
                if (Huffman.rowbits[this._node] != 0) {
                    if (Huffman.rowsym[this._node] == '\u0100') {
                        this.reset();
                        throw new EncodingException("eos_in_content");
                    }
                    this._utf8.append((byte)(0xFF & Huffman.rowsym[this._node]));
                    this._bits -= Huffman.rowbits[this._node];
                    this._node = 0;
                    continue;
                }
                this._bits -= 8;
            }
            ++this._count;
        }
        while (this._bits > 0) {
            int c = this._current << 8 - this._bits & 0xFF;
            int lastNode = this._node;
            this._node = Huffman.tree[this._node * 256 + c];
            if (Huffman.rowbits[this._node] == 0 || Huffman.rowbits[this._node] > this._bits) {
                int requiredPadding = 0;
                for (int i = 0; i < this._bits; ++i) {
                    requiredPadding = requiredPadding << 1 | 1;
                }
                if (c >> 8 - this._bits != requiredPadding) {
                    throw new EncodingException("incorrect_padding");
                }
                this._node = lastNode;
                break;
            }
            this._utf8.append((byte)(0xFF & Huffman.rowsym[this._node]));
            this._bits -= Huffman.rowbits[this._node];
            this._node = 0;
        }
        if (this._node != 0) {
            this.reset();
            throw new EncodingException("bad_termination");
        }
        String value = this._utf8.toCompleteString();
        this.reset();
        return value;
    }

    public void reset() {
        this._utf8.reset();
        this._count = 0;
        this._current = 0;
        this._node = 0;
        this._bits = 0;
    }
}

