/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.compression;

import java.nio.ByteBuffer;

public class NBitIntegerEncoder {
    public static int octetsNeeded(int n, long i) {
        if (n == 8) {
            int nbits = 255;
            if ((i -= (long)nbits) < 0L) {
                return 1;
            }
            if (i == 0L) {
                return 2;
            }
            int lz = Long.numberOfLeadingZeros(i);
            int log = 64 - lz;
            return 1 + (log + 6) / 7;
        }
        int nbits = 255 >>> 8 - n;
        if ((i -= (long)nbits) < 0L) {
            return 0;
        }
        if (i == 0L) {
            return 1;
        }
        int lz = Long.numberOfLeadingZeros(i);
        int log = 64 - lz;
        return (log + 6) / 7;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void encode(ByteBuffer buf, int n, long i) {
        int bits;
        int p;
        if (n != 8) {
            p = buf.position() - 1;
            bits = 255 >>> 8 - n;
            if (i < (long)bits) {
                buf.put(p, (byte)((long)(buf.get(p) & ~bits) | i));
                return;
            }
        } else {
            if (i < 255L) {
                buf.put((byte)i);
                return;
            }
            buf.put((byte)-1);
            long length = i - 255L;
            while (true) {
                if ((length & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    buf.put((byte)length);
                    return;
                }
                buf.put((byte)(length & 0x7FL | 0x80L));
                length >>>= 7;
            }
        }
        buf.put(p, (byte)(buf.get(p) | bits));
        long length = i - (long)bits;
        while (true) {
            if ((length & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buf.put((byte)length);
                return;
            }
            buf.put((byte)(length & 0x7FL | 0x80L));
            length >>>= 7;
        }
    }
}

