/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.ByteRange;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.thread.AutoLock;

public class MultiPartByteRanges
extends CompletableFuture<Parts> {
    private final PartsListener listener = new PartsListener();
    private final MultiPart.Parser parser;

    public MultiPartByteRanges(String boundary) {
        this.parser = new MultiPart.Parser(boundary, this.listener);
    }

    public String getBoundary() {
        return this.parser.getBoundary();
    }

    @Override
    public boolean completeExceptionally(Throwable failure) {
        this.listener.fail(failure);
        return super.completeExceptionally(failure);
    }

    public MultiPartByteRanges parse(final Content.Source content) {
        new Runnable(){

            @Override
            public void run() {
                Content.Chunk chunk;
                do {
                    if ((chunk = content.read()) == null) {
                        content.demand((Runnable)this);
                        return;
                    }
                    if (chunk instanceof Content.Chunk.Error) {
                        Content.Chunk.Error error = (Content.Chunk.Error)chunk;
                        MultiPartByteRanges.this.listener.onFailure(error.getCause());
                        return;
                    }
                    MultiPartByteRanges.this.parse(chunk);
                    chunk.release();
                } while (!chunk.isLast() && !MultiPartByteRanges.this.isDone());
            }
        }.run();
        return this;
    }

    private void parse(Content.Chunk chunk) {
        if (this.listener.isFailed()) {
            return;
        }
        this.parser.parse(chunk);
    }

    private class PartsListener
    extends MultiPart.AbstractPartsListener {
        private final AutoLock lock = new AutoLock();
        private final List<Content.Chunk> partChunks = new ArrayList<Content.Chunk>();
        private final List<MultiPart.Part> parts = new ArrayList<MultiPart.Part>();
        private Throwable failure;

        private PartsListener() {
        }

        private boolean isFailed() {
            try (AutoLock ignored = this.lock.lock();){
                boolean bl = this.failure != null;
                return bl;
            }
        }

        @Override
        public void onPartContent(Content.Chunk chunk) {
            try (AutoLock ignored = this.lock.lock();){
                chunk.retain();
                this.partChunks.add(chunk);
            }
        }

        @Override
        public void onPart(String name, String fileName, HttpFields headers) {
            try (AutoLock ignored = this.lock.lock();){
                this.parts.add(new MultiPart.ChunksPart(name, fileName, headers, List.copyOf(this.partChunks)));
                this.partChunks.forEach(Retainable::release);
                this.partChunks.clear();
            }
        }

        @Override
        public void onComplete() {
            List<MultiPart.Part> copy;
            super.onComplete();
            try (AutoLock ignored = this.lock.lock();){
                copy = List.copyOf(this.parts);
            }
            MultiPartByteRanges.this.complete(new Parts(MultiPartByteRanges.this.getBoundary(), copy));
        }

        @Override
        public void onFailure(Throwable failure) {
            super.onFailure(failure);
            MultiPartByteRanges.this.completeExceptionally(failure);
        }

        private void fail(Throwable cause) {
            List<MultiPart.Part> partsToFail;
            try (AutoLock ignored = this.lock.lock();){
                if (this.failure != null) {
                    return;
                }
                this.failure = cause;
                partsToFail = List.copyOf(this.parts);
                this.parts.clear();
                this.partChunks.forEach(Retainable::release);
                this.partChunks.clear();
            }
            partsToFail.forEach(p -> p.fail(cause));
        }
    }

    public static class Part
    extends MultiPart.Part {
        private final Path path;
        private final ByteRange byteRange;

        public Part(String contentType, Path path, ByteRange byteRange, long contentLength) {
            this(HttpFields.build().put(HttpHeader.CONTENT_TYPE, contentType).put(HttpHeader.CONTENT_RANGE, byteRange.toHeaderValue(contentLength)), path, byteRange);
        }

        public Part(HttpFields headers, Path path, ByteRange byteRange) {
            super(null, null, headers);
            this.path = path;
            this.byteRange = byteRange;
        }

        @Override
        public Content.Source newContentSource() {
            return new PathContentSource(this.path, this.byteRange);
        }
    }

    public static class PathContentSource
    extends org.eclipse.jetty.io.content.PathContentSource {
        private final ByteRange byteRange;

        public PathContentSource(Path path, ByteRange byteRange) {
            super(path);
            this.byteRange = byteRange;
        }

        protected SeekableByteChannel open() throws IOException {
            SeekableByteChannel channel = super.open();
            channel.position(this.byteRange.first());
            return channel;
        }

        protected int read(SeekableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
            int read = super.read(channel, byteBuffer);
            if (read < 0) {
                return read;
            }
            read = (int)Math.min((long)read, this.byteRange.getLength());
            byteBuffer.position(read);
            return read;
        }

        protected boolean isReadComplete(long read) {
            return read == this.byteRange.getLength();
        }
    }

    public static class ContentSource
    extends MultiPart.AbstractContentSource {
        public ContentSource(String boundary) {
            super(boundary);
        }

        @Override
        public boolean addPart(MultiPart.Part part) {
            if (part instanceof Part) {
                return super.addPart(part);
            }
            return false;
        }
    }

    public static class Parts
    implements Iterable<MultiPart.Part> {
        private final String boundary;
        private final List<MultiPart.Part> parts;

        private Parts(String boundary, List<MultiPart.Part> parts) {
            this.boundary = boundary;
            this.parts = parts;
        }

        public String getBoundary() {
            return this.boundary;
        }

        public MultiPart.Part get(int index) {
            return this.parts.get(index);
        }

        public int size() {
            return this.parts.size();
        }

        @Override
        public Iterator<MultiPart.Part> iterator() {
            return this.parts.iterator();
        }
    }
}

