/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;

public class HttpTester {
    public static Input from(String string) {
        return HttpTester.from(BufferUtil.toBuffer((String)string));
    }

    public static Input from(ByteBuffer data) {
        return new Input(data){

            @Override
            public int fillBuffer() {
                this._eof = true;
                return -1;
            }
        };
    }

    public static Input from(final InputStream stream) {
        return new Input(){

            @Override
            public int fillBuffer() throws IOException {
                BufferUtil.compact((ByteBuffer)this._buffer);
                int len = stream.read(this._buffer.array(), this._buffer.arrayOffset() + this._buffer.limit(), BufferUtil.space((ByteBuffer)this._buffer));
                if (len < 0) {
                    this._eof = true;
                } else {
                    this._buffer.limit(this._buffer.limit() + len);
                }
                return len;
            }
        };
    }

    public static Input from(final ReadableByteChannel channel) {
        return new Input(){

            @Override
            public int fillBuffer() throws IOException {
                BufferUtil.compact((ByteBuffer)this._buffer);
                int pos = BufferUtil.flipToFill((ByteBuffer)this._buffer);
                int len = channel.read(this._buffer);
                if (len < 0) {
                    this._eof = true;
                }
                BufferUtil.flipToFlush((ByteBuffer)this._buffer, (int)pos);
                return len;
            }
        };
    }

    public static Request newRequest() {
        Request r = new Request();
        r.setMethod(HttpMethod.GET.asString());
        r.setURI("/");
        r.setVersion(HttpVersion.HTTP_1_1);
        r.setHeader("Host", "localhost");
        return r;
    }

    public static Request parseRequest(String request) {
        return HttpTester.parseRequest(BufferUtil.toBuffer((String)request));
    }

    public static Request parseRequest(ByteBuffer buffer) {
        try {
            return HttpTester.parseRequest(HttpTester.from(buffer));
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    public static Request parseRequest(InputStream stream) throws IOException {
        return HttpTester.parseRequest(HttpTester.from(stream));
    }

    public static Request parseRequest(ReadableByteChannel channel) throws IOException {
        return HttpTester.parseRequest(HttpTester.from(channel));
    }

    public static Request parseRequest(Input input) throws IOException {
        Request request;
        HttpParser parser = input.takeHttpParser();
        if (parser != null) {
            request = (Request)parser.getHandler();
        } else {
            request = HttpTester.newRequest();
            parser = new HttpParser(request);
        }
        HttpTester.parse(input, parser);
        if (request.isComplete()) {
            return request;
        }
        input.setHttpParser(parser);
        return null;
    }

    public static Response parseHeadResponse(String response) {
        return HttpTester.parseResponse(response, true);
    }

    public static Response parseResponse(String response) {
        return HttpTester.parseResponse(response, false);
    }

    private static Response parseResponse(String response, boolean head) {
        return HttpTester.parseResponse(BufferUtil.toBuffer((String)response), head);
    }

    public static Response parseHeadResponse(ByteBuffer response) {
        return HttpTester.parseResponse(response, true);
    }

    public static Response parseResponse(ByteBuffer response) {
        return HttpTester.parseResponse(response, false);
    }

    private static Response parseResponse(ByteBuffer response, boolean head) {
        try {
            return HttpTester.parseResponse(HttpTester.from(response), head);
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    public static Response parseResponse(InputStream stream) throws IOException {
        return HttpTester.parseResponse(HttpTester.from(stream));
    }

    public static Response parseResponse(ReadableByteChannel channel) throws IOException {
        return HttpTester.parseResponse(HttpTester.from(channel));
    }

    public static Response parseResponse(Input input) throws IOException {
        return HttpTester.parseResponse(input, false);
    }

    public static Response parseResponse(Input input, boolean head) throws IOException {
        Response response;
        HttpParser parser = input.takeHttpParser();
        if (parser != null) {
            response = (Response)parser.getHandler();
        } else {
            response = new Response();
            parser = new HttpParser(response);
        }
        parser.setHeadResponse(head);
        HttpTester.parse(input, parser);
        if (response.isComplete()) {
            return response;
        }
        input.setHttpParser(parser);
        return null;
    }

    private static void parse(Input input, HttpParser parser) throws IOException {
        int len;
        ByteBuffer buffer = input.getBuffer();
        while (!(BufferUtil.hasContent((ByteBuffer)buffer) && parser.parseNext(buffer) || (len = input.fillBuffer()) == 0)) {
            if (len >= 0) continue;
            parser.atEOF();
            parser.parseNext(buffer);
            break;
        }
    }

    private HttpTester() {
    }

    public static abstract class Input {
        protected final ByteBuffer _buffer;
        protected boolean _eof = false;
        protected HttpParser _parser;

        public Input() {
            this(BufferUtil.allocate((int)8192));
        }

        Input(ByteBuffer buffer) {
            this._buffer = buffer;
        }

        public ByteBuffer getBuffer() {
            return this._buffer;
        }

        public void setHttpParser(HttpParser parser) {
            this._parser = parser;
        }

        public HttpParser takeHttpParser() {
            HttpParser p = this._parser;
            this._parser = null;
            return p;
        }

        public boolean isEOF() {
            return BufferUtil.isEmpty((ByteBuffer)this._buffer) && this._eof;
        }

        public abstract int fillBuffer() throws IOException;
    }

    public static class Request
    extends Message
    implements HttpParser.RequestHandler {
        private String _method;
        private String _uri;

        @Override
        public void startRequest(String method, String uri, HttpVersion version) {
            this._method = method;
            this._uri = uri;
            this._version = version;
        }

        public String getMethod() {
            return this._method;
        }

        public String getURI() {
            return this._uri;
        }

        public void setMethod(String method) {
            this._method = method;
        }

        public void setURI(String uri) {
            this._uri = uri;
        }

        @Override
        public MetaData.Request getMetaData() {
            return new MetaData.Request(this._method, HttpURI.from(this._uri), this._version, this, this._content == null ? 0L : (long)this._content.size());
        }

        @Override
        public String toString() {
            return String.format("%s %s %s\n%s\n", new Object[]{this._method, this._uri, this._version, super.toString()});
        }

        public void setHeader(String name, String value) {
            this.put(name, value);
        }
    }

    public static class Response
    extends Message
    implements HttpParser.ResponseHandler {
        private int _status;
        private String _reason;

        @Override
        public void startResponse(HttpVersion version, int status, String reason) {
            this._version = version;
            this._status = status;
            this._reason = reason;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        @Override
        public MetaData.Response getMetaData() {
            return new MetaData.Response(this._status, this._reason, this._version, this, this._content == null ? -1L : (long)this._content.size());
        }

        @Override
        public String toString() {
            return String.format("%s %s %s\n%s\n", new Object[]{this._version, this._status, this._reason, super.toString()});
        }
    }

    public static abstract class Message
    extends HttpFields.MutableHttpFields
    implements HttpParser.HttpHandler {
        boolean _earlyEOF;
        boolean _complete = false;
        ByteArrayOutputStream _content;
        HttpVersion _version = HttpVersion.HTTP_1_0;

        public boolean isComplete() {
            return this._complete;
        }

        public HttpVersion getVersion() {
            return this._version;
        }

        public void setVersion(String version) {
            this.setVersion((HttpVersion)((Object)HttpVersion.CACHE.get(version)));
        }

        public void setVersion(HttpVersion version) {
            this._version = version;
        }

        public void setContent(byte[] bytes) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(String content) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(StringUtil.getBytes((String)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(ByteBuffer content) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(BufferUtil.toArray((ByteBuffer)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] getContentBytes() {
            if (this._content == null) {
                return null;
            }
            return this._content.toByteArray();
        }

        public ByteBuffer getContentByteBuffer() {
            return ByteBuffer.wrap(this.getContentBytes());
        }

        public String getContent() {
            if (this._content == null) {
                return null;
            }
            String contentType = this.get(HttpHeader.CONTENT_TYPE);
            String encoding = MimeTypes.getCharsetFromContentType(contentType);
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
            return this._content.toString(charset);
        }

        @Override
        public void parsedHeader(HttpField field) {
            this.add(field.getName(), field.getValue());
        }

        @Override
        public boolean contentComplete() {
            return false;
        }

        @Override
        public boolean messageComplete() {
            this._complete = true;
            return true;
        }

        @Override
        public boolean headerComplete() {
            this._content = new ByteArrayOutputStream();
            return false;
        }

        @Override
        public void earlyEOF() {
            this._earlyEOF = true;
        }

        public boolean isEarlyEOF() {
            return this._earlyEOF;
        }

        @Override
        public boolean content(ByteBuffer ref) {
            try {
                this._content.write(BufferUtil.toArray((ByteBuffer)ref));
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void badMessage(HttpException failure) {
            HttpException.throwAsUnchecked(failure);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteBuffer generate() {
            try {
                HttpGenerator generator = new HttpGenerator();
                MetaData info = this.getMetaData();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Buffer header = null;
                ByteBuffer chunk = null;
                ByteBuffer content = this._content == null ? null : ByteBuffer.wrap(this._content.toByteArray());
                block11: while (!generator.isEnd()) {
                    HttpGenerator.Result result = info instanceof MetaData.Request ? generator.generateRequest((MetaData.Request)info, (ByteBuffer)header, chunk, content, true) : generator.generateResponse((MetaData.Response)info, false, (ByteBuffer)header, chunk, content, true);
                    switch (result) {
                        case NEED_HEADER: {
                            header = BufferUtil.allocate((int)8192);
                            continue block11;
                        }
                        case HEADER_OVERFLOW: {
                            if (header.capacity() >= 32768) {
                                throw new BadMessageException(500, "Header too large");
                            }
                            header = BufferUtil.allocate((int)32768);
                            continue block11;
                        }
                        case NEED_CHUNK: {
                            chunk = BufferUtil.allocate((int)12);
                            continue block11;
                        }
                        case NEED_CHUNK_TRAILER: {
                            chunk = BufferUtil.allocate((int)8192);
                            continue block11;
                        }
                        case NEED_INFO: {
                            throw new IllegalStateException();
                        }
                        case FLUSH: {
                            if (BufferUtil.hasContent((ByteBuffer)header)) {
                                out.write(BufferUtil.toArray((ByteBuffer)header));
                                BufferUtil.clear((ByteBuffer)header);
                            }
                            if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                                out.write(BufferUtil.toArray((ByteBuffer)chunk));
                                BufferUtil.clear((ByteBuffer)chunk);
                            }
                            if (!BufferUtil.hasContent((ByteBuffer)content)) break;
                            out.write(BufferUtil.toArray((ByteBuffer)content));
                            BufferUtil.clear((ByteBuffer)content);
                            break;
                        }
                        case SHUTDOWN_OUT: {
                            return ByteBuffer.wrap(out.toByteArray());
                        }
                    }
                }
                return ByteBuffer.wrap(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public abstract MetaData getMetaData();
    }
}

