/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.CookieParser;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieCache
implements CookieParser.Handler {
    protected static final Logger LOG = LoggerFactory.getLogger(CookieCache.class);
    protected final List<String> _rawFields = new ArrayList<String>();
    protected List<HttpCookie> _cookieList;
    private final CookieParser _parser;

    public CookieCache() {
        this(CookieCompliance.RFC6265, null);
    }

    public CookieCache(CookieCompliance compliance, ComplianceViolation.Listener complianceListener) {
        this._parser = CookieParser.newParser(this, compliance, complianceListener);
    }

    @Override
    public void addCookie(String cookieName, String cookieValue, int cookieVersion, String cookieDomain, String cookiePath, String cookieComment) {
        if (StringUtil.isEmpty((String)cookieDomain) && StringUtil.isEmpty((String)cookiePath) && cookieVersion <= 0 && StringUtil.isEmpty((String)cookieComment)) {
            this._cookieList.add(HttpCookie.from(cookieName, cookieValue));
        } else {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("Domain", cookieDomain);
            attributes.put("Path", cookiePath);
            attributes.put("Comment", cookieComment);
            this._cookieList.add(HttpCookie.from(cookieName, cookieValue, cookieVersion, attributes));
        }
    }

    public List<HttpCookie> getCookies(HttpFields headers) {
        boolean building = false;
        ListIterator<String> raw = this._rawFields.listIterator();
        for (HttpField field : headers) {
            String value;
            if (!HttpHeader.COOKIE.equals((Object)field.getHeader()) || StringUtil.isBlank((String)(value = field.getValue()))) continue;
            if (building) {
                this._rawFields.add(value);
                continue;
            }
            if (!raw.hasNext()) {
                building = true;
                this._rawFields.add(value);
                continue;
            }
            if (value.equals(raw.next())) continue;
            building = true;
            raw.remove();
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
            this._rawFields.add(value);
        }
        if (!building && raw.hasNext()) {
            building = true;
            while (raw.hasNext()) {
                raw.next();
                raw.remove();
            }
        }
        if (building) {
            this._cookieList = new ArrayList<HttpCookie>();
            try {
                this._parser.parseFields(this._rawFields);
            }
            catch (CookieParser.InvalidCookieException invalidCookieException) {
                throw new BadMessageException(invalidCookieException.getMessage(), (Throwable)invalidCookieException);
            }
        }
        return this._cookieList == null ? Collections.emptyList() : this._cookieList;
    }

    public void replaceCookieList(List<HttpCookie> cookies) {
        assert (this._cookieList.equals(cookies));
        this._cookieList = cookies;
    }
}

