/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypes {
    static final Logger LOG = LoggerFactory.getLogger(MimeTypes.class);
    private static final Set<Locale> KNOWN_LOCALES = Set.copyOf(Arrays.asList(Locale.getAvailableLocales()));
    public static final String ISO_8859_1 = StandardCharsets.ISO_8859_1.name().toLowerCase();
    public static final String UTF8 = StandardCharsets.UTF_8.name().toLowerCase();
    public static final String UTF16 = StandardCharsets.UTF_16.name().toLowerCase();
    private static final Index<String> CHARSETS = new Index.Builder().caseSensitive(false).with("utf-8", (Object)UTF8).with("utf8", (Object)UTF8).with("utf-16", (Object)UTF16).with("utf16", (Object)UTF16).with("iso-8859-1", (Object)ISO_8859_1).with("iso_8859_1", (Object)ISO_8859_1).build();
    public static final Index<Type> CACHE = new Index.Builder().caseSensitive(false).withAll(() -> {
        HashMap<String, Type> result = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            String key1 = type.toString();
            result.put(key1, type);
            if (key1.indexOf(";charset=") <= 0) continue;
            String key2 = StringUtil.replace((String)key1, (String)";charset=", (String)"; charset=");
            result.put(key2, type);
        }
        return result;
    }).build();
    protected final Map<String, String> _mimeMap = new HashMap<String, String>();
    protected final Map<String, Charset> _inferredEncodings = new HashMap<String, Charset>();
    protected final Map<String, Charset> _assumedEncodings = new HashMap<String, Charset>();
    public static final MimeTypes DEFAULTS = new MimeTypes(null){
        {
            block44: {
                Properties props;
                InputStream stream;
                String resourceName;
                block43: {
                    super(defaults);
                    for (Type type : Type.values()) {
                        if (!type.isCharsetAssumed()) continue;
                        this._assumedEncodings.put(type.asString(), type.getCharset());
                    }
                    resourceName = "mime.properties";
                    try {
                        stream = MimeTypes.class.getResourceAsStream(resourceName);
                        try {
                            if (stream == null) {
                                LOG.warn("Missing mime-type resource: {}", (Object)resourceName);
                                break block43;
                            }
                            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                                props = new Properties();
                                props.load(reader);
                                props.stringPropertyNames().stream().filter(Objects::nonNull).forEach(x -> {
                                    if (x.contains(".")) {
                                        LOG.warn("ignoring invalid extension {} from mime.properties", x);
                                    } else {
                                        this._mimeMap.put(StringUtil.asciiToLowerCase((String)x), MimeTypes.normalizeMimeType(props.getProperty((String)x)));
                                    }
                                });
                                if (this._mimeMap.isEmpty()) {
                                    LOG.warn("Empty mime types at {}", (Object)resourceName);
                                } else if (this._mimeMap.size() < props.keySet().size()) {
                                    LOG.warn("Duplicate or null mime-type extension in resource: {}", (Object)resourceName);
                                }
                            }
                            catch (IOException e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.warn("Unable to read mime-type resource: {}", (Object)resourceName, (Object)e);
                                    break block43;
                                }
                                LOG.warn("Unable to read mime-type resource: {} - {}", (Object)resourceName, (Object)e.toString());
                            }
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Unable to load mime-type resource: {}", (Object)resourceName, (Object)e);
                        }
                        LOG.warn("Unable to load mime-type resource: {} - {}", (Object)resourceName, (Object)e.toString());
                    }
                }
                resourceName = "encoding.properties";
                try {
                    stream = MimeTypes.class.getResourceAsStream(resourceName);
                    try {
                        if (stream == null) {
                            LOG.warn("Missing encoding resource: {}", (Object)resourceName);
                            break block44;
                        }
                        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                            props = new Properties();
                            props.load(reader);
                            props.stringPropertyNames().stream().filter(Objects::nonNull).forEach(t -> {
                                String charset = props.getProperty((String)t);
                                if (charset.startsWith("-")) {
                                    this._assumedEncodings.put(t, Charset.forName(charset.substring(1)));
                                } else {
                                    this._inferredEncodings.put(t, Charset.forName(props.getProperty((String)t)));
                                }
                            });
                            if (this._inferredEncodings.isEmpty()) {
                                LOG.warn("Empty encodings at {}", (Object)resourceName);
                            } else if (this._inferredEncodings.size() + this._assumedEncodings.size() < props.keySet().size()) {
                                LOG.warn("Null or duplicate encodings in resource: {}", (Object)resourceName);
                            }
                        }
                        catch (IOException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.warn("Unable to read encoding resource: {}", (Object)resourceName, (Object)e);
                                break block44;
                            }
                            LOG.warn("Unable to read encoding resource: {} - {}", (Object)resourceName, (Object)e.toString());
                        }
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Unable to load encoding resource: {}", (Object)resourceName, (Object)e);
                    }
                    LOG.warn("Unable to load encoding resource: {} - {}", (Object)resourceName, (Object)e.toString());
                }
            }
        }
    };

    public static String getBase(String value) {
        int index = value.indexOf(59);
        return index == -1 ? value : value.substring(0, index);
    }

    public static Type getBaseType(String contentType) {
        if (StringUtil.isEmpty((String)contentType)) {
            return null;
        }
        Type type = (Type)((Object)CACHE.getBest(contentType));
        if (type == null && (type = (Type)((Object)CACHE.get(MimeTypes.getBase(contentType)))) == null) {
            return null;
        }
        return type.getBaseType();
    }

    public static boolean isKnownLocale(Locale locale) {
        return KNOWN_LOCALES.contains(locale);
    }

    public static String normalizeCharset(String charsetName) {
        String n = (String)CHARSETS.get(charsetName);
        return n == null ? charsetName : n;
    }

    public static String normalizeCharset(String charsetName, int offset, int length) {
        String n = (String)CHARSETS.get(charsetName, offset, length);
        return n == null ? charsetName.substring(offset, offset + length) : n;
    }

    public static Charset getKnownCharset(String charsetName) throws UnsupportedEncodingException {
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(charsetName)) {
            return StandardCharsets.UTF_8;
        }
        charsetName = MimeTypes.normalizeCharset(charsetName);
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(charsetName)) {
            return StandardCharsets.UTF_8;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
    }

    private static String nameOf(Charset charset) {
        return charset == null ? null : charset.name();
    }

    public MimeTypes() {
        this(DEFAULTS);
    }

    public MimeTypes(MimeTypes defaults) {
        if (defaults != null) {
            this._mimeMap.putAll(defaults.getMimeMap());
            this._assumedEncodings.putAll(defaults._assumedEncodings);
            this._inferredEncodings.putAll(defaults._inferredEncodings);
        }
    }

    public Charset getCharset(HttpField field) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (field instanceof ContentTypeField) {
            ContentTypeField contentTypeField = (ContentTypeField)field;
            return contentTypeField.getMimeType().getCharset();
        }
        return this.getCharset(field.getValue());
    }

    public Charset getCharset(String mimeType) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (mimeType == null) {
            return null;
        }
        Type mime = (Type)((Object)CACHE.get(mimeType));
        if (mime != null && mime.getCharset() != null) {
            return mime.getCharset();
        }
        String charsetName = MimeTypes.getCharsetFromContentType(mimeType);
        if (charsetName != null) {
            return Charset.forName(charsetName);
        }
        Charset charset = this.getAssumedCharset(mimeType);
        if (charset != null) {
            return charset;
        }
        charset = this.getInferredCharset(mimeType);
        return charset;
    }

    public String getMimeByExtension(String filename) {
        String ext = FileID.getExtension((String)filename);
        return this.getMimeForExtension(Objects.requireNonNullElse(ext, "*"));
    }

    public String getMimeForExtension(String extension) {
        return this._mimeMap.get(extension);
    }

    public Charset getInferredCharset(String contentType) {
        return this._inferredEncodings.get(contentType);
    }

    public Charset getAssumedCharset(String contentType) {
        return this._assumedEncodings.get(contentType);
    }

    public String getCharsetInferredFromContentType(String contentType) {
        return MimeTypes.nameOf(this._inferredEncodings.get(contentType));
    }

    public String getCharsetAssumedFromContentType(String contentType) {
        return MimeTypes.nameOf(this._assumedEncodings.get(contentType));
    }

    public Map<String, String> getMimeMap() {
        return Collections.unmodifiableMap(this._mimeMap);
    }

    public Map<String, String> getInferredMap() {
        return this._inferredEncodings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Charset)e.getValue()).name()));
    }

    public Map<String, String> getAssumedMap() {
        return this._assumedEncodings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Charset)e.getValue()).name()));
    }

    private static String normalizeMimeType(String type) {
        Type t = (Type)((Object)CACHE.get(type));
        if (t != null) {
            return t.asString();
        }
        return StringUtil.asciiToLowerCase((String)type);
    }

    public static Type getMimeTypeFromContentType(HttpField field) {
        if (field == null) {
            return null;
        }
        assert (field.getHeader() == HttpHeader.CONTENT_TYPE);
        if (field instanceof ContentTypeField) {
            ContentTypeField contentTypeField = (ContentTypeField)field;
            return contentTypeField.getMimeType();
        }
        return (Type)((Object)CACHE.get(field.getValue()));
    }

    public static Charset getCharsetFromContentType(HttpField field) {
        if (field == null) {
            return null;
        }
        assert (field.getHeader() == HttpHeader.CONTENT_TYPE);
        if (field instanceof ContentTypeField) {
            ContentTypeField contentTypeField = (ContentTypeField)field;
            return contentTypeField._type.getCharset();
        }
        String charset = MimeTypes.getCharsetFromContentType(field.getValue());
        if (charset == null) {
            return null;
        }
        return Charset.forName(charset);
    }

    public static String getCharsetFromContentType(String value) {
        int i;
        if (value == null) {
            return null;
        }
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        block13: for (i = 0; i < end; ++i) {
            char b = value.charAt(i);
            if (quote && state != 10) {
                if ('\"' != b) continue;
                quote = false;
                continue;
            }
            if (';' == b && state <= 8) {
                state = 1;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('\"' != b) continue block13;
                    quote = true;
                    continue block13;
                }
                case 1: {
                    if ('c' == b) {
                        state = 2;
                        continue block13;
                    }
                    if (' ' == b) continue block13;
                    state = 0;
                    continue block13;
                }
                case 2: {
                    if ('h' == b) {
                        state = 3;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 3: {
                    if ('a' == b) {
                        state = 4;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 4: {
                    if ('r' == b) {
                        state = 5;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 5: {
                    if ('s' == b) {
                        state = 6;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 6: {
                    if ('e' == b) {
                        state = 7;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 7: {
                    if ('t' == b) {
                        state = 8;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 8: {
                    if ('=' == b) {
                        state = 9;
                        continue block13;
                    }
                    if (' ' == b) continue block13;
                    state = 0;
                    continue block13;
                }
                case 9: {
                    if (' ' == b) continue block13;
                    if ('\"' == b) {
                        quote = true;
                        start = i + 1;
                        state = 10;
                        continue block13;
                    }
                    start = i;
                    state = 10;
                    continue block13;
                }
                case 10: {
                    if ((quote || ';' != b && ' ' != b) && (!quote || '\"' != b)) continue block13;
                    return MimeTypes.normalizeCharset(value, start, i - start);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (state == 10) {
            return MimeTypes.normalizeCharset(value, start, i - start);
        }
        return null;
    }

    public static String getContentTypeWithoutCharset(String value) {
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        StringBuilder builder = null;
        block19: for (int i = 0; i < end; ++i) {
            char b = value.charAt(i);
            if ('\"' == b) {
                quote = !quote;
                switch (state) {
                    case 11: {
                        builder.append(b);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 9: {
                        builder = new StringBuilder();
                        builder.append(value, 0, start + 1);
                        state = 10;
                        break;
                    }
                    default: {
                        start = i;
                        state = 0;
                        break;
                    }
                }
                continue;
            }
            if (quote) {
                if (builder == null || state == 10) continue;
                builder.append(b);
                continue;
            }
            switch (state) {
                case 0: {
                    if (';' == b) {
                        state = 1;
                        continue block19;
                    }
                    if (' ' == b) continue block19;
                    start = i;
                    continue block19;
                }
                case 1: {
                    if ('c' == b) {
                        state = 2;
                        continue block19;
                    }
                    if (' ' == b) continue block19;
                    state = 0;
                    continue block19;
                }
                case 2: {
                    if ('h' == b) {
                        state = 3;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 3: {
                    if ('a' == b) {
                        state = 4;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 4: {
                    if ('r' == b) {
                        state = 5;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 5: {
                    if ('s' == b) {
                        state = 6;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 6: {
                    if ('e' == b) {
                        state = 7;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 7: {
                    if ('t' == b) {
                        state = 8;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 8: {
                    if ('=' == b) {
                        state = 9;
                        continue block19;
                    }
                    if (' ' == b) continue block19;
                    state = 0;
                    continue block19;
                }
                case 9: {
                    if (' ' == b) continue block19;
                    builder = new StringBuilder();
                    builder.append(value, 0, start + 1);
                    state = 10;
                    continue block19;
                }
                case 10: {
                    if (';' != b) continue block19;
                    builder.append(b);
                    state = 11;
                    continue block19;
                }
                case 11: {
                    if (' ' == b) continue block19;
                    builder.append(b);
                    continue block19;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (builder == null) {
            return value;
        }
        return builder.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        FORM_ENCODED("application/x-www-form-urlencoded"),
        MESSAGE_HTTP("message/http"),
        MULTIPART_BYTERANGES("multipart/byteranges"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        TEXT_HTML("text/html"){

            @Override
            public HttpField getContentTypeField(Charset charset) {
                if (Objects.equals(charset, StandardCharsets.UTF_8)) {
                    return TEXT_HTML_UTF_8.getContentTypeField();
                }
                if (Objects.equals(charset, StandardCharsets.ISO_8859_1)) {
                    return TEXT_HTML_8859_1.getContentTypeField();
                }
                return super.getContentTypeField(charset);
            }
        }
        ,
        TEXT_PLAIN("text/plain"){

            @Override
            public HttpField getContentTypeField(Charset charset) {
                if (Objects.equals(charset, StandardCharsets.UTF_8)) {
                    return TEXT_PLAIN_UTF_8.getContentTypeField();
                }
                if (Objects.equals(charset, StandardCharsets.ISO_8859_1)) {
                    return TEXT_PLAIN_8859_1.getContentTypeField();
                }
                return super.getContentTypeField(charset);
            }
        }
        ,
        TEXT_XML("text/xml"){

            @Override
            public HttpField getContentTypeField(Charset charset) {
                if (Objects.equals(charset, StandardCharsets.UTF_8)) {
                    return TEXT_XML_UTF_8.getContentTypeField();
                }
                if (Objects.equals(charset, StandardCharsets.ISO_8859_1)) {
                    return TEXT_XML_8859_1.getContentTypeField();
                }
                return super.getContentTypeField(charset);
            }
        }
        ,
        TEXT_JSON("text/json", StandardCharsets.UTF_8),
        APPLICATION_JSON("application/json", StandardCharsets.UTF_8),
        TEXT_HTML_8859_1("text/html;charset=iso-8859-1", TEXT_HTML),
        TEXT_HTML_UTF_8("text/html;charset=utf-8", TEXT_HTML),
        TEXT_PLAIN_8859_1("text/plain;charset=iso-8859-1", TEXT_PLAIN),
        TEXT_PLAIN_UTF_8("text/plain;charset=utf-8", TEXT_PLAIN),
        TEXT_XML_8859_1("text/xml;charset=iso-8859-1", TEXT_XML),
        TEXT_XML_UTF_8("text/xml;charset=utf-8", TEXT_XML),
        TEXT_JSON_8859_1("text/json;charset=iso-8859-1", TEXT_JSON),
        TEXT_JSON_UTF_8("text/json;charset=utf-8", TEXT_JSON),
        APPLICATION_JSON_8859_1("application/json;charset=iso-8859-1", APPLICATION_JSON),
        APPLICATION_JSON_UTF_8("application/json;charset=utf-8", APPLICATION_JSON);

        private final String _string;
        private final Type _base;
        private final Charset _charset;
        private final String _charsetString;
        private final boolean _assumedCharset;
        private final ContentTypeField _field;

        private Type(String name) {
            this._string = name;
            this._base = this;
            this._charset = null;
            this._charsetString = null;
            this._assumedCharset = false;
            this._field = new ContentTypeField(this);
        }

        private Type(String name, Type base) {
            this._string = name;
            this._base = Objects.requireNonNull(base);
            int i = name.indexOf(";charset=");
            this._charset = Charset.forName(name.substring(i + 9));
            this._charsetString = this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = false;
            this._field = new ContentTypeField(this);
        }

        private Type(String name, Charset cs) {
            this._string = name;
            this._base = this;
            this._charset = cs;
            this._charsetString = this._charset == null ? null : this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = true;
            this._field = new ContentTypeField(this);
        }

        public Charset getCharset() {
            return this._charset;
        }

        public String getCharsetString() {
            return this._charsetString;
        }

        public boolean is(String type) {
            return this._string.equalsIgnoreCase(type);
        }

        public String asString() {
            return this._string;
        }

        public String toString() {
            return this._string;
        }

        public boolean isCharsetAssumed() {
            return this._assumedCharset;
        }

        public HttpField getContentTypeField() {
            return this._field;
        }

        public HttpField getContentTypeField(Charset charset) {
            if (Objects.equals(this._charset, charset)) {
                return this._field;
            }
            return new HttpField(HttpHeader.CONTENT_TYPE, MimeTypes.getContentTypeWithoutCharset(this._string) + ";charset=" + charset.name());
        }

        public Type getBaseType() {
            return this._base;
        }
    }

    static class ContentTypeField
    extends PreEncodedHttpField {
        private final Type _type;

        public ContentTypeField(Type type) {
            this(type, type.toString());
        }

        public ContentTypeField(Type type, String value) {
            super(HttpHeader.CONTENT_TYPE, value);
            this._type = type;
        }

        public Type getMimeType() {
            return this._type;
        }
    }

    public static class Wrapper
    extends Mutable {
        private MimeTypes _wrapped;

        public Wrapper() {
            super(null);
        }

        public MimeTypes getWrapped() {
            return this._wrapped;
        }

        public void setWrapped(MimeTypes wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public String getMimeForExtension(String extension) {
            String mime = super.getMimeForExtension(extension);
            return mime == null && this._wrapped != null ? this._wrapped.getMimeForExtension(extension) : mime;
        }

        @Override
        public String getCharsetInferredFromContentType(String contentType) {
            String charset = super.getCharsetInferredFromContentType(contentType);
            return charset == null && this._wrapped != null ? this._wrapped.getCharsetInferredFromContentType(contentType) : charset;
        }

        @Override
        public String getCharsetAssumedFromContentType(String contentType) {
            String charset = super.getCharsetAssumedFromContentType(contentType);
            return charset == null && this._wrapped != null ? this._wrapped.getCharsetAssumedFromContentType(contentType) : charset;
        }

        @Override
        public Map<String, String> getMimeMap() {
            Map<String, String> map = super.getMimeMap();
            if (this._wrapped == null || map.isEmpty()) {
                return map;
            }
            map = new HashMap<String, String>(map);
            map.putAll(this._wrapped.getMimeMap());
            return Collections.unmodifiableMap(map);
        }

        @Override
        public Map<String, String> getInferredMap() {
            Map<String, String> map = super.getInferredMap();
            if (this._wrapped == null || map.isEmpty()) {
                return map;
            }
            map = new HashMap<String, String>(map);
            map.putAll(this._wrapped.getInferredMap());
            return Collections.unmodifiableMap(map);
        }

        @Override
        public Map<String, String> getAssumedMap() {
            Map<String, String> map = super.getAssumedMap();
            if (this._wrapped == null || map.isEmpty()) {
                return map;
            }
            map = new HashMap<String, String>(map);
            map.putAll(this._wrapped.getAssumedMap());
            return Collections.unmodifiableMap(map);
        }
    }

    public static class Mutable
    extends MimeTypes {
        public Mutable() {
            this(DEFAULTS);
        }

        public Mutable(MimeTypes defaults) {
            super(defaults);
        }

        public String addMimeMapping(String extension, String type) {
            if (extension.contains(".")) {
                throw new IllegalArgumentException("extensions cannot contain '.'");
            }
            return this._mimeMap.put(StringUtil.asciiToLowerCase((String)extension), MimeTypes.normalizeMimeType(type));
        }

        public String addInferred(String contentType, String encoding) {
            return MimeTypes.nameOf(this._inferredEncodings.put(contentType, Charset.forName(encoding)));
        }

        public String addAssumed(String contentType, String encoding) {
            return MimeTypes.nameOf(this._assumedEncodings.put(contentType, Charset.forName(encoding)));
        }
    }
}

