/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;

public class SslSelectChannelEndPoint
extends SelectChannelEndPoint {
    private static final ByteBuffer[] __NO_BUFFERS = new ByteBuffer[0];
    private Buffers _buffers;
    private SSLEngine _engine;
    private ByteBuffer _inBuffer;
    private NIOBuffer _inNIOBuffer;
    private ByteBuffer _outBuffer;
    private NIOBuffer _outNIOBuffer;
    private NIOBuffer[] _reuseBuffer = new NIOBuffer[2];
    private ByteBuffer[] _gather = new ByteBuffer[2];
    private boolean _closing = false;
    private SSLEngineResult _result;
    private String _last;
    protected SSLSession _session;

    public SslSelectChannelEndPoint(Buffers buffers, SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, SSLEngine engine) throws SSLException, IOException {
        super(channel, selectSet, key);
        this._buffers = buffers;
        this._engine = engine;
        this._session = engine.getSession();
        this._outNIOBuffer = (NIOBuffer)buffers.getBuffer(this._session.getPacketBufferSize());
        this._outBuffer = this._outNIOBuffer.getByteBuffer();
        this._inNIOBuffer = (NIOBuffer)buffers.getBuffer(this._session.getPacketBufferSize());
        this._inBuffer = this._inNIOBuffer.getByteBuffer();
    }

    public void dump() {
        Log.info((String)("" + this._result));
    }

    protected void idleExpired() {
        try {
            this._selectSet.getManager().dispatch(new Runnable(){

                public void run() {
                    SslSelectChannelEndPoint.this.doIdleExpired();
                }
            });
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
    }

    protected void doIdleExpired() {
        super.idleExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        this._closing = true;
        try {
            try {
                tries = 0;
                while (this._outNIOBuffer.length() > 0) {
                    if (tries++ > 100) {
                        throw new IllegalStateException();
                    }
                    this.flush();
                    Thread.sleep(100L);
                }
                this._engine.closeOutbound();
                while (!(!this.isOpen() || this._engine.isInboundDone() && this._engine.isOutboundDone())) {
                    if (tries++ > 100) {
                        throw new IllegalStateException();
                    }
                    if (this._outNIOBuffer.length() > 0) {
                        this.flush();
                        Thread.sleep(100L);
                    }
                    switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this._engine.getHandshakeStatus().ordinal()]) {
                        case 1: 
                        case 2: {
                            ** break;
                        }
                        case 3: {
                            buffer = this._buffers.getBuffer(this._engine.getSession().getApplicationBufferSize());
                            try {
                                try {
                                    bbuffer = ((NIOBuffer)buffer).getByteBuffer();
                                    if (this.unwrap(bbuffer) || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) ** GOTO lbl43
                                    var5_9 = null;
                                }
                                catch (SSLException e) {
                                    Log.ignore((Throwable)e);
                                    var5_9 = null;
                                    this._buffers.returnBuffer(buffer);
                                    break;
                                }
                            }
                            catch (Throwable var4_11) {
                                var5_9 = null;
                                this._buffers.returnBuffer(buffer);
                                throw var4_11;
                            }
                            this._buffers.returnBuffer(buffer);
                            ** break;
lbl43:
                            // 1 sources

                            var5_9 = null;
                            this._buffers.returnBuffer(buffer);
                            break;
                        }
                        case 4: {
                            while ((task = this._engine.getDelegatedTask()) != null) {
                                task.run();
                            }
                            break;
                        }
                        case 5: {
                            if (this._outNIOBuffer.length() > 0) {
                                this.flush();
                            }
                            try {
                                this._outNIOBuffer.compact();
                                put = this._outNIOBuffer.putIndex();
                                this._outBuffer.position(put);
                                this._result = null;
                                this._last = "close wrap";
                                this._result = this._engine.wrap(SslSelectChannelEndPoint.__NO_BUFFERS, this._outBuffer);
                                this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                                var7_10 = null;
                                this._outBuffer.position(0);
                            }
                            catch (Throwable var6_12) {
                                var7_10 = null;
                                this._outBuffer.position(0);
                                throw var6_12;
                            }
                        }
                        this.flush();
                    }
                }
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
                var9_14 = null;
                super.close();
                if (this._inNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
                }
                if (this._outNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
                }
                if (this._reuseBuffer[0] != null) {
                    this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
                }
                if (this._reuseBuffer[1] == null) return;
                this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
                return;
            }
            catch (InterruptedException e) {
                Log.ignore((Throwable)e);
                var9_15 = null;
                super.close();
                if (this._inNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
                }
                if (this._outNIOBuffer != null) {
                    this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
                }
                if (this._reuseBuffer[0] != null) {
                    this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
                }
                if (this._reuseBuffer[1] == null) return;
                this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
                return;
            }
lbl104:
            // 2 sources

            var9_13 = null;
        }
        catch (Throwable var8_17) {
            var9_16 = null;
            super.close();
            if (this._inNIOBuffer != null) {
                this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
            }
            if (this._outNIOBuffer != null) {
                this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
            }
            if (this._reuseBuffer[0] != null) {
                this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
            }
            if (this._reuseBuffer[1] == null) throw var8_17;
            this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
            throw var8_17;
        }
        super.close();
        if (this._inNIOBuffer != null) {
            this._buffers.returnBuffer((Buffer)this._inNIOBuffer);
        }
        if (this._outNIOBuffer != null) {
            this._buffers.returnBuffer((Buffer)this._outNIOBuffer);
        }
        if (this._reuseBuffer[0] != null) {
            this._buffers.returnBuffer((Buffer)this._reuseBuffer[0]);
        }
        if (this._reuseBuffer[1] == null) return;
        this._buffers.returnBuffer((Buffer)this._reuseBuffer[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int fill(Buffer buffer) throws IOException {
        ByteBuffer bbuf = this.extractInputBuffer(buffer);
        int size = buffer.length();
        SSLEngineResult.HandshakeStatus initialStatus = this._engine.getHandshakeStatus();
        ByteBuffer byteBuffer = bbuf;
        synchronized (byteBuffer) {
            block25: {
                this.unwrap(bbuf);
                int tries = 0;
                int wraps = 0;
                block21: while (true) {
                    if (tries++ > 100) {
                        throw new IllegalStateException();
                    }
                    if (this._outNIOBuffer.length() > 0) {
                        this.flush();
                    }
                    switch (this._engine.getHandshakeStatus()) {
                        case FINISHED: 
                        case NOT_HANDSHAKING: {
                            if (!this._closing) break block21;
                            int n = -1;
                            Object var14_13 = null;
                            buffer.setPutIndex(bbuf.position());
                            bbuf.position(0);
                            return n;
                        }
                        case NEED_UNWRAP: {
                            if (this.unwrap(bbuf) || this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                            break block21;
                        }
                        case NEED_TASK: {
                            Runnable task;
                            while ((task = this._engine.getDelegatedTask()) != null) {
                                task.run();
                            }
                            if (initialStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || SSLEngineResult.HandshakeStatus.NEED_UNWRAP != this._engine.getHandshakeStatus() || wraps != 0) break;
                            int n = -1;
                            Object var14_14 = null;
                            buffer.setPutIndex(bbuf.position());
                            bbuf.position(0);
                            return n;
                        }
                        case NEED_WRAP: {
                            ++wraps;
                            ByteBuffer byteBuffer2 = this._outBuffer;
                            synchronized (byteBuffer2) {
                                Object var11_12;
                                try {
                                    this._outNIOBuffer.compact();
                                    int put = this._outNIOBuffer.putIndex();
                                    this._outBuffer.position();
                                    this._result = null;
                                    this._last = "fill wrap";
                                    this._result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                                    switch (this._result.getStatus()) {
                                        case BUFFER_OVERFLOW: 
                                        case BUFFER_UNDERFLOW: {
                                            Log.warn((String)"wrap {}", (Object)this._result);
                                        }
                                        case CLOSED: {
                                            this._closing = true;
                                            break;
                                        }
                                    }
                                    this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                                    var11_12 = null;
                                    this._outBuffer.position(0);
                                }
                                catch (Throwable throwable) {
                                    var11_12 = null;
                                    this._outBuffer.position(0);
                                    throw throwable;
                                }
                            }
                            this.flush();
                        }
                    }
                }
                try {
                    Object var14_15 = null;
                    buffer.setPutIndex(bbuf.position());
                    bbuf.position(0);
                    break block25;
                    catch (SSLException e) {
                        Log.warn((String)e.toString());
                        Log.debug((Throwable)e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    buffer.setPutIndex(bbuf.position());
                    bbuf.position(0);
                    throw throwable;
                }
            }
            return buffer.length() - size;
        }
    }

    public int flush(Buffer buffer) throws IOException {
        return this.flush(buffer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int consumed = 0;
        int available = header.length();
        if (buffer != null) {
            available += buffer.length();
        }
        int tries = 0;
        while (true) {
            if (tries++ > 100) {
                throw new IllegalStateException();
            }
            if (this._outNIOBuffer.length() > 0) {
                this.flush();
            }
            switch (this._engine.getHandshakeStatus()) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    int c;
                    if (this._closing || available == 0) {
                        if (consumed != 0) return consumed;
                        return -1;
                    }
                    int n = c = header != null && buffer != null ? this.wrap(header, buffer) : this.wrap(header);
                    if (c > 0) {
                        consumed += c;
                        available -= c;
                        break;
                    }
                    if (c >= 0) break;
                    if (consumed != 0) return consumed;
                    return -1;
                }
                case NEED_UNWRAP: {
                    Object var11_12;
                    Buffer buf = this._buffers.getBuffer(this._engine.getSession().getApplicationBufferSize());
                    try {
                        ByteBuffer bbuf = ((NIOBuffer)buf).getByteBuffer();
                        if (!this.unwrap(bbuf) && this._engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            var11_12 = null;
                            this._buffers.returnBuffer(buf);
                            return consumed;
                        }
                        var11_12 = null;
                        this._buffers.returnBuffer(buf);
                        break;
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        this._buffers.returnBuffer(buf);
                        throw throwable;
                    }
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this._engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    break;
                }
                case NEED_WRAP: {
                    ByteBuffer byteBuffer = this._outBuffer;
                    synchronized (byteBuffer) {
                        Object var13_13;
                        try {
                            this._outNIOBuffer.compact();
                            int put = this._outNIOBuffer.putIndex();
                            this._outBuffer.position();
                            this._result = null;
                            this._last = "flush wrap";
                            this._result = this._engine.wrap(__NO_BUFFERS, this._outBuffer);
                            switch (this._result.getStatus()) {
                                case BUFFER_OVERFLOW: 
                                case BUFFER_UNDERFLOW: {
                                    Log.warn((String)"unwrap {}", (Object)this._result);
                                }
                                case CLOSED: {
                                    this._closing = true;
                                    break;
                                }
                            }
                            this._outNIOBuffer.setPutIndex(put + this._result.bytesProduced());
                            var13_13 = null;
                            this._outBuffer.position(0);
                        }
                        catch (Throwable throwable) {
                            var13_13 = null;
                            this._outBuffer.position(0);
                            throw throwable;
                        }
                    }
                    this.flush();
                }
            }
        }
    }

    public void flush() throws IOException {
        while (this._outNIOBuffer.length() > 0) {
            int flushed = super.flush((Buffer)this._outNIOBuffer);
            if (flushed != 0) continue;
            Thread.yield();
            int n = super.flush((Buffer)this._outNIOBuffer);
        }
    }

    private ByteBuffer extractInputBuffer(Buffer buffer) {
        assert (buffer instanceof NIOBuffer);
        NIOBuffer nbuf = (NIOBuffer)buffer;
        ByteBuffer bbuf = nbuf.getByteBuffer();
        bbuf.position(buffer.putIndex());
        return bbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unwrap(ByteBuffer buffer) throws IOException {
        if (this._inNIOBuffer.hasContent()) {
            this._inNIOBuffer.compact();
        } else {
            this._inNIOBuffer.clear();
        }
        int total_filled = 0;
        while (this._inNIOBuffer.space() > 0 && super.isOpen()) {
            try {
                int filled = super.fill((Buffer)this._inNIOBuffer);
                if (filled <= 0) break;
                total_filled += filled;
            }
            catch (IOException e) {
                if (this._inNIOBuffer.length() != 0) break;
                throw e;
            }
        }
        if (this._inNIOBuffer.length() == 0) {
            if (!this.isOpen()) {
                throw new EofException();
            }
            return false;
        }
        try {
            this._inBuffer.position(this._inNIOBuffer.getIndex());
            this._inBuffer.limit(this._inNIOBuffer.putIndex());
            this._result = null;
            this._last = "unwrap";
            this._result = this._engine.unwrap(this._inBuffer, buffer);
            this._inNIOBuffer.skip(this._result.bytesConsumed());
            Object var5_5 = null;
            this._inBuffer.position(0);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._inBuffer.position(0);
            this._inBuffer.limit(this._inBuffer.capacity());
            throw throwable;
        }
        this._inBuffer.limit(this._inBuffer.capacity());
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"unwrap {}", (Object)this._result);
                }
                return total_filled > 0;
            }
            case CLOSED: {
                this._closing = true;
            }
            case OK: {
                boolean progress = total_filled > 0 || this._result.bytesConsumed() > 0 || this._result.bytesProduced() > 0;
                return progress;
            }
        }
        Log.warn((String)("unwrap " + this._result));
        throw new IOException(this._result.toString());
    }

    private ByteBuffer extractOutputBuffer(Buffer buffer, int n) {
        NIOBuffer nBuf = null;
        if (buffer.buffer() instanceof NIOBuffer) {
            nBuf = (NIOBuffer)buffer.buffer();
            return nBuf.getByteBuffer();
        }
        if (this._reuseBuffer[n] == null) {
            this._reuseBuffer[n] = (NIOBuffer)this._buffers.getBuffer(this._session.getApplicationBufferSize());
        }
        NIOBuffer buf = this._reuseBuffer[n];
        buf.clear();
        buf.put(buffer);
        return buf.getByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(Buffer header, Buffer buffer) throws IOException {
        this._gather[0] = this.extractOutputBuffer(header, 0);
        ByteBuffer byteBuffer = this._gather[0];
        synchronized (byteBuffer) {
            this._gather[0].position(header.getIndex());
            this._gather[0].limit(header.putIndex());
            this._gather[1] = this.extractOutputBuffer(buffer, 1);
            ByteBuffer byteBuffer2 = this._gather[1];
            synchronized (byteBuffer2) {
                this._gather[1].position(buffer.getIndex());
                this._gather[1].limit(buffer.putIndex());
                ByteBuffer byteBuffer3 = this._outBuffer;
                synchronized (byteBuffer3) {
                    int len2;
                    int consumed = 0;
                    try {
                        this._outNIOBuffer.clear();
                        this._outBuffer.position(0);
                        this._outBuffer.limit(this._outBuffer.capacity());
                        this._result = null;
                        this._last = "wrap wrap";
                        this._result = this._engine.wrap(this._gather, this._outBuffer);
                        this._outNIOBuffer.setGetIndex(0);
                        this._outNIOBuffer.setPutIndex(this._result.bytesProduced());
                        consumed = this._result.bytesConsumed();
                        Object var8_7 = null;
                        this._outBuffer.position(0);
                    }
                    catch (Throwable throwable) {
                        int len2;
                        Object var8_8 = null;
                        this._outBuffer.position(0);
                        if (consumed > 0 && header != null) {
                            len2 = consumed < header.length() ? consumed : header.length();
                            header.skip(len2);
                            consumed -= len2;
                            this._gather[0].position(0);
                            this._gather[0].limit(this._gather[0].capacity());
                        }
                        if (consumed > 0 && buffer != null) {
                            len2 = consumed < buffer.length() ? consumed : buffer.length();
                            buffer.skip(len2);
                            consumed -= len2;
                            this._gather[1].position(0);
                            this._gather[1].limit(this._gather[1].capacity());
                        }
                        assert (consumed == 0);
                        throw throwable;
                    }
                    if (consumed > 0 && header != null) {
                        len2 = consumed < header.length() ? consumed : header.length();
                        header.skip(len2);
                        consumed -= len2;
                        this._gather[0].position(0);
                        this._gather[0].limit(this._gather[0].capacity());
                    }
                    if (consumed > 0 && buffer != null) {
                        len2 = consumed < buffer.length() ? consumed : buffer.length();
                        buffer.skip(len2);
                        consumed -= len2;
                        this._gather[1].position(0);
                        this._gather[1].limit(this._gather[1].capacity());
                    }
                    assert (consumed == 0);
                }
            }
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: {
                Log.warn((String)"unwrap {}", (Object)this._result);
            }
            case OK: {
                return this._result.bytesConsumed();
            }
            case CLOSED: {
                this._closing = true;
                return this._result.bytesConsumed() > 0 ? this._result.bytesConsumed() : -1;
            }
        }
        Log.warn((String)("wrap " + this._result));
        throw new IOException(this._result.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrap(Buffer header) throws IOException {
        this._gather[0] = this.extractOutputBuffer(header, 0);
        ByteBuffer byteBuffer = this._gather[0];
        synchronized (byteBuffer) {
            this._gather[0].position(header.getIndex());
            this._gather[0].limit(header.putIndex());
            int consumed = 0;
            ByteBuffer byteBuffer2 = this._outBuffer;
            synchronized (byteBuffer2) {
                try {
                    this._outNIOBuffer.clear();
                    this._outBuffer.position(0);
                    this._outBuffer.limit(this._outBuffer.capacity());
                    this._result = null;
                    this._last = "wrap wrap";
                    this._result = this._engine.wrap(this._gather[0], this._outBuffer);
                    this._outNIOBuffer.setGetIndex(0);
                    this._outNIOBuffer.setPutIndex(this._result.bytesProduced());
                    consumed = this._result.bytesConsumed();
                    Object var6_5 = null;
                    this._outBuffer.position(0);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this._outBuffer.position(0);
                    if (consumed > 0 && header != null) {
                        int len = consumed < header.length() ? consumed : header.length();
                        header.skip(len);
                        consumed -= len;
                        this._gather[0].position(0);
                        this._gather[0].limit(this._gather[0].capacity());
                    }
                    assert (consumed == 0);
                    throw throwable;
                }
                if (consumed > 0 && header != null) {
                    int len = consumed < header.length() ? consumed : header.length();
                    header.skip(len);
                    consumed -= len;
                    this._gather[0].position(0);
                    this._gather[0].limit(this._gather[0].capacity());
                }
                assert (consumed == 0);
            }
        }
        switch (this._result.getStatus()) {
            case BUFFER_OVERFLOW: 
            case BUFFER_UNDERFLOW: {
                Log.warn((String)"unwrap {}", (Object)this._result);
            }
            case OK: {
                return this._result.bytesConsumed();
            }
            case CLOSED: {
                this._closing = true;
                return this._result.bytesConsumed() > 0 ? this._result.bytesConsumed() : -1;
            }
        }
        Log.warn((String)("wrap " + this._result));
        throw new IOException(this._result.toString());
    }

    public boolean isBufferingInput() {
        return this._inNIOBuffer.hasContent();
    }

    public boolean isBufferingOutput() {
        return this._outNIOBuffer.hasContent();
    }

    public boolean isBufferred() {
        return true;
    }

    public SSLEngine getSSLEngine() {
        return this._engine;
    }

    public String toString() {
        return super.toString() + "," + (Object)((Object)this._engine.getHandshakeStatus()) + ", in/out=" + this._inNIOBuffer.length() + "/" + this._outNIOBuffer.length() + " last " + this._last + " " + this._result;
    }
}

