/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.http.ssl.AliasedX509ExtendedKeyManager;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.security.CertificateValidator;

public class SslContextFactory
extends AbstractLifeCycle {
    public static final String DEFAULT_KEYMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    public static final String DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    public static final String DEFAULT_KEYSTORE_PATH = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String KEYPASSWORD_PROPERTY = "org.eclipse.jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "org.eclipse.jetty.ssl.password";
    private Set<String> _excludeCipherSuites = null;
    private Set<String> _includeCipherSuites = null;
    private String _keyStorePath;
    private String _keyStoreProvider;
    private String _keyStoreType = "JKS";
    private InputStream _keyStoreInputStream;
    private String _certAlias;
    private String _trustStorePath;
    private String _trustStoreProvider;
    private String _trustStoreType = "JKS";
    private InputStream _trustStoreInputStream;
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private boolean _allowRenegotiate = true;
    private transient Password _keyStorePassword;
    private transient Password _keyManagerPassword;
    private transient Password _trustStorePassword;
    private String _sslProvider;
    private String _sslProtocol = "TLS";
    private String _secureRandomAlgorithm;
    private String _keyManagerFactoryAlgorithm = DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    private String _trustManagerFactoryAlgorithm = DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM;
    private boolean _validateCerts;
    private boolean _validatePeerCerts;
    private int _maxCertPathLength = -1;
    private String _crlPath;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;
    private KeyStore _keyStore;
    private KeyStore _trustStore;
    private boolean _sessionCachingEnabled = true;
    private int _sslSessionCacheSize;
    private int _sslSessionTimeout;
    private SSLContext _context;

    public SslContextFactory() {
    }

    public SslContextFactory(String keyStorePath) {
        this._keyStorePath = keyStorePath;
    }

    protected void doStart() throws Exception {
        if (this._context == null) {
            if (this._keyStoreInputStream == null && this._keyStorePath == null && this._trustStoreInputStream == null && this._trustStorePath == null) {
                X509TrustManager trustAllCerts = new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                };
                this._context = SSLContext.getInstance(this._sslProtocol);
                this._context.init(null, new TrustManager[]{trustAllCerts}, null);
            } else {
                this.createSSLContext();
            }
        }
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites.toArray(new String[this._excludeCipherSuites.size()]);
    }

    public void setExcludeCipherSuites(String[] cipherSuites) {
        this.checkStarted();
        this._excludeCipherSuites = new HashSet<String>(Arrays.asList(cipherSuites));
    }

    public String[] getIncludeCipherSuites() {
        return this._includeCipherSuites.toArray(new String[this._includeCipherSuites.size()]);
    }

    public void setIncludeCipherSuites(String[] cipherSuites) {
        this.checkStarted();
        this._includeCipherSuites = new HashSet<String>(Arrays.asList(cipherSuites));
    }

    public String getKeyStore() {
        return this._keyStorePath;
    }

    public void setKeyStore(String keyStorePath) {
        this.checkStarted();
        this._keyStorePath = keyStorePath;
    }

    public String getKeyStoreProvider() {
        return this._keyStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.checkStarted();
        this._keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.checkStarted();
        this._keyStoreType = keyStoreType;
    }

    @Deprecated
    public InputStream getKeyStoreInputStream() {
        this.checkConfig();
        return this._keyStoreInputStream;
    }

    @Deprecated
    public void setKeyStoreInputStream(InputStream keyStoreInputStream) {
        this.checkStarted();
        this._keyStoreInputStream = keyStoreInputStream;
    }

    public String getCertAlias() {
        return this._certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.checkStarted();
        this._certAlias = certAlias;
    }

    public String getTrustStore() {
        return this._trustStorePath;
    }

    public void setTrustStore(String trustStorePath) {
        this.checkStarted();
        this._trustStorePath = trustStorePath;
    }

    public String getTrustStoreProvider() {
        return this._trustStoreProvider;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.checkStarted();
        this._trustStoreProvider = trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.checkStarted();
        this._trustStoreType = trustStoreType;
    }

    @Deprecated
    public InputStream getTrustStoreInputStream() {
        this.checkConfig();
        return this._trustStoreInputStream;
    }

    @Deprecated
    public void setTrustStoreInputStream(InputStream trustStoreInputStream) {
        this.checkStarted();
        this._trustStoreInputStream = trustStoreInputStream;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.checkStarted();
        this._needClientAuth = needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.checkStarted();
        this._wantClientAuth = wantClientAuth;
    }

    @Deprecated
    public boolean getValidateCerts() {
        return this._validateCerts;
    }

    public boolean isValidateCerts() {
        return this._validateCerts;
    }

    public void setValidateCerts(boolean validateCerts) {
        this.checkStarted();
        this._validateCerts = validateCerts;
    }

    public boolean isValidatePeerCerts() {
        return this._validatePeerCerts;
    }

    public void setValidatePeerCerts(boolean validatePeerCerts) {
        this.checkStarted();
        this._validatePeerCerts = validatePeerCerts;
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this.checkStarted();
        this._allowRenegotiate = allowRenegotiate;
    }

    public void setKeyStorePassword(String password) {
        this.checkStarted();
        this._keyStorePassword = Password.getPassword(PASSWORD_PROPERTY, password, null);
    }

    public void setKeyManagerPassword(String password) {
        this.checkStarted();
        this._keyManagerPassword = Password.getPassword(KEYPASSWORD_PROPERTY, password, null);
    }

    public void setTrustStorePassword(String password) {
        this.checkStarted();
        this._trustStorePassword = Password.getPassword(PASSWORD_PROPERTY, password, null);
    }

    public String getProvider() {
        return this._sslProvider;
    }

    public void setProvider(String provider) {
        this.checkStarted();
        this._sslProvider = provider;
    }

    public String getProtocol() {
        return this._sslProtocol;
    }

    public void setProtocol(String protocol) {
        this.checkStarted();
        this._sslProtocol = protocol;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this.checkStarted();
        this._secureRandomAlgorithm = algorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._keyManagerFactoryAlgorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this.checkStarted();
        this._keyManagerFactoryAlgorithm = algorithm;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    public void setTrustManagerFactoryAlgorithm(String algorithm) {
        this.checkStarted();
        this._trustManagerFactoryAlgorithm = algorithm;
    }

    public String getCrlPath() {
        return this._crlPath;
    }

    public void setCrlPath(String crlPath) {
        this.checkStarted();
        this._crlPath = crlPath;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    public void setMaxCertPathLength(int maxCertPathLength) {
        this.checkStarted();
        this._maxCertPathLength = maxCertPathLength;
    }

    public SSLContext getSslContext() {
        return this._context;
    }

    public void setSslContext(SSLContext sslContext) {
        this.checkStarted();
        this._context = sslContext;
    }

    protected void createSSLContext() throws Exception {
        this.checkConfig();
        KeyStore keyStore = this.loadKeyStore();
        KeyStore trustStore = this.loadTrustStore();
        Collection<? extends CRL> crls = this.loadCRL(this._crlPath);
        if (this._validateCerts && keyStore != null) {
            Certificate cert;
            if (this._certAlias == null) {
                ArrayList<String> aliases = Collections.list(keyStore.aliases());
                this._certAlias = aliases.size() == 1 ? (String)aliases.get(0) : null;
            }
            Certificate certificate = cert = this._certAlias == null ? null : keyStore.getCertificate(this._certAlias);
            if (cert == null) {
                throw new Exception("No certificate found in the keystore" + (this._certAlias == null ? "" : " for alias " + this._certAlias));
            }
            CertificateValidator validator = new CertificateValidator(trustStore, crls);
            validator.setMaxCertPathLength(this._maxCertPathLength);
            validator.setEnableCRLDP(this._enableCRLDP);
            validator.setEnableOCSP(this._enableOCSP);
            validator.setOcspResponderURL(this._ocspResponderURL);
            validator.validate(keyStore, cert);
        }
        KeyManager[] keyManagers = this.getKeyManagers(keyStore);
        TrustManager[] trustManagers = this.getTrustManagers(trustStore, crls);
        SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
        this._context = this._sslProvider == null ? SSLContext.getInstance(this._sslProtocol) : SSLContext.getInstance(this._sslProtocol, this._sslProvider);
        this._context.init(keyManagers, trustManagers, secureRandom);
        SSLSessionContext sslSessionContext = this._context.getServerSessionContext();
        sslSessionContext.setSessionCacheSize(this._sslSessionCacheSize);
        sslSessionContext.setSessionTimeout(this._sslSessionTimeout);
    }

    protected KeyStore loadKeyStore() throws Exception {
        return this._keyStore != null ? this._keyStore : this.getKeyStore(this._keyStoreInputStream, this._keyStorePath, this._keyStoreType, this._keyStoreProvider, this._keyStorePassword == null ? null : this._keyStorePassword.toString());
    }

    protected KeyStore loadTrustStore() throws Exception {
        return this._trustStore != null ? this._trustStore : this.getKeyStore(this._trustStoreInputStream, this._trustStorePath, this._trustStoreType, this._trustStoreProvider, this._trustStorePassword == null ? null : this._trustStorePassword.toString());
    }

    @Deprecated
    protected KeyStore getKeyStore(InputStream storeStream, String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        return CertificateUtils.getKeyStore((InputStream)storeStream, (String)storePath, (String)storeType, (String)storeProvider, (String)storePassword);
    }

    protected Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        return CertificateUtils.loadCRL((String)crlPath);
    }

    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManager[] managers = null;
        if (keyStore != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._keyManagerFactoryAlgorithm);
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? (this._keyStorePassword == null ? null : this._keyStorePassword.toString().toCharArray()) : this._keyManagerPassword.toString().toCharArray());
            managers = keyManagerFactory.getKeyManagers();
            if (this._certAlias != null) {
                for (int idx = 0; idx < managers.length; ++idx) {
                    if (!(managers[idx] instanceof X509KeyManager)) continue;
                    managers[idx] = new AliasedX509ExtendedKeyManager(this._certAlias, (X509KeyManager)managers[idx]);
                }
            }
        }
        return managers;
    }

    protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        TrustManager[] managers = null;
        if (trustStore != null) {
            if (this._validatePeerCerts && this._trustManagerFactoryAlgorithm.equalsIgnoreCase("PKIX")) {
                PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                pbParams.setMaxPathLength(this._maxCertPathLength);
                pbParams.setRevocationEnabled(true);
                if (crls != null && !crls.isEmpty()) {
                    pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
                }
                if (this._enableCRLDP) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                }
                if (this._enableOCSP) {
                    Security.setProperty("ocsp.enable", "true");
                    if (this._ocspResponderURL != null) {
                        Security.setProperty("ocsp.responderURL", this._ocspResponderURL);
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(new CertPathTrustManagerParameters(pbParams));
                managers = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(trustStore);
                managers = trustManagerFactory.getTrustManagers();
            }
        }
        return managers;
    }

    public boolean checkConfig() {
        boolean check = true;
        if (this._keyStore == null && this._keyStoreInputStream == null && this._keyStorePath == null) {
            check = false;
        } else if (this._trustStore == null && this._trustStoreInputStream == null && this._trustStorePath == null) {
            this._trustStore = this._keyStore;
            this._trustStorePath = this._keyStorePath;
            this._trustStoreInputStream = this._keyStoreInputStream;
            this._trustStoreType = this._keyStoreType;
            this._trustStoreProvider = this._keyStoreProvider;
            this._trustStorePassword = this._keyStorePassword;
            this._trustManagerFactoryAlgorithm = this._keyManagerFactoryAlgorithm;
        }
        if (this._keyStoreInputStream != null && this._keyStoreInputStream == this._trustStoreInputStream) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IO.copy((InputStream)this._keyStoreInputStream, (OutputStream)baos);
                this._keyStoreInputStream.close();
                this._keyStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
                this._trustStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return check;
    }

    public String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
        HashSet<Object> selectedCipherSuites = null;
        selectedCipherSuites = enabledCipherSuites != null ? new HashSet<String>(Arrays.asList(enabledCipherSuites)) : new HashSet();
        if (supportedCipherSuites != null && supportedCipherSuites.length > 0 && this._includeCipherSuites != null && this._includeCipherSuites.size() > 0) {
            HashSet<String> supportedCSList = new HashSet<String>(Arrays.asList(supportedCipherSuites));
            for (String cipherName : this._includeCipherSuites) {
                if (selectedCipherSuites.contains(cipherName) || !supportedCSList.contains(cipherName)) continue;
                selectedCipherSuites.add(cipherName);
            }
        }
        if (this._excludeCipherSuites != null && this._excludeCipherSuites.size() > 0) {
            for (String cipherName : this._excludeCipherSuites) {
                if (!selectedCipherSuites.contains(cipherName)) continue;
                selectedCipherSuites.remove(cipherName);
            }
        }
        return selectedCipherSuites.toArray(new String[selectedCipherSuites.size()]);
    }

    protected void checkStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot modify configuration after SslContextFactory was started");
        }
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    public void setEnableCRLDP(boolean enableCRLDP) {
        this.checkStarted();
        this._enableCRLDP = enableCRLDP;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    public void setEnableOCSP(boolean enableOCSP) {
        this.checkStarted();
        this._enableOCSP = enableOCSP;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    public void setOcspResponderURL(String ocspResponderURL) {
        this.checkStarted();
        this._ocspResponderURL = ocspResponderURL;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.checkStarted();
        this._keyStore = keyStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.checkStarted();
        this._trustStore = trustStore;
    }

    public void setKeyStoreResource(Resource resource) {
        this.checkStarted();
        try {
            this._keyStoreInputStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new InvalidParameterException("Unable to get resource input stream for resource " + resource.toString());
        }
    }

    public void setTrustStore(Resource resource) {
        this.checkStarted();
        try {
            this._trustStoreInputStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new InvalidParameterException("Unable to get resource input stream for resource " + resource.toString());
        }
    }

    public boolean isSessionCachingEnabled() {
        return this._sessionCachingEnabled;
    }

    public void setSessionCachingEnabled(boolean enableSessionCaching) {
        this._sessionCachingEnabled = enableSessionCaching;
    }

    public int getSslSessionCacheSize() {
        return this._sslSessionCacheSize;
    }

    public void setSslSessionCacheSize(int sslSessionCacheSize) {
        this._sslSessionCacheSize = sslSessionCacheSize;
    }

    public int getSslSessionTimeout() {
        return this._sslSessionTimeout;
    }

    public void setSslSessionTimeout(int sslSessionTimeout) {
        this._sslSessionTimeout = sslSessionTimeout;
    }
}

