/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpParser {
    public static final Logger LOG = Log.getLogger(HttpParser.class);
    private final HttpHandler<ByteBuffer> _handler;
    private final RequestHandler<ByteBuffer> _requestHandler;
    private final ResponseHandler<ByteBuffer> _responseHandler;
    private final int _maxHeaderBytes;
    private HttpHeader _header;
    private String _headerString;
    private HttpHeaderValue _value;
    private String _valueString;
    private int _responseStatus;
    private int _headerBytes;
    private boolean _host;
    private volatile State _state = State.START;
    private HttpMethod _method;
    private String _methodString;
    private HttpVersion _version;
    private String _uri;
    private byte _eol;
    private HttpTokens.EndOfContent _endOfContent;
    private long _contentLength;
    private long _contentPosition;
    private int _chunkLength;
    private int _chunkPosition;
    private boolean _headResponse;
    private ByteBuffer _contentChunk;
    private int _length;
    private final StringBuilder _string = new StringBuilder();
    private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();

    public HttpParser(RequestHandler<ByteBuffer> handler) {
        this(handler, -1);
    }

    public HttpParser(ResponseHandler<ByteBuffer> handler) {
        this(handler, -1);
    }

    public HttpParser(RequestHandler<ByteBuffer> handler, int maxHeaderBytes) {
        this._handler = handler;
        this._requestHandler = handler;
        this._responseHandler = null;
        this._maxHeaderBytes = maxHeaderBytes;
    }

    public HttpParser(ResponseHandler<ByteBuffer> handler, int maxHeaderBytes) {
        this._handler = handler;
        this._requestHandler = null;
        this._responseHandler = handler;
        this._maxHeaderBytes = maxHeaderBytes;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public long getContentRead() {
        return this._contentPosition;
    }

    public void setHeadResponse(boolean head) {
        this._headResponse = head;
    }

    public State getState() {
        return this._state;
    }

    public boolean inContentState() {
        return this._state.ordinal() > State.END.ordinal();
    }

    public boolean inHeaderState() {
        return this._state.ordinal() < State.END.ordinal();
    }

    public boolean isInContent() {
        return this._state.ordinal() > State.END.ordinal() && this._state.ordinal() < State.CLOSED.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isStart() {
        return this.isState(State.START);
    }

    public boolean isClosed() {
        return this.isState(State.CLOSED);
    }

    public boolean isIdle() {
        return this.isState(State.START) || this.isState(State.END) || this.isState(State.CLOSED);
    }

    public boolean isComplete() {
        return this.isState(State.END) || this.isState(State.CLOSED);
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    private void quickStart(ByteBuffer buffer) {
        while (this._state == State.START && buffer.hasRemaining()) {
            if (this._requestHandler != null) {
                this._method = HttpMethod.lookAheadGet(buffer);
                if (this._method != null) {
                    this._methodString = this._method.asString();
                    buffer.position(buffer.position() + this._methodString.length() + 1);
                    this.setState(State.SPACE1);
                    return;
                }
            } else if (this._responseHandler != null) {
                this._version = HttpVersion.lookAheadGet(buffer);
                if (this._version != null) {
                    buffer.position(buffer.position() + this._version.asString().length() + 1);
                    this.setState(State.SPACE1);
                    return;
                }
            }
            byte ch = buffer.get();
            if (this._eol == 13 && ch == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            if (ch <= 32 && ch >= 0) continue;
            this._string.setLength(0);
            this._string.append((char)ch);
            this.setState(this._requestHandler != null ? State.METHOD : State.RESPONSE_VERSION);
            return;
        }
    }

    private String takeString() {
        String s = this._string.toString();
        this._string.setLength(0);
        return s;
    }

    private String takeLengthString() {
        this._string.setLength(this._length);
        String s = this._string.toString();
        this._string.setLength(0);
        this._length = -1;
        return s;
    }

    private boolean parseLine(ByteBuffer buffer) {
        boolean return_from_parse = false;
        block10: while (this._state.ordinal() < State.HEADER.ordinal() && buffer.hasRemaining() && !return_from_parse) {
            byte ch = buffer.get();
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                if (this._state == State.URI) {
                    LOG.warn("URI is too large >" + this._maxHeaderBytes, new Object[0]);
                    this.badMessage(buffer, 414, null);
                } else {
                    if (this._requestHandler != null) {
                        LOG.warn("request is too large >" + this._maxHeaderBytes, new Object[0]);
                    } else {
                        LOG.warn("response is too large >" + this._maxHeaderBytes, new Object[0]);
                    }
                    this.badMessage(buffer, 413, null);
                }
                return true;
            }
            if (this._eol == 13 && ch == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case METHOD: {
                    if (ch == 32) {
                        this._methodString = this.takeString();
                        HttpMethod method = (HttpMethod)((Object)HttpMethod.CACHE.get(this._methodString));
                        if (method != null) {
                            this._methodString = method.asString();
                        }
                        this.setState(State.SPACE1);
                        continue block10;
                    }
                    if (ch < 32 && ch >= 0) {
                        this.badMessage(buffer, 400, "No URI");
                        return true;
                    }
                    this._string.append((char)ch);
                    continue block10;
                }
                case RESPONSE_VERSION: {
                    String version;
                    if (ch == 32) {
                        version = this.takeString();
                        this._version = (HttpVersion)((Object)HttpVersion.CACHE.get(version));
                        if (this._version == null) {
                            this.badMessage(buffer, 400, "Unknown Version");
                            return true;
                        }
                        this.setState(State.SPACE1);
                        continue block10;
                    }
                    if (ch < 32 && ch >= 0) {
                        this.badMessage(buffer, 400, "No Status");
                        return true;
                    }
                    this._string.append((char)ch);
                    continue block10;
                }
                case SPACE1: {
                    if (ch > 32 || ch < 0) {
                        if (this._responseHandler != null) {
                            this.setState(State.STATUS);
                            this._responseStatus = ch - 48;
                            continue block10;
                        }
                        this.setState(State.URI);
                        this._utf8.reset();
                        this._utf8.append(ch);
                        continue block10;
                    }
                    if (ch >= 32) continue block10;
                    this.badMessage(buffer, 400, this._requestHandler != null ? "No URI" : "No Status");
                    return true;
                }
                case STATUS: {
                    if (ch == 32) {
                        this.setState(State.SPACE2);
                        continue block10;
                    }
                    if (ch >= 48 && ch <= 57) {
                        this._responseStatus = this._responseStatus * 10 + (ch - 48);
                        continue block10;
                    }
                    if (ch < 32 && ch >= 0) {
                        return_from_parse |= this._responseHandler.startResponse(this._version, this._responseStatus, null);
                        this._eol = ch;
                        this.setState(State.HEADER);
                        continue block10;
                    }
                    throw new IllegalStateException();
                }
                case URI: {
                    if (ch == 32) {
                        this._uri = this._utf8.toString();
                        this._utf8.reset();
                        this.setState(State.SPACE2);
                        continue block10;
                    }
                    if (ch < 32 && ch >= 0) {
                        this._uri = this._utf8.toString();
                        this._utf8.reset();
                        return_from_parse |= this._requestHandler.startRequest(this._method, this._methodString, this._uri, null);
                        this.setState(State.END);
                        BufferUtil.clear((ByteBuffer)buffer);
                        return_from_parse |= this._handler.headerComplete();
                        return_from_parse |= this._handler.messageComplete(this._contentPosition);
                        continue block10;
                    }
                    this._utf8.append(ch);
                    continue block10;
                }
                case SPACE2: {
                    if (ch > 32 || ch < 0) {
                        this._string.setLength(0);
                        this._string.append((char)ch);
                        if (this._responseHandler != null) {
                            this._length = 1;
                            this.setState(State.REASON);
                            continue block10;
                        }
                        this.setState(State.REQUEST_VERSION);
                        if (buffer.position() <= 0 || !buffer.hasArray()) continue block10;
                        this._version = HttpVersion.lookAheadGet(buffer.array(), buffer.arrayOffset() + buffer.position() - 1, buffer.arrayOffset() + buffer.limit());
                        if (this._version == null) continue block10;
                        this._string.setLength(0);
                        buffer.position(buffer.position() + this._version.asString().length() - 1);
                        this._eol = buffer.get();
                        this.setState(State.HEADER);
                        return_from_parse |= this._requestHandler.startRequest(this._method, this._methodString, this._uri, this._version);
                        continue block10;
                    }
                    if (ch >= 32) continue block10;
                    if (this._responseHandler != null) {
                        return_from_parse |= this._responseHandler.startResponse(this._version, this._responseStatus, null);
                        this._eol = ch;
                        this.setState(State.HEADER);
                        continue block10;
                    }
                    return_from_parse |= this._requestHandler.startRequest(this._method, this._methodString, this._uri, null);
                    this.setState(State.END);
                    BufferUtil.clear((ByteBuffer)buffer);
                    return_from_parse |= this._handler.headerComplete();
                    return_from_parse |= this._handler.messageComplete(this._contentPosition);
                    continue block10;
                }
                case REQUEST_VERSION: {
                    String version;
                    if (ch == 13 || ch == 10) {
                        version = this.takeString();
                        this._version = (HttpVersion)((Object)HttpVersion.CACHE.get(version));
                        if (this._version == null) {
                            this.badMessage(buffer, 400, "Unknown Version");
                            return true;
                        }
                        this._eol = ch;
                        this.setState(State.HEADER);
                        return_from_parse |= this._requestHandler.startRequest(this._method, this._methodString, this._uri, this._version);
                        continue block10;
                    }
                    this._string.append((char)ch);
                    continue block10;
                }
                case REASON: {
                    if (ch == 13 || ch == 10) {
                        String reason = this.takeLengthString();
                        this._eol = ch;
                        this.setState(State.HEADER);
                        return_from_parse |= this._responseHandler.startResponse(this._version, this._responseStatus, reason);
                        continue block10;
                    }
                    this._string.append((char)ch);
                    if (ch == 32 || ch == 9) continue block10;
                    this._length = this._string.length();
                    continue block10;
                }
            }
            throw new IllegalStateException(this._state.toString());
        }
        return return_from_parse;
    }

    private boolean parseHeaders(ByteBuffer buffer) {
        boolean return_from_parse = false;
        block46: while (this._state.ordinal() < State.END.ordinal() && buffer.hasRemaining() && !return_from_parse) {
            byte ch = buffer.get();
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                LOG.warn("Header is too large >" + this._maxHeaderBytes, new Object[0]);
                this.badMessage(buffer, 413, null);
                return true;
            }
            if (this._eol == 13 && ch == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case HEADER: {
                    switch (ch) {
                        case 9: 
                        case 32: 
                        case 58: {
                            this._length = -1;
                            this._string.setLength(0);
                            this.setState(State.HEADER_VALUE);
                            continue block46;
                        }
                    }
                    if (this._headerString != null || this._valueString != null) {
                        if (this._header != null) {
                            switch (this._header) {
                                case CONTENT_LENGTH: {
                                    if (this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus >= 100 && this._responseStatus < 200) break;
                                    try {
                                        this._contentLength = Long.parseLong(this._valueString);
                                    }
                                    catch (NumberFormatException e) {
                                        LOG.ignore((Throwable)e);
                                        this.badMessage(buffer, 400, "Bad Content-Length");
                                        return true;
                                    }
                                    if (this._contentLength <= 0L) {
                                        this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                                        break;
                                    }
                                    this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                                    break;
                                }
                                case TRANSFER_ENCODING: {
                                    if (this._value == HttpHeaderValue.CHUNKED) {
                                        this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                                        break;
                                    }
                                    if (this._valueString.endsWith(HttpHeaderValue.CHUNKED.toString())) {
                                        this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                                        break;
                                    }
                                    if (this._valueString.indexOf(HttpHeaderValue.CHUNKED.toString()) < 0) break;
                                    this.badMessage(buffer, 400, "Bad chunking");
                                    return true;
                                }
                                case HOST: {
                                    this._host = true;
                                    String host = this._valueString;
                                    int port = 0;
                                    if (host == null || host.length() == 0) {
                                        this.badMessage(buffer, 400, "Bad Host header");
                                        return true;
                                    }
                                    int i = host.length();
                                    block47: while (i-- > 0) {
                                        char c2 = (char)(0xFF & host.charAt(i));
                                        switch (c2) {
                                            case ']': {
                                                break block47;
                                            }
                                            case ':': {
                                                try {
                                                    port = StringUtil.toInt((String)host.substring(i + 1));
                                                }
                                                catch (NumberFormatException e) {
                                                    LOG.debug((Throwable)e);
                                                    this.badMessage(buffer, 400, "Bad Host header");
                                                    return true;
                                                }
                                                host = host.substring(0, i);
                                                break block47;
                                            }
                                            default: {
                                                continue block47;
                                            }
                                        }
                                    }
                                    if (this._requestHandler == null) break;
                                    this._requestHandler.parsedHostHeader(host, port);
                                }
                            }
                        }
                        return_from_parse |= this._handler.parsedHeader(this._header, this._headerString, this._valueString);
                    }
                    this._valueString = null;
                    this._headerString = null;
                    this._header = null;
                    this._value = null;
                    if (ch == 13 || ch == 10) {
                        this.consumeCRLF(ch, buffer);
                        this._contentPosition = 0L;
                        if (!this._host && this._version != HttpVersion.HTTP_1_0 && this._requestHandler != null) {
                            this.badMessage(buffer, 400, "No Host");
                            return true;
                        }
                        if (this._endOfContent == HttpTokens.EndOfContent.UNKNOWN_CONTENT) {
                            this._endOfContent = this._responseStatus == 0 || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200 ? HttpTokens.EndOfContent.NO_CONTENT : HttpTokens.EndOfContent.EOF_CONTENT;
                        }
                        switch (this._endOfContent) {
                            case EOF_CONTENT: {
                                this.setState(State.EOF_CONTENT);
                                return_from_parse |= this._handler.headerComplete();
                                continue block46;
                            }
                            case CHUNKED_CONTENT: {
                                this.setState(State.CHUNKED_CONTENT);
                                return_from_parse |= this._handler.headerComplete();
                                continue block46;
                            }
                            case NO_CONTENT: {
                                return_from_parse |= this._handler.headerComplete();
                                this.setState(State.END);
                                return_from_parse |= this._handler.messageComplete(this._contentPosition);
                                continue block46;
                            }
                        }
                        this.setState(State.CONTENT);
                        return_from_parse |= this._handler.headerComplete();
                        continue block46;
                    }
                    if (buffer.remaining() > 6 && buffer.hasArray()) {
                        this._header = HttpHeader.lookAheadGet(buffer.array(), buffer.arrayOffset() + buffer.position() - 1, buffer.arrayOffset() + buffer.limit());
                        if (this._header != null) {
                            this._headerString = this._header.asString();
                            buffer.position(buffer.position() + this._headerString.length());
                            this.setState(buffer.get(buffer.position() - 1) == 58 ? State.HEADER_VALUE : State.HEADER_NAME);
                            continue block46;
                        }
                    }
                    this.setState(State.HEADER_NAME);
                    this._string.setLength(0);
                    this._string.append((char)ch);
                    this._length = 1;
                    continue block46;
                }
                case HEADER_NAME: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            this._headerString = this.takeLengthString();
                            this._header = (HttpHeader)((Object)HttpHeader.CACHE.get(this._headerString));
                            this.setState(State.HEADER);
                            continue block46;
                        }
                        case 58: {
                            if (this._headerString == null) {
                                this._headerString = this.takeLengthString();
                                this._header = (HttpHeader)((Object)HttpHeader.CACHE.get(this._headerString));
                            }
                            this.setState(State.HEADER_VALUE);
                            continue block46;
                        }
                        case 9: 
                        case 32: {
                            this._string.append((char)ch);
                            continue block46;
                        }
                    }
                    if (this._header != null) {
                        this._string.setLength(0);
                        this._string.append(this._header.asString());
                        this._string.append(' ');
                        this._length = this._string.length();
                        this._header = null;
                        this._headerString = null;
                    }
                    this._string.append((char)ch);
                    this._length = this._string.length();
                    this.setState(State.HEADER_IN_NAME);
                    continue block46;
                }
                case HEADER_IN_NAME: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            this._headerString = this.takeString();
                            this._length = -1;
                            this._header = (HttpHeader)((Object)HttpHeader.CACHE.get(this._headerString));
                            this.setState(State.HEADER);
                            continue block46;
                        }
                        case 58: {
                            if (this._headerString == null) {
                                this._headerString = this.takeString();
                                this._header = (HttpHeader)((Object)HttpHeader.CACHE.get(this._headerString));
                            }
                            this._length = -1;
                            this.setState(State.HEADER_VALUE);
                            continue block46;
                        }
                        case 9: 
                        case 32: {
                            this.setState(State.HEADER_NAME);
                            this._string.append((char)ch);
                            continue block46;
                        }
                    }
                    this._string.append((char)ch);
                    ++this._length;
                    continue block46;
                }
                case HEADER_VALUE: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            if (this._length > 0) {
                                if (this._valueString != null) {
                                    this._value = null;
                                    this._valueString = this._valueString + " " + this.takeLengthString();
                                } else if (HttpHeaderValue.hasKnownValues(this._header)) {
                                    this._valueString = this.takeLengthString();
                                    this._value = (HttpHeaderValue)((Object)HttpHeaderValue.CACHE.get(this._valueString));
                                } else {
                                    this._value = null;
                                    this._valueString = this.takeLengthString();
                                }
                            }
                            this.setState(State.HEADER);
                            continue block46;
                        }
                        case 9: 
                        case 32: {
                            continue block46;
                        }
                    }
                    this._string.append((char)ch);
                    this._length = this._string.length();
                    this.setState(State.HEADER_IN_VALUE);
                    continue block46;
                }
                case HEADER_IN_VALUE: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            if (this._length > 0) {
                                if (this._valueString != null) {
                                    this._value = null;
                                    this._valueString = this._valueString + " " + this.takeString();
                                } else if (HttpHeaderValue.hasKnownValues(this._header)) {
                                    this._valueString = this.takeString();
                                    this._value = (HttpHeaderValue)((Object)HttpHeaderValue.CACHE.get(this._valueString));
                                } else {
                                    this._value = null;
                                    this._valueString = this.takeString();
                                }
                                this._length = -1;
                            }
                            this.setState(State.HEADER);
                            continue block46;
                        }
                        case 9: 
                        case 32: {
                            this._string.append((char)ch);
                            this.setState(State.HEADER_VALUE);
                            continue block46;
                        }
                    }
                    this._string.append((char)ch);
                    ++this._length;
                    continue block46;
                }
            }
            throw new IllegalStateException(this._state.toString());
        }
        return return_from_parse;
    }

    private void consumeCRLF(byte ch, ByteBuffer buffer) {
        this._eol = ch;
        if (this._eol == 13 && buffer.hasRemaining() && buffer.get(buffer.position()) == 10) {
            buffer.get();
            this._eol = 0;
        }
    }

    public boolean parseNext(ByteBuffer buffer) {
        try {
            switch (this._state) {
                case START: {
                    this._version = null;
                    this._method = null;
                    this._methodString = null;
                    this._uri = null;
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    this._header = null;
                    this.quickStart(buffer);
                    break;
                }
                case CONTENT: {
                    if (this._contentPosition != this._contentLength) break;
                    this.setState(State.END);
                    if (!this._handler.messageComplete(this._contentPosition)) break;
                    return true;
                }
                case END: {
                    return false;
                }
                case CLOSED: {
                    if (BufferUtil.hasContent((ByteBuffer)buffer)) {
                        int len = buffer.remaining();
                        this._headerBytes += len;
                        if (this._headerBytes > this._maxHeaderBytes) {
                            Thread.sleep(100L);
                            String chars = BufferUtil.toDetailString((ByteBuffer)buffer);
                            BufferUtil.clear((ByteBuffer)buffer);
                            throw new IllegalStateException(String.format("%s %d/%d data when CLOSED:%s", this, len, this._headerBytes, chars));
                        }
                        BufferUtil.clear((ByteBuffer)buffer);
                    }
                    return false;
                }
            }
            if (this._state.ordinal() < State.HEADER.ordinal() && this.parseLine(buffer)) {
                return true;
            }
            if (this._state.ordinal() < State.END.ordinal() && this.parseHeaders(buffer)) {
                return true;
            }
            if (this._responseStatus > 0 && this._headResponse) {
                this.setState(State.END);
                if (this._handler.messageComplete(this._contentLength)) {
                    return true;
                }
            }
            while (this._state.ordinal() > State.END.ordinal() && buffer.hasRemaining()) {
                if (this._eol == 13 && buffer.get(buffer.position()) == 10) {
                    this._eol = buffer.get();
                    continue;
                }
                this._eol = 0;
                switch (this._state) {
                    case EOF_CONTENT: {
                        this._contentChunk = buffer.asReadOnlyBuffer();
                        this._contentPosition += (long)this._contentChunk.remaining();
                        buffer.position(buffer.position() + this._contentChunk.remaining());
                        if (!this._handler.content(this._contentChunk)) break;
                        return true;
                    }
                    case CONTENT: {
                        long remaining = this._contentLength - this._contentPosition;
                        if (remaining == 0L) {
                            this.setState(State.END);
                            if (!this._handler.messageComplete(this._contentPosition)) break;
                            return true;
                        }
                        this._contentChunk = buffer.asReadOnlyBuffer();
                        if ((long)this._contentChunk.remaining() > remaining) {
                            this._contentChunk.limit(this._contentChunk.position() + (int)remaining);
                        }
                        this._contentPosition += (long)this._contentChunk.remaining();
                        buffer.position(buffer.position() + this._contentChunk.remaining());
                        if (this._handler.content(this._contentChunk)) {
                            return true;
                        }
                        if (this._contentPosition != this._contentLength) break;
                        this.setState(State.END);
                        if (!this._handler.messageComplete(this._contentPosition)) break;
                        return true;
                    }
                    case CHUNKED_CONTENT: {
                        byte ch = buffer.get(buffer.position());
                        if (ch == 13 || ch == 10) {
                            this._eol = buffer.get();
                            break;
                        }
                        if (ch <= 32) {
                            buffer.get();
                            break;
                        }
                        this._chunkLength = 0;
                        this._chunkPosition = 0;
                        this.setState(State.CHUNK_SIZE);
                        break;
                    }
                    case CHUNK_SIZE: {
                        byte ch = buffer.get();
                        if (ch == 13 || ch == 10) {
                            this._eol = ch;
                            if (this._chunkLength == 0) {
                                if (this._eol == 13 && buffer.hasRemaining() && buffer.get(buffer.position()) == 10) {
                                    this._eol = buffer.get();
                                }
                                this.setState(State.END);
                                if (!this._handler.messageComplete(this._contentPosition)) break;
                                return true;
                            }
                            this.setState(State.CHUNK);
                            break;
                        }
                        if (ch <= 32 || ch == 59) {
                            this.setState(State.CHUNK_PARAMS);
                            break;
                        }
                        if (ch >= 48 && ch <= 57) {
                            this._chunkLength = this._chunkLength * 16 + (ch - 48);
                            break;
                        }
                        if (ch >= 97 && ch <= 102) {
                            this._chunkLength = this._chunkLength * 16 + (10 + ch - 97);
                            break;
                        }
                        if (ch >= 65 && ch <= 70) {
                            this._chunkLength = this._chunkLength * 16 + (10 + ch - 65);
                            break;
                        }
                        throw new IOException("bad chunk char: " + ch);
                    }
                    case CHUNK_PARAMS: {
                        byte ch = buffer.get();
                        if (ch != 13 && ch != 10) break;
                        this._eol = ch;
                        if (this._chunkLength == 0) {
                            if (this._eol == 13 && buffer.hasRemaining() && buffer.get(buffer.position()) == 10) {
                                this._eol = buffer.get();
                            }
                            this.setState(State.END);
                            if (!this._handler.messageComplete(this._contentPosition)) break;
                            return true;
                        }
                        this.setState(State.CHUNK);
                        break;
                    }
                    case CHUNK: {
                        int remaining = this._chunkLength - this._chunkPosition;
                        if (remaining == 0) {
                            this.setState(State.CHUNKED_CONTENT);
                            break;
                        }
                        this._contentChunk = buffer.asReadOnlyBuffer();
                        if (this._contentChunk.remaining() > remaining) {
                            this._contentChunk.limit(this._contentChunk.position() + remaining);
                        }
                        remaining = this._contentChunk.remaining();
                        this._contentPosition += (long)remaining;
                        this._chunkPosition += remaining;
                        buffer.position(buffer.position() + remaining);
                        if (!this._handler.content(this._contentChunk)) break;
                        return true;
                    }
                    case CLOSED: {
                        BufferUtil.clear((ByteBuffer)buffer);
                        return false;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            BufferUtil.clear((ByteBuffer)buffer);
            if (this.isClosed()) {
                LOG.debug((Throwable)e);
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
            LOG.warn("badMessage: " + e.toString() + " for " + this._handler, new Object[0]);
            LOG.debug((Throwable)e);
            this.badMessage(buffer, 400, null);
            return true;
        }
    }

    private void badMessage(ByteBuffer buffer, int status, String reason) {
        BufferUtil.clear((ByteBuffer)buffer);
        this.setState(State.CLOSED);
        this._handler.badMessage(status, reason);
    }

    public boolean shutdownInput() {
        LOG.debug("shutdownInput {}", new Object[]{this});
        switch (this._state) {
            case START: 
            case END: {
                break;
            }
            case EOF_CONTENT: {
                this.setState(State.END);
                return this._handler.messageComplete(this._contentPosition);
            }
            case CLOSED: {
                break;
            }
            default: {
                this.setState(State.END);
                if (!this._headResponse) {
                    this._handler.earlyEOF();
                }
                return this._handler.messageComplete(this._contentPosition);
            }
        }
        return false;
    }

    public void close() {
        switch (this._state) {
            case START: 
            case END: 
            case CLOSED: {
                break;
            }
            default: {
                LOG.warn("Closing {}", new Object[]{this});
            }
        }
        this.setState(State.CLOSED);
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._contentLength = -1L;
        this._contentPosition = 0L;
        this._responseStatus = 0;
        this._headerBytes = 0;
        this._contentChunk = null;
    }

    public void reset() {
        this.setState(State.START);
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._contentLength = -1L;
        this._contentPosition = 0L;
        this._responseStatus = 0;
        this._contentChunk = null;
        this._headerBytes = 0;
        this._host = false;
    }

    private void setState(State state) {
        this._state = state;
    }

    public String toString() {
        return String.format("%s{s=%s,%d of %d}", new Object[]{this.getClass().getSimpleName(), this._state, this._contentPosition, this._contentLength});
    }

    public static interface ResponseHandler<T>
    extends HttpHandler<T> {
        public boolean startResponse(HttpVersion var1, int var2, String var3);
    }

    public static interface RequestHandler<T>
    extends HttpHandler<T> {
        public boolean startRequest(HttpMethod var1, String var2, String var3, HttpVersion var4);

        public boolean parsedHostHeader(String var1, int var2);
    }

    public static interface HttpHandler<T> {
        public boolean content(T var1);

        public boolean headerComplete();

        public boolean messageComplete(long var1);

        public boolean parsedHeader(HttpHeader var1, String var2, String var3);

        public boolean earlyEOF();

        public void badMessage(int var1, String var2);
    }

    public static enum State {
        START,
        METHOD,
        RESPONSE_VERSION,
        SPACE1,
        STATUS,
        URI,
        SPACE2,
        REQUEST_VERSION,
        REASON,
        HEADER,
        HEADER_NAME,
        HEADER_IN_NAME,
        HEADER_VALUE,
        HEADER_IN_VALUE,
        END,
        EOF_CONTENT,
        CONTENT,
        CHUNKED_CONTENT,
        CHUNK_SIZE,
        CHUNK_PARAMS,
        CHUNK,
        CLOSED;

    }
}

