/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.resource.Resource;

public interface HttpContent {
    public String getContentType();

    public String getLastModified();

    public ByteBuffer getIndirectBuffer();

    public ByteBuffer getDirectBuffer();

    public Resource getResource();

    public long getContentLength();

    public InputStream getInputStream() throws IOException;

    public void release();

    public static class ResourceAsHttpContent
    implements HttpContent {
        final Resource _resource;
        final String _mimeType;
        final int _maxBuffer;

        public ResourceAsHttpContent(Resource resource, String mimeType) {
            this._resource = resource;
            this._mimeType = mimeType;
            this._maxBuffer = -1;
        }

        public ResourceAsHttpContent(Resource resource, String mimeType, int maxBuffer) {
            this._resource = resource;
            this._mimeType = mimeType;
            this._maxBuffer = maxBuffer;
        }

        @Override
        public String getContentType() {
            return this._mimeType;
        }

        @Override
        public String getLastModified() {
            return null;
        }

        @Override
        public ByteBuffer getDirectBuffer() {
            return null;
        }

        @Override
        public ByteBuffer getIndirectBuffer() {
            try {
                int filled;
                if (this._resource.length() <= 0L || (long)this._maxBuffer < this._resource.length()) {
                    return null;
                }
                int length = (int)this._resource.length();
                byte[] array = new byte[length];
                int offset = 0;
                InputStream in = this._resource.getInputStream();
                while ((filled = in.read(array, offset, length)) >= 0) {
                    offset += filled;
                    if ((length -= filled) > 0) continue;
                }
                ByteBuffer buffer = ByteBuffer.wrap(array);
                return buffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long getContentLength() {
            return this._resource.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        @Override
        public Resource getResource() {
            return this._resource;
        }

        @Override
        public void release() {
            this._resource.release();
        }
    }
}

