/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HttpGeneratorServerTest {
    @Test
    public void testSimple() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        ByteBuffer content = BufferUtil.toBuffer((String)"0123456789");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, null, null, content, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), 10L, 200, null, false);
        info.getHttpFields().add("Content-Type", "test/data");
        info.getHttpFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, null, null, content, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        result = gen.generateResponse(info, header, null, content, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String response = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        response = response + BufferUtil.toString((ByteBuffer)content);
        BufferUtil.clear((ByteBuffer)content);
        result = gen.generateResponse(null, null, null, content, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertEquals((long)10L, (long)gen.getContentPrepared());
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 10"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0123456789"));
    }

    @Test
    public void test204() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        ByteBuffer content = BufferUtil.toBuffer((String)"0123456789");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), 10L, 204, "Foo", false);
        info.getHttpFields().add("Content-Type", "test/data");
        info.getHttpFields().add("Last-Modified", DateGenerator.__01Jan1970);
        HttpGenerator.Result result = gen.generateResponse(info, header, null, content, true);
        Assert.assertEquals((Object)gen.isNoContent(), (Object)true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String responseheaders = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, null, null, content, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertThat((Object)responseheaders, (Matcher)Matchers.containsString((String)"HTTP/1.1 204 Foo"));
        Assert.assertThat((Object)responseheaders, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        Assert.assertThat((Object)responseheaders, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length: 10")));
    }

    @Test
    public void testComplexChars() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        ByteBuffer content = BufferUtil.toBuffer((String)"0123456789");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, null, null, content, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), 10L, 200, null, false);
        info.getHttpFields().add("Content-Type", "test/data;\r\nextra=value");
        info.getHttpFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, null, null, content, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        result = gen.generateResponse(info, header, null, content, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String response = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        response = response + BufferUtil.toString((ByteBuffer)content);
        BufferUtil.clear((ByteBuffer)content);
        result = gen.generateResponse(null, null, null, content, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertEquals((long)10L, (long)gen.getContentPrepared());
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Type: test/data;  extra=value"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 10"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0123456789"));
    }

    @Test
    public void testSendServerXPoweredBy() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), -1L, 200, null, false);
        HttpFields fields = new HttpFields();
        fields.add(HttpHeader.SERVER, "SomeServer");
        fields.add(HttpHeader.X_POWERED_BY, "SomePower");
        HttpGenerator.ResponseInfo infoF = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, fields, -1L, 200, null, false);
        HttpGenerator gen = new HttpGenerator(true, true);
        gen.generateResponse(info, header, null, null, true);
        String head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)"));
        gen.reset();
        gen.generateResponse(infoF, header, null, null, true);
        head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)")));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Server: SomeServer"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: SomePower"));
        gen.reset();
        gen = new HttpGenerator(false, false);
        gen.generateResponse(info, header, null, null, true);
        head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)")));
        Assert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)")));
        gen.reset();
        gen.generateResponse(infoF, header, null, null, true);
        head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)")));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Server: SomeServer"));
        Assert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)")));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: SomePower"));
        gen.reset();
    }

    @Test
    public void testResponseNoContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), -1L, 200, null, false);
        info.getHttpFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        result = gen.generateResponse(info, header, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertEquals((long)0L, (long)gen.getContentPrepared());
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Content-Length: 0"));
    }

    @Test
    public void testResponseUpgrade() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), -1L, 101, null, false);
        info.getHttpFields().add("Upgrade", "WebSocket");
        info.getHttpFields().add("Connection", "Upgrade");
        info.getHttpFields().add("Sec-WebSocket-Accept", "123456789==");
        result = gen.generateResponse(info, header, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(info, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertEquals((long)0L, (long)gen.getContentPrepared());
        Assert.assertThat((Object)head, (Matcher)Matchers.startsWith((String)"HTTP/1.1 101 Switching Protocols"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Upgrade: WebSocket\r\n"));
        Assert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Connection: Upgrade\r\n"));
    }

    @Test
    public void testResponseWithChunkedContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), -1L, 200, null, false);
        info.getHttpFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, header, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, null, chunk, content1, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, null, chunk, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, null, chunk, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        result = gen.generateResponse(null, null, chunk, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        Assert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nD\r\n"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\nHello World! \r\n"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n2E\r\n"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\nThe quick brown fox jumped over the lazy dog. \r\n"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
    }

    @Test
    public void testResponseWithKnownContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), 59L, 200, null, false);
        info.getHttpFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, header, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, null, null, content1, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        Assert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"chunked")));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 59"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nHello World! The quick brown fox jumped over the lazy dog. "));
    }

    @Test
    public void test100ThenResponseWithContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(HttpGenerator.CONTINUE_100_INFO, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(HttpGenerator.CONTINUE_100_INFO, header, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING_1XX, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        result = gen.generateResponse(null, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 100 Continue"));
        result = gen.generateResponse(null, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, new HttpFields(), 59L, 200, null, false);
        info.getHttpFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, header, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, null, null, content1, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        Assert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"chunked")));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 59"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nHello World! The quick brown fox jumped over the lazy dog. "));
    }

    @Test
    public void testConnectionKeepAliveWithAdditionalCustomValue() throws Exception {
        HttpGenerator generator = new HttpGenerator();
        HttpFields fields = new HttpFields();
        fields.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
        String customValue = "test";
        fields.add(HttpHeader.CONNECTION, customValue);
        HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_0, fields, -1L, 200, "OK", false);
        ByteBuffer header = BufferUtil.allocate((int)4096);
        HttpGenerator.Result result = generator.generateResponse(info, header, null, null, true);
        Assert.assertSame((Object)HttpGenerator.Result.FLUSH, (Object)result);
        String headers = BufferUtil.toString((ByteBuffer)header);
        Assert.assertTrue((boolean)headers.contains(HttpHeaderValue.KEEP_ALIVE.asString()));
        Assert.assertTrue((boolean)headers.contains(customValue));
    }
}

