/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;

public class HttpTester {
    private HttpTester() {
    }

    public static Request newRequest() {
        Request r = new Request();
        r.setMethod(HttpMethod.GET.asString());
        r.setURI("/");
        r.setVersion(HttpVersion.HTTP_1_1);
        return r;
    }

    public static Request parseRequest(String request) {
        Request r = new Request();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)r);
        parser.parseNext(BufferUtil.toBuffer((String)request));
        return r;
    }

    public static Request parseRequest(ByteBuffer request) {
        Request r = new Request();
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)r);
        parser.parseNext(request);
        return r;
    }

    public static Response parseResponse(String response) {
        Response r = new Response();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)r);
        parser.parseNext(BufferUtil.toBuffer((String)response));
        return r;
    }

    public static Response parseResponse(ByteBuffer response) {
        Response r = new Response();
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)r);
        parser.parseNext(response);
        return r;
    }

    public static Input from(final InputStream in) {
        return new Input(){

            @Override
            public int fillBuffer() throws IOException {
                BufferUtil.compact((ByteBuffer)this._buffer);
                int len = in.read(this._buffer.array(), this._buffer.arrayOffset() + this._buffer.limit(), BufferUtil.space((ByteBuffer)this._buffer));
                if (len < 0) {
                    this._eof = true;
                } else {
                    this._buffer.limit(this._buffer.limit() + len);
                }
                return len;
            }
        };
    }

    public static Input from(final ReadableByteChannel in) {
        return new Input(){

            @Override
            public int fillBuffer() throws IOException {
                BufferUtil.compact((ByteBuffer)this._buffer);
                int pos = BufferUtil.flipToFill((ByteBuffer)this._buffer);
                int len = in.read(this._buffer);
                if (len < 0) {
                    this._eof = true;
                }
                BufferUtil.flipToFlush((ByteBuffer)this._buffer, (int)pos);
                return len;
            }
        };
    }

    public static Response parseResponse(Input in) throws IOException {
        Response r;
        HttpParser parser = in.takeHttpParser();
        if (parser == null) {
            r = new Response();
            parser = new HttpParser((HttpParser.ResponseHandler)r);
        } else {
            r = (Response)parser.getHandler();
        }
        ByteBuffer buffer = in.getBuffer();
        int len = 0;
        while (!(len < 0 || BufferUtil.hasContent((ByteBuffer)buffer) && parser.parseNext(buffer) || in.fillBuffer() <= 0)) {
        }
        if (r.isComplete()) {
            return r;
        }
        in.setHttpParser(parser);
        return null;
    }

    public static class Response
    extends Message
    implements HttpParser.ResponseHandler {
        private int _status;
        private String _reason;

        public boolean startResponse(HttpVersion version, int status, String reason) {
            this._version = version;
            this._status = status;
            this._reason = reason;
            return false;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        public MetaData.Response getInfo() {
            return new MetaData.Response(this._version, this._status, this._reason, (HttpFields)this, this._content == null ? -1L : (long)this._content.size());
        }

        public String toString() {
            return String.format("%s %s %s\n%s\n", this._version, this._status, this._reason, super.toString());
        }
    }

    public static class Request
    extends Message
    implements HttpParser.RequestHandler {
        private String _method;
        private String _uri;

        public boolean startRequest(String method, String uri, HttpVersion version) {
            this._method = method;
            this._uri = uri.toString();
            this._version = version;
            return false;
        }

        public String getMethod() {
            return this._method;
        }

        public String getUri() {
            return this._uri;
        }

        public void setMethod(String method) {
            this._method = method;
        }

        public void setURI(String uri) {
            this._uri = uri;
        }

        public MetaData.Request getInfo() {
            return new MetaData.Request(this._method, new HttpURI(this._uri), this._version, (HttpFields)this, this._content == null ? 0L : (long)this._content.size());
        }

        public String toString() {
            return String.format("%s %s %s\n%s\n", this._method, this._uri, this._version, super.toString());
        }

        public void setHeader(String name, String value) {
            this.put(name, value);
        }
    }

    public static abstract class Message
    extends HttpFields
    implements HttpParser.HttpHandler {
        boolean _complete = false;
        ByteArrayOutputStream _content;
        HttpVersion _version = HttpVersion.HTTP_1_0;

        public boolean isComplete() {
            return this._complete;
        }

        public HttpVersion getVersion() {
            return this._version;
        }

        public void setVersion(String version) {
            this.setVersion((HttpVersion)HttpVersion.CACHE.get(version));
        }

        public void setVersion(HttpVersion version) {
            this._version = version;
        }

        public void setContent(byte[] bytes) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(String content) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(StringUtil.getBytes((String)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(ByteBuffer content) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(BufferUtil.toArray((ByteBuffer)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] getContentBytes() {
            if (this._content == null) {
                return null;
            }
            return this._content.toByteArray();
        }

        public String getContent() {
            if (this._content == null) {
                return null;
            }
            byte[] bytes = this._content.toByteArray();
            String content_type = this.get(HttpHeader.CONTENT_TYPE);
            String encoding = MimeTypes.getCharsetFromContentType((String)content_type);
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
            return new String(bytes, charset);
        }

        public void parsedHeader(HttpField field) {
            this.put(field.getName(), field.getValue());
        }

        public boolean messageComplete() {
            this._complete = true;
            return true;
        }

        public boolean headerComplete() {
            this._content = new ByteArrayOutputStream();
            return false;
        }

        public void earlyEOF() {
        }

        public boolean content(ByteBuffer ref) {
            try {
                this._content.write(BufferUtil.toArray((ByteBuffer)ref));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        public void badMessage(int status, String reason) {
            throw new RuntimeException(reason);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteBuffer generate() {
            try {
                HttpGenerator generator = new HttpGenerator();
                MetaData info = this.getInfo();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteBuffer header = null;
                ByteBuffer chunk = null;
                ByteBuffer content = this._content == null ? null : ByteBuffer.wrap(this._content.toByteArray());
                block9: while (!generator.isEnd()) {
                    HttpGenerator.Result result = info instanceof MetaData.Request ? generator.generateRequest((MetaData.Request)info, header, chunk, content, true) : generator.generateResponse((MetaData.Response)info, false, header, chunk, content, true);
                    switch (result) {
                        case NEED_HEADER: {
                            header = BufferUtil.allocate((int)8192);
                            continue block9;
                        }
                        case NEED_CHUNK: {
                            chunk = BufferUtil.allocate((int)12);
                            continue block9;
                        }
                        case NEED_INFO: {
                            throw new IllegalStateException();
                        }
                        case FLUSH: {
                            if (BufferUtil.hasContent(header)) {
                                out.write(BufferUtil.toArray((ByteBuffer)header));
                                BufferUtil.clear((ByteBuffer)header);
                            }
                            if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                                out.write(BufferUtil.toArray((ByteBuffer)chunk));
                                BufferUtil.clear((ByteBuffer)chunk);
                            }
                            if (!BufferUtil.hasContent((ByteBuffer)content)) break;
                            out.write(BufferUtil.toArray((ByteBuffer)content));
                            BufferUtil.clear((ByteBuffer)content);
                            break;
                        }
                        case SHUTDOWN_OUT: {
                            return ByteBuffer.wrap(out.toByteArray());
                        }
                    }
                }
                return ByteBuffer.wrap(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public abstract MetaData getInfo();

        public int getHeaderCacheSize() {
            return 0;
        }
    }

    public static abstract class Input {
        boolean _eof = false;
        HttpParser _parser;
        ByteBuffer _buffer = BufferUtil.allocate((int)8192);

        public ByteBuffer getBuffer() {
            return this._buffer;
        }

        public void setHttpParser(HttpParser parser) {
            this._parser = parser;
        }

        public HttpParser getHttpParser() {
            return this._parser;
        }

        public HttpParser takeHttpParser() {
            HttpParser p = this._parser;
            this._parser = null;
            return p;
        }

        public boolean isEOF() {
            return BufferUtil.isEmpty((ByteBuffer)this._buffer) && this._eof;
        }

        public abstract int fillBuffer() throws IOException;
    }
}

