/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.QuotedCSV;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class QuotedCSVTest {
    @Test
    public void testOWS() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue("  value 0.5  ;  p = v  ;  q =0.5  ,  value 1.0 ");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 0.5;p=v;q=0.5", "value 1.0"}));
    }

    @Test
    public void testEmpty() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue(",aaaa,  , bbbb ,,cccc,");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"aaaa", "bbbb", "cccc"}));
    }

    @Test
    public void testQuoted() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue("A;p=\"v\",B,\"C, D\"");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"A;p=\"v\"", "B", "\"C, D\""}));
    }

    @Test
    public void testOpenQuote() {
        QuotedCSV values = new QuotedCSV(new String[0]);
        values.addValue("value;p=\"v");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value;p=\"v"}));
    }

    @Test
    public void testQuotedNoQuotes() {
        QuotedCSV values = new QuotedCSV(false, new String[0]);
        values.addValue("A;p=\"v\",B,\"C, D\"");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"A;p=v", "B", "C, D"}));
    }

    @Test
    public void testOpenQuoteNoQuotes() {
        QuotedCSV values = new QuotedCSV(false, new String[0]);
        values.addValue("value;p=\"v");
        Assert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value;p=v"}));
    }

    @Test
    public void testUnQuote() {
        Assert.assertThat((Object)QuotedCSV.unquote((String)""), (Matcher)Matchers.is((Object)""));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\"\""), (Matcher)Matchers.is((Object)""));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"foo"), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\"foo\""), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"f\"o\"o"), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\"\\\"foo\""), (Matcher)Matchers.is((Object)"\"foo"));
        Assert.assertThat((Object)QuotedCSV.unquote((String)"\\foo"), (Matcher)Matchers.is((Object)"\\foo"));
    }
}

