/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HttpFieldTest {
    @Test
    public void testContainsSimple() throws Exception {
        HttpField field = new HttpField("name", "somevalue");
        Assert.assertTrue((boolean)field.contains("somevalue"));
        Assert.assertFalse((boolean)field.contains("other"));
        Assert.assertFalse((boolean)field.contains("some"));
        Assert.assertFalse((boolean)field.contains("value"));
        Assert.assertFalse((boolean)field.contains("v"));
        Assert.assertFalse((boolean)field.contains(""));
        Assert.assertFalse((boolean)field.contains(null));
    }

    @Test
    public void testCaseInsensitiveHashcode_KnownField() throws Exception {
        HttpField fieldFoo1 = new HttpField("Cookie", "foo");
        HttpField fieldFoo2 = new HttpField("cookie", "foo");
        Assert.assertThat((String)"Field hashcodes are case insensitive", (Object)fieldFoo1.hashCode(), (Matcher)CoreMatchers.is((Object)fieldFoo2.hashCode()));
    }

    @Test
    public void testCaseInsensitiveHashcode_UnknownField() throws Exception {
        HttpField fieldFoo1 = new HttpField("X-Foo", "bar");
        HttpField fieldFoo2 = new HttpField("x-foo", "bar");
        Assert.assertThat((String)"Field hashcodes are case insensitive", (Object)fieldFoo1.hashCode(), (Matcher)CoreMatchers.is((Object)fieldFoo2.hashCode()));
    }

    @Test
    public void testContainsList() throws Exception {
        HttpField field = new HttpField("name", ",aaa,bbb,ccc, ddd , e e, \"\\\"f,f\\\"\", ");
        Assert.assertTrue((boolean)field.contains("aaa"));
        Assert.assertTrue((boolean)field.contains("bbb"));
        Assert.assertTrue((boolean)field.contains("ccc"));
        Assert.assertTrue((boolean)field.contains("ddd"));
        Assert.assertTrue((boolean)field.contains("e e"));
        Assert.assertTrue((boolean)field.contains("\"f,f\""));
        Assert.assertFalse((boolean)field.contains(""));
        Assert.assertFalse((boolean)field.contains("aa"));
        Assert.assertFalse((boolean)field.contains("bb"));
        Assert.assertFalse((boolean)field.contains("cc"));
        Assert.assertFalse((boolean)field.contains(null));
    }

    @Test
    public void testQualityContainsList() throws Exception {
        HttpField field = new HttpField("name", "yes");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", ",yes,");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,yes,other");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  yes  ,other");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  y s  ,other");
        Assert.assertTrue((boolean)field.contains("y s"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  \"yes\"  ,other");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  \"\\\"yes\\\"\"  ,other");
        Assert.assertTrue((boolean)field.contains("\"yes\""));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", ";no,yes,;no");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "no;q=0,yes;q=1,no; q = 0");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "no;q=0.0000,yes;q=0.0001,no; q = 0.00000");
        Assert.assertTrue((boolean)field.contains("yes"));
        Assert.assertFalse((boolean)field.contains("no"));
    }

    @Test
    public void testValues() {
        String[] values = new HttpField("name", "value").getValues();
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"value", (Object)values[0]);
        values = new HttpField("name", "a,b,c").getValues();
        Assert.assertEquals((long)3L, (long)values.length);
        Assert.assertEquals((Object)"a", (Object)values[0]);
        Assert.assertEquals((Object)"b", (Object)values[1]);
        Assert.assertEquals((Object)"c", (Object)values[2]);
        values = new HttpField("name", "a,\"x,y,z\",c").getValues();
        Assert.assertEquals((long)3L, (long)values.length);
        Assert.assertEquals((Object)"a", (Object)values[0]);
        Assert.assertEquals((Object)"x,y,z", (Object)values[1]);
        Assert.assertEquals((Object)"c", (Object)values[2]);
        values = new HttpField("name", "a,\"x,\\\"p,q\\\",z\",c").getValues();
        Assert.assertEquals((long)3L, (long)values.length);
        Assert.assertEquals((Object)"a", (Object)values[0]);
        Assert.assertEquals((Object)"x,\"p,q\",z", (Object)values[1]);
        Assert.assertEquals((Object)"c", (Object)values[2]);
    }

    @Test
    public void testCachedField() {
        PreEncodedHttpField field = new PreEncodedHttpField(HttpHeader.ACCEPT, "something");
        ByteBuffer buf = BufferUtil.allocate((int)256);
        BufferUtil.clearToFill((ByteBuffer)buf);
        field.putTo(buf, HttpVersion.HTTP_1_0);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        String s = BufferUtil.toString((ByteBuffer)buf);
        Assert.assertEquals((Object)"Accept: something\r\n", (Object)s);
    }
}

