/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpGeneratorServerHTTPTest {
    @Parameterized.Parameter(value=0)
    public Run run;
    private String _content;
    private String _reason;
    public static final String CONTENT = "The quick brown fox jumped over the lazy dog.\nNow is the time for all good men to come to the aid of the party\nThe moon is blue to a fish in love.\n";

    @Test
    public void testHTTP() throws Exception {
        Handler handler = new Handler();
        HttpGenerator gen = new HttpGenerator();
        String t = this.run.toString();
        this.run.result.getHttpFields().clear();
        String response = this.run.result.build(this.run.httpVersion, gen, "OK\r\nTest", this.run.connection.val, null, this.run.chunks);
        if (this.run.httpVersion == 9) {
            Assert.assertFalse((String)t, (boolean)gen.isPersistent());
            if (this.run.result._body != null) {
                Assert.assertEquals((String)t, (Object)this.run.result._body, (Object)response);
            }
            return;
        }
        HttpParser parser = new HttpParser((HttpParser.ResponseHandler)handler);
        parser.setHeadResponse(this.run.result._head);
        parser.parseNext(BufferUtil.toBuffer((String)response));
        if (this.run.result._body != null) {
            Assert.assertEquals((String)t, (Object)this.run.result._body, (Object)this._content);
        }
        if (this.run.httpVersion == 10) {
            Assert.assertTrue((String)t, (gen.isPersistent() || this.run.result._contentLength >= 0 || EnumSet.of(ConnectionType.CLOSE, ConnectionType.KEEP_ALIVE, ConnectionType.NONE).contains((Object)this.run.connection) ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)t, (gen.isPersistent() || EnumSet.of(ConnectionType.CLOSE, ConnectionType.TE_CLOSE).contains((Object)this.run.connection) ? 1 : 0) != 0);
        }
        if (this.run.httpVersion > 9) {
            Assert.assertEquals((Object)"OK??Test", (Object)this._reason);
        }
        if (this._content == null) {
            Assert.assertTrue((String)t, (this.run.result._body == null ? 1 : 0) != 0);
        } else {
            Assert.assertThat((String)t, (Object)this.run.result._contentLength, (Matcher)Matchers.either((Matcher)Matchers.equalTo((Object)this._content.length())).or(Matchers.equalTo((Object)-1)));
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Run[]> data() {
        Result[] results = new Result[]{new Result(200, null, -1, null, false), new Result(200, null, -1, CONTENT, false), new Result(200, null, CONTENT.length(), null, true), new Result(200, null, CONTENT.length(), CONTENT, false), new Result(200, "text/html", -1, null, true), new Result(200, "text/html", -1, CONTENT, false), new Result(200, "text/html", CONTENT.length(), null, true), new Result(200, "text/html", CONTENT.length(), CONTENT, false)};
        ArrayList<Run[]> data = new ArrayList<Run[]>();
        for (Result result : results) {
            for (int v = 9; v <= 11; ++v) {
                for (int chunks = 1; chunks <= 6; ++chunks) {
                    for (ConnectionType connection : ConnectionType.values()) {
                        if (!connection.isSupportedByHttp(v)) continue;
                        data.add(Run.as(result, v, chunks, connection));
                    }
                }
            }
        }
        return data;
    }

    private static enum ConnectionType {
        NONE(null, 9, 10, 11),
        KEEP_ALIVE("keep-alive", 9, 10, 11),
        CLOSE("close", 9, 10, 11),
        TE_CLOSE("TE, close", 11);

        private String val;
        private int[] supportedHttpVersions;

        private ConnectionType(String val, int ... supportedHttpVersions) {
            this.val = val;
            this.supportedHttpVersions = supportedHttpVersions;
        }

        public boolean isSupportedByHttp(int version) {
            for (int supported : this.supportedHttpVersions) {
                if (supported != version) continue;
                return true;
            }
            return false;
        }
    }

    private static class Run {
        private Result result;
        private ConnectionType connection;
        private int httpVersion;
        private int chunks;

        private Run() {
        }

        public static Run[] as(Result result, int ver, int chunks, ConnectionType connection) {
            Run run = new Run();
            run.result = result;
            run.httpVersion = ver;
            run.chunks = chunks;
            run.connection = connection;
            return new Run[]{run};
        }

        public String toString() {
            return String.format("result=%s,version=%d,chunks=%d,connection=%s", this.result, this.httpVersion, this.chunks, this.connection.name());
        }
    }

    private class Handler
    implements HttpParser.ResponseHandler {
        private Handler() {
        }

        public boolean content(ByteBuffer ref) {
            if (HttpGeneratorServerHTTPTest.this._content == null) {
                HttpGeneratorServerHTTPTest.this._content = "";
            }
            HttpGeneratorServerHTTPTest.this._content = HttpGeneratorServerHTTPTest.this._content + BufferUtil.toString((ByteBuffer)ref);
            ref.position(ref.limit());
            return false;
        }

        public void earlyEOF() {
        }

        public boolean headerComplete() {
            HttpGeneratorServerHTTPTest.this._content = null;
            return false;
        }

        public boolean messageComplete() {
            return true;
        }

        public void parsedHeader(HttpField field) {
        }

        public boolean startResponse(HttpVersion version, int status, String reason) {
            HttpGeneratorServerHTTPTest.this._reason = reason;
            return false;
        }

        public void badMessage(int status, String reason) {
            throw new IllegalStateException(reason);
        }

        public int getHeaderCacheSize() {
            return 256;
        }
    }

    private static class Result {
        private HttpFields _fields = new HttpFields();
        private final String _body;
        private final int _code;
        private String _connection;
        private int _contentLength;
        private String _contentType;
        private final boolean _head;
        private String _other;
        private String _te;

        private Result(int code, String contentType, int contentLength, String content, boolean head) {
            this._code = code;
            this._contentType = contentType;
            this._contentLength = contentLength;
            this._other = "value";
            this._body = content;
            this._head = head;
        }

        /*
         * Enabled aggressive block sorting
         */
        private String build(int version, HttpGenerator gen, String reason, String connection, String te, int nchunks) throws Exception {
            String response = "";
            this._connection = connection;
            this._te = te;
            if (this._contentType != null) {
                this._fields.put("Content-Type", this._contentType);
            }
            if (this._contentLength >= 0) {
                this._fields.put("Content-Length", "" + this._contentLength);
            }
            if (this._connection != null) {
                this._fields.put("Connection", this._connection);
            }
            if (this._te != null) {
                this._fields.put("Transfer-Encoding", this._te);
            }
            if (this._other != null) {
                this._fields.put("Other", this._other);
            }
            ByteBuffer source = this._body == null ? null : BufferUtil.toBuffer((String)this._body);
            ByteBuffer[] chunks = new ByteBuffer[nchunks];
            ByteBuffer content = null;
            int c = 0;
            if (source != null) {
                for (int i = 0; i < nchunks; ++i) {
                    chunks[i] = source.duplicate();
                    chunks[i].position(i * (source.capacity() / nchunks));
                    if (i <= 0) continue;
                    chunks[i - 1].limit(chunks[i].position());
                }
                content = chunks[c++];
            }
            ByteBuffer header = null;
            ByteBuffer chunk = null;
            MetaData.Response info = null;
            block10: while (true) {
                if (source != null && content != null && content.remaining() == 0 && c < nchunks) {
                    content = chunks[c++];
                }
                boolean last = !BufferUtil.hasContent((ByteBuffer)content);
                HttpGenerator.Result result = gen.generateResponse(info, this._head, header, chunk, content, last);
                switch (result) {
                    case NEED_INFO: {
                        info = new MetaData.Response(HttpVersion.fromVersion((int)version), this._code, reason, this._fields, (long)this._contentLength);
                        continue block10;
                    }
                    case NEED_HEADER: {
                        header = BufferUtil.allocate((int)2048);
                        continue block10;
                    }
                    case NEED_CHUNK: {
                        chunk = BufferUtil.allocate((int)12);
                        continue block10;
                    }
                    case FLUSH: {
                        if (BufferUtil.hasContent(header)) {
                            response = response + BufferUtil.toString((ByteBuffer)header);
                            header.position(header.limit());
                        }
                        if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                            response = response + BufferUtil.toString((ByteBuffer)chunk);
                            chunk.position(chunk.limit());
                        }
                        if (!BufferUtil.hasContent((ByteBuffer)content)) break;
                        response = response + BufferUtil.toString((ByteBuffer)content);
                        content.position(content.limit());
                        break;
                    }
                    case CONTINUE: {
                        continue block10;
                    }
                    case SHUTDOWN_OUT: {
                        break;
                    }
                    case DONE: {
                        return response;
                    }
                }
            }
        }

        public String toString() {
            return "[" + this._code + "," + this._contentType + "," + this._contentLength + "," + (this._body == null ? "null" : "content") + "]";
        }

        public HttpFields getHttpFields() {
            return this._fields;
        }
    }
}

