/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HttpGeneratorClientTest {
    public static final String[] connect = new String[]{null, "keep-alive", "close"};

    @Test
    public void testGETRequestNoContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)2048);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("GET", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateRequest((MetaData.Request)info, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gen.getContentPrepared());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"GET /index.html HTTP/1.1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
    }

    @Test
    public void testEmptyHeaders() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)2048);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("GET", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("Null", null);
        info.getFields().add("Empty", "");
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateRequest((MetaData.Request)info, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gen.getContentPrepared());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"GET /index.html HTTP/1.1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Empty:"));
        Assert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Null:")));
    }

    @Test
    public void testPOSTRequestNoContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)2048);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateRequest((MetaData.Request)info, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gen.getContentPrepared());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 0"));
    }

    @Test
    public void testRequestWithContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World. The quick brown fox jumped over the lazy dog.");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, content0, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        result = gen.generateRequest((MetaData.Request)info, null, null, content0, true);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, content0, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Host: something"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 58"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Hello World. The quick brown fox jumped over the lazy dog."));
        Assert.assertEquals((long)58L, (long)gen.getContentPrepared());
    }

    @Test
    public void testRequestWithChunkedContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World. ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog.");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html");
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        result = gen.generateRequest((MetaData.Request)info, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assert.assertTrue((boolean)gen.isChunking());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateRequest(null, header, null, content1, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_CHUNK, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        result = gen.generateRequest(null, null, chunk, content1, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assert.assertTrue((boolean)gen.isChunking());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assert.assertTrue((boolean)gen.isChunking());
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Host: something"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\nD\r\nHello World. \r\n"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n2D\r\nThe quick brown fox jumped over the lazy dog.\r\n"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n0\r\n\r\n"));
        Assert.assertEquals((long)58L, (long)gen.getContentPrepared());
    }

    @Test
    public void testRequestWithKnownContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World. ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog.");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateRequest(null, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        Info info = new Info("POST", "/index.html", 58);
        info.getFields().add("Host", "something");
        info.getFields().add("User-Agent", "test");
        result = gen.generateRequest((MetaData.Request)info, null, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateRequest((MetaData.Request)info, header, null, content0, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateRequest(null, null, null, content1, false);
        Assert.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        Assert.assertTrue((!gen.isChunking() ? 1 : 0) != 0);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assert.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assert.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"POST /index.html HTTP/1.1"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Host: something"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 58"));
        Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nHello World. The quick brown fox jumped over the lazy dog."));
        Assert.assertEquals((long)58L, (long)gen.getContentPrepared());
    }

    class Info
    extends MetaData.Request {
        Info(String method, String uri) {
            super(method, new HttpURI(uri), HttpVersion.HTTP_1_1, new HttpFields(), -1L);
        }

        public Info(String method, String uri, int contentLength) {
            super(method, new HttpURI(uri), HttpVersion.HTTP_1_1, new HttpFields(), (long)contentLength);
        }
    }
}

