/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MultiPartFormInputStreamTest {
    private static final String FILENAME = "stuff.txt";
    protected String _contentType = "multipart/form-data, boundary=AaB03x";
    protected String _multi = MultiPartFormInputStreamTest.createMultipartRequestString("stuff.txt");
    protected String _dirname = System.getProperty("java.io.tmpdir") + File.separator + "myfiles-" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    protected File _tmpDir = new File(this._dirname);

    public MultiPartFormInputStreamTest() {
        this._tmpDir.deleteOnExit();
    }

    @Test
    public void testBadMultiPartRequest() throws Exception {
        String boundary = "X0Y0";
        String str = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"fileup\"; filename=\"test.upload\"\r\nContent-Type: application/octet-stream\r\n\r\nHow now brown cow.\r\n--" + boundary + "-\r\nContent-Disposition: form-data; name=\"fileup\"; filename=\"test.upload\"\r\n\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), "multipart/form-data, boundary=" + boundary, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"Incomplete Multipart");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Incomplete"));
        }
    }

    @Test
    public void testFinalBoundaryOnly() throws Exception {
        String delimiter = "\r\n";
        String boundary = "MockMultiPartTestBoundary";
        String str = delimiter + "Hello world" + delimiter + delimiter + "--" + "MockMultiPartTestBoundary" + "--" + delimiter;
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), "multipart/form-data, boundary=MockMultiPartTestBoundary", config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Assert.assertTrue((boolean)mpis.getParts().isEmpty());
    }

    @Test
    public void testEmpty() throws Exception {
        String delimiter = "\r\n";
        String boundary = "MockMultiPartTestBoundary";
        String str = delimiter + "--" + "MockMultiPartTestBoundary" + "--" + delimiter;
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), "multipart/form-data, boundary=MockMultiPartTestBoundary", config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Assert.assertTrue((boolean)mpis.getParts().isEmpty());
    }

    @Test
    public void testNoBoundaryRequest() throws Exception {
        String str = "--\r\nContent-Disposition: form-data; name=\"fileName\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nabc\r\n--\r\nContent-Disposition: form-data; name=\"desc\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\n123\r\n--\r\nContent-Disposition: form-data; name=\"title\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nttt\r\n--\r\nContent-Disposition: form-data; name=\"datafile5239138112980980385.txt\"; filename=\"datafile5239138112980980385.txt\"\r\nContent-Type: application/octet-stream; charset=ISO-8859-1\r\nContent-Transfer-Encoding: binary\r\n\r\n000\r\n----\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), "multipart/form-data", config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)4));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Part fileName = mpis.getPart("fileName");
        Assert.assertThat((Object)fileName, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fileName.getSize(), (Matcher)Matchers.is((Object)3L));
        IO.copy((InputStream)fileName.getInputStream(), (OutputStream)baos);
        Assert.assertThat((Object)baos.toString("US-ASCII"), (Matcher)Matchers.is((Object)"abc"));
        baos = new ByteArrayOutputStream();
        Part desc = mpis.getPart("desc");
        Assert.assertThat((Object)desc, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)desc.getSize(), (Matcher)Matchers.is((Object)3L));
        IO.copy((InputStream)desc.getInputStream(), (OutputStream)baos);
        Assert.assertThat((Object)baos.toString("US-ASCII"), (Matcher)Matchers.is((Object)"123"));
        baos = new ByteArrayOutputStream();
        Part title = mpis.getPart("title");
        Assert.assertThat((Object)title, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)title.getSize(), (Matcher)Matchers.is((Object)3L));
        IO.copy((InputStream)title.getInputStream(), (OutputStream)baos);
        Assert.assertThat((Object)baos.toString("US-ASCII"), (Matcher)Matchers.is((Object)"ttt"));
    }

    @Test
    public void testNonMultiPartRequest() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(this._multi.getBytes()), "Content-type: text/plain", config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Assert.assertTrue((boolean)mpis.getParts().isEmpty());
    }

    @Test
    public void testNoBody() {
        String body = "";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(body.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"Missing initial multi part boundary");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Missing initial multi part boundary"));
        }
    }

    @Test
    public void testBodyAlreadyConsumed() throws Exception {
        ServletInputStream is = new ServletInputStream(){

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return 0;
            }
        };
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)is, this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertEquals((long)0L, (long)parts.size());
    }

    @Test
    public void testWhitespaceBodyWithCRLF() {
        String whitespace = "              \n\n\n\r\n\r\n\r\n\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(whitespace.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"Missing initial multi part boundary");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Missing initial multi part boundary"));
        }
    }

    @Test
    public void testWhitespaceBody() {
        String whitespace = " ";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(whitespace.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"Multipart missing body");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing initial"));
        }
    }

    @Test
    public void testLeadingWhitespaceBodyWithCRLF() throws Exception {
        String body = "              \n\n\n\r\n\r\n\r\n\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"foo.txt\"\r\nContent-Type: text/plain\r\n\r\naaaabbbbb\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(body.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
        Part field1 = mpis.getPart("field1");
        Assert.assertThat((Object)field1, (Matcher)Matchers.notNullValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy((InputStream)field1.getInputStream(), (OutputStream)baos);
        Assert.assertThat((Object)baos.toString("US-ASCII"), (Matcher)Matchers.is((Object)"Joe Blow"));
        Part stuff = mpis.getPart("stuff");
        Assert.assertThat((Object)stuff, (Matcher)Matchers.notNullValue());
        baos = new ByteArrayOutputStream();
        IO.copy((InputStream)stuff.getInputStream(), (OutputStream)baos);
        Assert.assertTrue((boolean)baos.toString("US-ASCII").contains("aaaa"));
    }

    @Test
    public void testLeadingWhitespaceBodyWithoutCRLF() throws Exception {
        String body = "            --AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"foo.txt\"\r\nContent-Type: text/plain\r\n\r\naaaabbbbb\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(body.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)1));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Part stuff = mpis.getPart("stuff");
        Assert.assertThat((Object)stuff, (Matcher)Matchers.notNullValue());
        IO.copy((InputStream)stuff.getInputStream(), (OutputStream)baos);
        Assert.assertTrue((boolean)baos.toString("US-ASCII").contains("bbbbb"));
    }

    @Test
    public void testNoLimits() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(this._multi.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertFalse((boolean)parts.isEmpty());
    }

    @Test
    public void testRequestTooBig() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 60L, 100L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(this._multi.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"Request should have exceeded maxRequestSize");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Request exceeds maxRequestSize"));
        }
    }

    @Test
    public void testRequestTooBigThrowsErrorOnGetParts() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 60L, 100L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(this._multi.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"Request should have exceeded maxRequestSize");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Request exceeds maxRequestSize"));
        }
        try {
            mpis.getParts();
            Assert.fail((String)"Request should have exceeded maxRequestSize");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Request exceeds maxRequestSize"));
        }
    }

    @Test
    public void testFileTooBig() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 40L, 1024L, 30);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(this._multi.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"stuff.txt should have been larger than maxFileSize");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Multipart Mime part"));
        }
    }

    @Test
    public void testFileTooBigThrowsErrorOnGetParts() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 40L, 1024L, 30);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(this._multi.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"stuff.txt should have been larger than maxFileSize");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Multipart Mime part"));
        }
        try {
            mpis.getParts();
            Assert.fail((String)"stuff.txt should have been larger than maxFileSize");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Multipart Mime part"));
        }
    }

    @Test
    public void testPartFileNotDeleted() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(MultiPartFormInputStreamTest.createMultipartRequestString("tptfd").getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        mpis.getParts();
        MultiPartFormInputStream.MultiPart part = (MultiPartFormInputStream.MultiPart)mpis.getPart("stuff");
        File stuff = part.getFile();
        Assert.assertThat((Object)stuff, (Matcher)Matchers.notNullValue());
        part.write("tptfd.txt");
        File tptfd = new File(this._dirname + File.separator + "tptfd.txt");
        Assert.assertThat((Object)tptfd.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)stuff.exists(), (Matcher)Matchers.is((Object)false));
        part.cleanUp();
        Assert.assertThat((Object)tptfd.exists(), (Matcher)Matchers.is((Object)true));
        tptfd.deleteOnExit();
    }

    @Test
    public void testPartTmpFileDeletion() throws Exception {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(MultiPartFormInputStreamTest.createMultipartRequestString("tptfd").getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        mpis.getParts();
        MultiPartFormInputStream.MultiPart part = (MultiPartFormInputStream.MultiPart)mpis.getPart("stuff");
        File stuff = part.getFile();
        Assert.assertThat((Object)stuff, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)stuff.exists(), (Matcher)Matchers.is((Object)true));
        part.cleanUp();
        Assert.assertThat((Object)stuff.exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testLFOnlyRequest() throws Exception {
        String str = "--AaB03x\ncontent-disposition: form-data; name=\"field1\"\n\nJoe Blow\r\n--AaB03x\ncontent-disposition: form-data; name=\"field2\"\n\nOther\r\n--AaB03x--\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
        Part p1 = mpis.getPart("field1");
        Assert.assertThat((Object)p1, (Matcher)Matchers.notNullValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy((InputStream)p1.getInputStream(), (OutputStream)baos);
        Assert.assertThat((Object)baos.toString("UTF-8"), (Matcher)Matchers.is((Object)"Joe Blow"));
        Part p2 = mpis.getPart("field2");
        Assert.assertThat((Object)p2, (Matcher)Matchers.notNullValue());
        baos = new ByteArrayOutputStream();
        IO.copy((InputStream)p2.getInputStream(), (OutputStream)baos);
        Assert.assertThat((Object)baos.toString("UTF-8"), (Matcher)Matchers.is((Object)"Other"));
    }

    @Test
    public void testCROnlyRequest() {
        String str = "--AaB03x\rcontent-disposition: form-data; name=\"field1\"\r\rJoe Blow\r--AaB03x\rcontent-disposition: form-data; name=\"field2\"\r\rOther\r--AaB03x--\r";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            Collection parts = mpis.getParts();
            Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
            Part p1 = mpis.getPart("field1");
            Assert.assertThat((Object)p1, (Matcher)Matchers.notNullValue());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IO.copy((InputStream)p1.getInputStream(), (OutputStream)baos);
            Assert.assertThat((Object)baos.toString("UTF-8"), (Matcher)Matchers.is((Object)"Joe Blow"));
            Part p2 = mpis.getPart("field2");
            Assert.assertThat((Object)p2, (Matcher)Matchers.notNullValue());
            baos = new ByteArrayOutputStream();
            IO.copy((InputStream)p2.getInputStream(), (OutputStream)baos);
            Assert.assertThat((Object)baos.toString("UTF-8"), (Matcher)Matchers.is((Object)"Other"));
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Bad EOL"));
        }
    }

    @Test
    public void testCRandLFMixRequest() {
        String str = "--AaB03x\rcontent-disposition: form-data; name=\"field1\"\r\r\nJoe Blow\n\r--AaB03x\rcontent-disposition: form-data; name=\"field2\"\r\rOther\r--AaB03x--\r";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            Collection parts = mpis.getParts();
            Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
            Part p1 = mpis.getPart("field1");
            Assert.assertThat((Object)p1, (Matcher)Matchers.notNullValue());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IO.copy((InputStream)p1.getInputStream(), (OutputStream)baos);
            Assert.assertThat((Object)baos.toString("UTF-8"), (Matcher)Matchers.is((Object)"\nJoe Blow\n"));
            Part p2 = mpis.getPart("field2");
            Assert.assertThat((Object)p2, (Matcher)Matchers.notNullValue());
            baos = new ByteArrayOutputStream();
            IO.copy((InputStream)p2.getInputStream(), (OutputStream)baos);
            Assert.assertThat((Object)baos.toString("UTF-8"), (Matcher)Matchers.is((Object)"Other"));
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Bad EOL"));
        }
    }

    @Test
    public void testBufferOverflowNoCRLF() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write("--AaB03x\r\n".getBytes());
        for (int i = 0; i < 3000; ++i) {
            baos.write(97);
        }
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        try {
            mpis.getParts();
            Assert.fail((String)"Header Line Exceeded Max Length");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Header Line Exceeded Max Length"));
        }
    }

    @Test
    public void testCharsetEncoding() throws Exception {
        String contentType = "multipart/form-data; boundary=TheBoundary; charset=ISO-8859-1";
        String str = "--TheBoundary\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\n\nJoe Blow\n\r\n--TheBoundary--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testBadlyEncodedFilename() throws Exception {
        String contents = "--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"Taken on Aug 22 \\ 2012.jpg\"\r\nContent-Type: text/plain\r\n\r\nstuffaaa\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(contents.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Part)parts.iterator().next()).getSubmittedFileName(), (Matcher)Matchers.is((Object)"Taken on Aug 22 \\ 2012.jpg"));
    }

    @Test
    public void testBadlyEncodedMSFilename() throws Exception {
        String contents = "--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"c:\\this\\really\\is\\some\\path\\to\\a\\file.txt\"\r\nContent-Type: text/plain\r\n\r\nstuffaaa\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(contents.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Part)parts.iterator().next()).getSubmittedFileName(), (Matcher)Matchers.is((Object)"c:\\this\\really\\is\\some\\path\\to\\a\\file.txt"));
    }

    @Test
    public void testCorrectlyEncodedMSFilename() throws Exception {
        String contents = "--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"c:\\\\this\\\\really\\\\is\\\\some\\\\path\\\\to\\\\a\\\\file.txt\"\r\nContent-Type: text/plain\r\n\r\nstuffaaa\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(contents.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Part)parts.iterator().next()).getSubmittedFileName(), (Matcher)Matchers.is((Object)"c:\\this\\really\\is\\some\\path\\to\\a\\file.txt"));
    }

    @Test
    public void testMultiWithSpaceInFilename() throws Exception {
        this.testMulti("stuff with spaces.txt");
    }

    @Test
    public void testWriteFilesIfContentDispositionFilename() throws Exception {
        String s = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"; filename=\"frooble.txt\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"\r\nContent-Type: text/plain\r\n\r\nsssaaa\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(s.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        mpis.setWriteFilesWithFilenames(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
        Part field1 = mpis.getPart("field1");
        File f = ((MultiPartFormInputStream.MultiPart)field1).getFile();
        Assert.assertThat((Object)f, (Matcher)Matchers.notNullValue());
        Part stuff = mpis.getPart("stuff");
        f = ((MultiPartFormInputStream.MultiPart)stuff).getFile();
        Assert.assertThat((Object)f, (Matcher)Matchers.nullValue());
    }

    private void testMulti(String filename) throws IOException {
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(MultiPartFormInputStreamTest.createMultipartRequestString(filename).getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
        Part field1 = mpis.getPart("field1");
        Assert.assertThat((Object)field1, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)field1.getName(), (Matcher)Matchers.is((Object)"field1"));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InputStream is = field1.getInputStream();){
            IO.copy((InputStream)is, (OutputStream)os);
        }
        Assert.assertEquals((Object)"Joe Blow", (Object)new String(os.toByteArray()));
        Assert.assertEquals((long)8L, (long)field1.getSize());
        Assert.assertNotNull((Object)((MultiPartFormInputStream.MultiPart)field1).getBytes());
        field1.write("field1.txt");
        Assert.assertNull((Object)((MultiPartFormInputStream.MultiPart)field1).getBytes());
        File f = new File(this._dirname + File.separator + "field1.txt");
        Assert.assertTrue((boolean)f.exists());
        field1.write("another_field1.txt");
        File f2 = new File(this._dirname + File.separator + "another_field1.txt");
        Assert.assertTrue((boolean)f2.exists());
        Assert.assertFalse((boolean)f.exists());
        field1.delete();
        Assert.assertFalse((boolean)f.exists());
        Assert.assertFalse((boolean)f2.exists());
        MultiPartFormInputStream.MultiPart stuff = (MultiPartFormInputStream.MultiPart)mpis.getPart("stuff");
        Assert.assertThat((Object)stuff.getSubmittedFileName(), (Matcher)Matchers.is((Object)filename));
        Assert.assertThat((Object)stuff.getContentType(), (Matcher)Matchers.is((Object)"text/plain"));
        Assert.assertThat((Object)stuff.getHeader("Content-Type"), (Matcher)Matchers.is((Object)"text/plain"));
        Assert.assertThat((Object)stuff.getHeaders("content-type").size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)stuff.getHeader("content-disposition"), (Matcher)Matchers.is((Object)("form-data; name=\"stuff\"; filename=\"" + filename + "\"")));
        Assert.assertThat((Object)stuff.getHeaderNames().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)stuff.getSize(), (Matcher)Matchers.is((Object)51L));
        File tmpfile = stuff.getFile();
        Assert.assertThat((Object)tmpfile, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)stuff.getBytes(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)tmpfile.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)tmpfile.getName(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)"stuff with space.txt")));
        stuff.write(filename);
        f = new File(this._dirname + File.separator + filename);
        Assert.assertThat((Object)f.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)tmpfile.exists(), (Matcher)Matchers.is((Object)false));
        try {
            stuff.getInputStream();
        }
        catch (Exception e) {
            Assert.fail((String)("Part.getInputStream() after file rename operation: " + e.getMessage()));
        }
        f.deleteOnExit();
    }

    @Test
    public void testMultiSameNames() throws Exception {
        String sameNames = "--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"stuff1.txt\"\r\nContent-Type: text/plain\r\n\r\n00000\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"stuff2.txt\"\r\nContent-Type: text/plain\r\n\r\n110000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(sameNames.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        for (Part p : parts) {
            Assert.assertEquals((Object)"stuff", (Object)p.getName());
        }
        Part p = mpis.getPart("stuff");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)5L, (long)p.getSize());
    }

    @Test
    public void testBase64EncodedContent() throws Exception {
        String contentWithEncodedPart = "--AaB03x\r\nContent-disposition: form-data; name=\"other\"\r\nContent-Type: text/plain\r\n\r\nother\r\n--AaB03x\r\nContent-disposition: form-data; name=\"stuff\"; filename=\"stuff.txt\"\r\nContent-Transfer-Encoding: base64\r\nContent-Type: application/octet-stream\r\n\r\n" + B64Code.encode((String)"hello jetty") + "\r\n--AaB03x\r\nContent-disposition: form-data; name=\"final\"\r\nContent-Type: text/plain\r\n\r\nthe end\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(contentWithEncodedPart.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertEquals((long)3L, (long)parts.size());
        Part p1 = mpis.getPart("other");
        Assert.assertNotNull((Object)p1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy((InputStream)p1.getInputStream(), (OutputStream)baos);
        Assert.assertEquals((Object)"other", (Object)baos.toString("US-ASCII"));
        Part p2 = mpis.getPart("stuff");
        Assert.assertNotNull((Object)p2);
        baos = new ByteArrayOutputStream();
        IO.copy((InputStream)p2.getInputStream(), (OutputStream)baos);
        Assert.assertEquals((Object)B64Code.encode((String)"hello jetty"), (Object)baos.toString("US-ASCII"));
        Part p3 = mpis.getPart("final");
        Assert.assertNotNull((Object)p3);
        baos = new ByteArrayOutputStream();
        IO.copy((InputStream)p3.getInputStream(), (OutputStream)baos);
        Assert.assertEquals((Object)"the end", (Object)baos.toString("US-ASCII"));
    }

    @Test
    public void testQuotedPrintableEncoding() throws Exception {
        String contentWithEncodedPart = "--AaB03x\r\nContent-disposition: form-data; name=\"other\"\r\nContent-Type: text/plain\r\n\r\nother\r\n--AaB03x\r\nContent-disposition: form-data; name=\"stuff\"; filename=\"stuff.txt\"\r\nContent-Transfer-Encoding: quoted-printable\r\nContent-Type: text/plain\r\n\r\ntruth=3Dbeauty\r\n--AaB03x--\r\n";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(contentWithEncodedPart.getBytes()), this._contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        Part p1 = mpis.getPart("other");
        Assert.assertNotNull((Object)p1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.copy((InputStream)p1.getInputStream(), (OutputStream)baos);
        Assert.assertEquals((Object)"other", (Object)baos.toString("US-ASCII"));
        Part p2 = mpis.getPart("stuff");
        Assert.assertNotNull((Object)p2);
        baos = new ByteArrayOutputStream();
        IO.copy((InputStream)p2.getInputStream(), (OutputStream)baos);
        Assert.assertEquals((Object)"truth=3Dbeauty", (Object)baos.toString("US-ASCII"));
    }

    @Test
    public void testGeneratedForm() throws Exception {
        String contentType = "multipart/form-data, boundary=WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW";
        String body = "Content-Type: multipart/form-data; boundary=WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\r\n\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\r\nContent-Disposition: form-data; name=\"part1\"\r\n\nwNf\uff90xVam\uffbft\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\nContent-Disposition: form-data; name=\"part2\"\r\n\r\n&\uffb3\u001b\u0014\uffba\uffd9\ufff9\uffd6\uffc3O\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW--";
        MultipartConfigElement config = new MultipartConfigElement(this._dirname, 1024L, 3072L, 50);
        MultiPartFormInputStream mpis = new MultiPartFormInputStream((InputStream)new ByteArrayInputStream(body.getBytes()), contentType, config, this._tmpDir);
        mpis.setDeleteOnExit(true);
        Collection parts = mpis.getParts();
        Assert.assertThat((Object)parts, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)parts.size(), (Matcher)Matchers.is((Object)2));
        Part part1 = mpis.getPart("part1");
        Assert.assertThat((Object)part1, (Matcher)Matchers.notNullValue());
        Part part2 = mpis.getPart("part2");
        Assert.assertThat((Object)part2, (Matcher)Matchers.notNullValue());
    }

    private static String createMultipartRequestString(String filename) {
        int length = filename.length();
        String name = filename;
        if (length > 10) {
            name = filename.substring(0, 10);
        }
        StringBuilder filler = new StringBuilder();
        for (int i = name.length(); i < 51; ++i) {
            filler.append("0");
        }
        return "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"; filename=\"frooble.txt\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"" + filename + "\"\r\nContent-Type: text/plain\r\n\r\n" + name + filler.toString() + "\r\n--AaB03x--\r\n";
    }
}

