/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.Syntax;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SyntaxTest {
    @Test
    public void testRequireValidRFC2616Token_Good() {
        String[] tokens;
        for (String token : tokens = new String[]{"name", "", null, "n.a.m.e", "na-me", "+name", "na*me", "na$me", "#name"}) {
            Syntax.requireValidRFC2616Token((String)token, (String)"Test Based");
        }
    }

    @Test
    public void testRequireValidRFC2616Token_Bad() {
        String[] tokens;
        for (String token : tokens = new String[]{"\"name\"", "name\t", "na me", "name\u0082", "na\tme", "na;me", "{name}", "[name]", "\""}) {
            try {
                Syntax.requireValidRFC2616Token((String)token, (String)"Test Based");
                Assert.fail((String)("RFC2616 Token [" + token + "] Should have thrown " + IllegalArgumentException.class.getName()));
            }
            catch (IllegalArgumentException e) {
                Assert.assertThat((String)("Testing Bad RFC2616 Token [" + token + "]"), (Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Test Based"), (Matcher)CoreMatchers.containsString((String)"RFC2616")));
            }
        }
    }

    @Test
    public void testRequireValidRFC6265CookieValue_Good() {
        String[] values;
        for (String value : values = new String[]{"value", "", null, "val=ue", "val-ue", "\"value\"", "val/ue", "v.a.l.u.e"}) {
            Syntax.requireValidRFC6265CookieValue((String)value);
        }
    }

    @Test
    public void testRequireValidRFC6265CookieValue_Bad() {
        String[] values;
        for (String value : values = new String[]{"va\tlue", "\t", "value\u0000", "val\u0082ue", "va lue", "va;lue", "\"value", "value\"", "val\\ue", "val\"ue", "\""}) {
            try {
                Syntax.requireValidRFC6265CookieValue((String)value);
                Assert.fail((String)("RFC6265 Cookie Value [" + value + "] Should have thrown " + IllegalArgumentException.class.getName()));
            }
            catch (IllegalArgumentException e) {
                Assert.assertThat((String)("Testing Bad RFC6265 Cookie Value [" + value + "]"), (Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"RFC6265"));
            }
        }
    }
}

