/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.jmh;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartCaptureTest;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class MultiPartBenchmark {
    public static final int MAX_FILE_SIZE = Integer.MAX_VALUE;
    public static final int MAX_REQUEST_SIZE = Integer.MAX_VALUE;
    public static final int FILE_SIZE_THRESHOLD = 50;
    public int count = 0;
    static String _contentType;
    static File _file;
    static int _numSections;
    static int _numBytesPerSection;
    public static List<String> data;
    @Param(value={"UTIL", "HTTP"})
    public static String parserType;

    @Setup(value=Level.Trial)
    public static void setupTrial() throws Exception {
        _file = File.createTempFile("test01", null);
        _file.deleteOnExit();
        _numSections = 1;
        _numBytesPerSection = 0xA00000;
        _contentType = "multipart/form-data, boundary=WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW";
        String initialBoundary = "--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\r\n";
        String boundary = "\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW\r\n";
        String closingBoundary = "\r\n--WebKitFormBoundary7MA4YWf7OaKlSxkTrZu0gW--\r\n";
        String headerStart = "Content-Disposition: form-data; name=\"";
        for (int i = 0; i < _numSections; ++i) {
            if (i == 0) {
                Files.write(_file.toPath(), initialBoundary.getBytes(), StandardOpenOption.APPEND);
            } else {
                Files.write(_file.toPath(), boundary.getBytes(), StandardOpenOption.APPEND);
            }
            Files.write(_file.toPath(), headerStart.getBytes(), StandardOpenOption.APPEND);
            Files.write(_file.toPath(), ("part" + (i + 1)).getBytes(), StandardOpenOption.APPEND);
            Files.write(_file.toPath(), "\"\r\n\r\n".getBytes(), StandardOpenOption.APPEND);
            byte[] data = new byte[_numBytesPerSection];
            new Random().nextBytes(data);
            Files.write(_file.toPath(), data, StandardOpenOption.APPEND);
        }
        Files.write(_file.toPath(), closingBoundary.getBytes(), StandardOpenOption.APPEND);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public long testLargeGenerated() throws Exception {
        Path multipartRawFile = _file.toPath();
        Path outputDir = new File("/tmp").toPath();
        MultipartConfigElement config = this.newMultipartConfigElement(outputDir);
        try (InputStream in = Files.newInputStream(multipartRawFile, new OpenOption[0]);){
            switch (parserType) {
                case "HTTP": {
                    MultiPartFormInputStream parser = new MultiPartFormInputStream(in, _contentType, config, outputDir.toFile());
                    if (parser.getParts().size() != _numSections) {
                        throw new IllegalStateException("Incorrect Parsing");
                    }
                    for (Part p : parser.getParts()) {
                        this.count = (int)((long)this.count + p.getSize());
                    }
                    break;
                }
                case "UTIL": {
                    MultiPartInputStreamParser parser = new MultiPartInputStreamParser(in, _contentType, config, outputDir.toFile());
                    if (parser.getParts().size() != _numSections) {
                        throw new IllegalStateException("Incorrect Parsing");
                    }
                    for (Part p : parser.getParts()) {
                        this.count = (int)((long)this.count + p.getSize());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown parserType Parameter");
                }
            }
        }
        return this.count;
    }

    @TearDown(value=Level.Trial)
    public static void stopTrial() throws Exception {
        _file = null;
    }

    private MultipartConfigElement newMultipartConfigElement(Path path) {
        return new MultipartConfigElement(path.toString(), Integer.MAX_VALUE, Integer.MAX_VALUE, 50);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public long testParser() throws Exception {
        block13: for (String multiPart : data) {
            Path multipartRawFile = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + multiPart + ".raw"));
            Path expectationPath = MavenTestingUtils.getTestResourcePathFile((String)("multipart/" + multiPart + ".expected.txt"));
            Path outputDir = new File("/tmp").toPath();
            MultiPartCaptureTest.MultipartExpectations multipartExpectations = new MultiPartCaptureTest.MultipartExpectations(expectationPath);
            MultipartConfigElement config = this.newMultipartConfigElement(outputDir);
            InputStream in = Files.newInputStream(multipartRawFile, new OpenOption[0]);
            Throwable throwable = null;
            try {
                switch (parserType) {
                    case "HTTP": {
                        MultiPartFormInputStream parser = new MultiPartFormInputStream(in, multipartExpectations.contentType, config, outputDir.toFile());
                        for (Part p : parser.getParts()) {
                            this.count = (int)((long)this.count + p.getSize());
                        }
                        continue block13;
                    }
                    case "UTIL": {
                        MultiPartFormInputStream parser = new MultiPartInputStreamParser(in, multipartExpectations.contentType, config, outputDir.toFile());
                        for (Part p : parser.getParts()) {
                            this.count = (int)((long)this.count + p.getSize());
                        }
                        continue block13;
                    }
                    default: {
                        throw new IllegalStateException("Unknown parserType Parameter");
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                MultiPartBenchmark.$closeResource(throwable, in);
            }
        }
        return this.count;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(MultiPartBenchmark.class.getSimpleName()).warmupIterations(20).measurementIterations(10).forks(1).threads(1).build();
        new Runner(opt).run();
    }

    static {
        data = new ArrayList<String>();
        data.add("browser-capture-form1-android-chrome");
        data.add("browser-capture-form1-android-firefox");
        data.add("browser-capture-form1-chrome");
        data.add("browser-capture-form1-edge");
        data.add("browser-capture-form1-firefox");
        data.add("browser-capture-form1-ios-safari");
        data.add("browser-capture-form1-msie");
        data.add("browser-capture-form1-osx-safari");
        data.add("browser-capture-sjis-form-edge");
        data.add("browser-capture-sjis-form-msie");
        data.add("browser-capture-sjis-charset-form-edge");
        data.add("browser-capture-sjis-charset-form-msie");
        data.add("browser-capture-form-fileupload-android-chrome");
        data.add("browser-capture-form-fileupload-android-firefox");
        data.add("browser-capture-form-fileupload-chrome");
        data.add("browser-capture-form-fileupload-edge");
        data.add("browser-capture-form-fileupload-firefox");
        data.add("browser-capture-form-fileupload-ios-safari");
        data.add("browser-capture-form-fileupload-msie");
        data.add("browser-capture-form-fileupload-safari");
        data.add("browser-capture-form-fileupload-alt-chrome");
        data.add("browser-capture-form-fileupload-alt-edge");
        data.add("browser-capture-form-fileupload-alt-firefox");
        data.add("browser-capture-form-fileupload-alt-msie");
        data.add("browser-capture-form-fileupload-alt-safari");
    }
}

