/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpURI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpURIParseTest {
    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"path", null, null, "-1", "path", null, null, null}), Arguments.of((Object[])new Object[]{"path/path", null, null, "-1", "path/path", null, null, null}), Arguments.of((Object[])new Object[]{"%65ncoded/path", null, null, "-1", "%65ncoded/path", null, null, null}), Arguments.of((Object[])new Object[]{"/path/to/context", null, null, "-1", "/path/to/context", null, null, null}), Arguments.of((Object[])new Object[]{"http://example.com/path/to/context;param?query=%22value%22#fragment", "http", "example.com", "-1", "/path/to/context;param", "param", "query=%22value%22", "fragment"}), Arguments.of((Object[])new Object[]{"http://[::1]/path/to/context;param?query=%22value%22#fragment", "http", "[::1]", "-1", "/path/to/context;param", "param", "query=%22value%22", "fragment"}), Arguments.of((Object[])new Object[]{"http://example.com:8080/path/to/context;param?query=%22value%22#fragment", "http", "example.com", "8080", "/path/to/context;param", "param", "query=%22value%22", "fragment"}), Arguments.of((Object[])new Object[]{"http://[::1]:8080/path/to/context;param?query=%22value%22#fragment", "http", "[::1]", "8080", "/path/to/context;param", "param", "query=%22value%22", "fragment"}), Arguments.of((Object[])new Object[]{"/path/info", null, null, null, "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"/path/info#fragment", null, null, null, "/path/info", null, null, "fragment"}), Arguments.of((Object[])new Object[]{"/path/info?query", null, null, null, "/path/info", null, "query", null}), Arguments.of((Object[])new Object[]{"/path/info?query#fragment", null, null, null, "/path/info", null, "query", "fragment"}), Arguments.of((Object[])new Object[]{"/path/info;param", null, null, null, "/path/info;param", "param", null, null}), Arguments.of((Object[])new Object[]{"/path/info;param#fragment", null, null, null, "/path/info;param", "param", null, "fragment"}), Arguments.of((Object[])new Object[]{"/path/info;param?query", null, null, null, "/path/info;param", "param", "query", null}), Arguments.of((Object[])new Object[]{"/path/info;param?query#fragment", null, null, null, "/path/info;param", "param", "query", "fragment"}), Arguments.of((Object[])new Object[]{"/path/info;a=b/foo;c=d", null, null, null, "/path/info;a=b/foo;c=d", "c=d", null, null}), Arguments.of((Object[])new Object[]{"//host/path/info", null, "host", null, "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"//user@host/path/info", null, "host", null, "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"//user@host:8080/path/info", null, "host", "8080", "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"//host:8080/path/info", null, "host", "8080", "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"http:/path/info", "http", null, null, "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"http:/path/info#fragment", "http", null, null, "/path/info", null, null, "fragment"}), Arguments.of((Object[])new Object[]{"http:/path/info?query", "http", null, null, "/path/info", null, "query", null}), Arguments.of((Object[])new Object[]{"http:/path/info?query#fragment", "http", null, null, "/path/info", null, "query", "fragment"}), Arguments.of((Object[])new Object[]{"http:/path/info;param", "http", null, null, "/path/info;param", "param", null, null}), Arguments.of((Object[])new Object[]{"http:/path/info;param#fragment", "http", null, null, "/path/info;param", "param", null, "fragment"}), Arguments.of((Object[])new Object[]{"http:/path/info;param?query", "http", null, null, "/path/info;param", "param", "query", null}), Arguments.of((Object[])new Object[]{"http:/path/info;param?query#fragment", "http", null, null, "/path/info;param", "param", "query", "fragment"}), Arguments.of((Object[])new Object[]{"http://user@host:8080/path/info;param?query#fragment", "http", "host", "8080", "/path/info;param", "param", "query", "fragment"}), Arguments.of((Object[])new Object[]{"xxxxx://user@host:8080/path/info;param?query#fragment", "xxxxx", "host", "8080", "/path/info;param", "param", "query", "fragment"}), Arguments.of((Object[])new Object[]{"http:///;?#", "http", null, null, "/;", "", "", ""}), Arguments.of((Object[])new Object[]{"/path/info?a=?query", null, null, null, "/path/info", null, "a=?query", null}), Arguments.of((Object[])new Object[]{"/path/info?a=;query", null, null, null, "/path/info", null, "a=;query", null}), Arguments.of((Object[])new Object[]{"/@path/info", null, null, null, "/@path/info", null, null, null}), Arguments.of((Object[])new Object[]{"/user@path/info", null, null, null, "/user@path/info", null, null, null}), Arguments.of((Object[])new Object[]{"//user@host/info", null, "host", null, "/info", null, null, null}), Arguments.of((Object[])new Object[]{"//@host/info", null, "host", null, "/info", null, null, null}), Arguments.of((Object[])new Object[]{"@host/info", null, null, null, "@host/info", null, null, null}), Arguments.of((Object[])new Object[]{"//host:8080//", null, "host", "8080", "//", null, null, null}), Arguments.of((Object[])new Object[]{"file:///path/info", "file", null, null, "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"file:/path/info", "file", null, null, "/path/info", null, null, null}), Arguments.of((Object[])new Object[]{"//", null, null, null, null, null, null, null}), Arguments.of((Object[])new Object[]{"http://localhost/", "http", "localhost", null, "/", null, null, null}), Arguments.of((Object[])new Object[]{"http://localhost:8080/", "http", "localhost", "8080", "/", null, null, null}), Arguments.of((Object[])new Object[]{"http://localhost/?x=y", "http", "localhost", null, "/", null, "x=y", null}), Arguments.of((Object[])new Object[]{"/;param", null, null, null, "/;param", "param", null, null}), Arguments.of((Object[])new Object[]{";param", null, null, null, ";param", "param", null, null}), Arguments.of((Object[])new Object[]{"/?x=y", null, null, null, "/", null, "x=y", null}), Arguments.of((Object[])new Object[]{"/?abc=test", null, null, null, "/", null, "abc=test", null}), Arguments.of((Object[])new Object[]{"/#fragment", null, null, null, "/", null, null, "fragment"}), Arguments.of((Object[])new Object[]{"http://192.0.0.1:8080/", "http", "192.0.0.1", "8080", "/", null, null, null}), Arguments.of((Object[])new Object[]{"http://[2001:db8::1]:8080/", "http", "[2001:db8::1]", "8080", "/", null, null, null}), Arguments.of((Object[])new Object[]{"http://user@[2001:db8::1]:8080/", "http", "[2001:db8::1]", "8080", "/", null, null, null}), Arguments.of((Object[])new Object[]{"http://[2001:db8::1]/", "http", "[2001:db8::1]", null, "/", null, null, null}), Arguments.of((Object[])new Object[]{"//[2001:db8::1]:8080/", null, "[2001:db8::1]", "8080", "/", null, null, null}), Arguments.of((Object[])new Object[]{"*", null, null, null, "*", null, null, null}), Arguments.of((Object[])new Object[]{"http://host:8080/path/info?q1=v1&q2=v2", "http", "host", "8080", "/path/info", null, "q1=v1&q2=v2", null}), Arguments.of((Object[])new Object[]{"/path/info?q1=v1&q2=v2", null, null, null, "/path/info", null, "q1=v1&q2=v2", null}), Arguments.of((Object[])new Object[]{"/info?q1=v1&q2=v2", null, null, null, "/info", null, "q1=v1&q2=v2", null}), Arguments.of((Object[])new Object[]{"info?q1=v1&q2=v2", null, null, null, "info", null, "q1=v1&q2=v2", null}), Arguments.of((Object[])new Object[]{"info;q1=v1?q2=v2", null, null, null, "info;q1=v1", "q1=v1", "q2=v2", null}), Arguments.of((Object[])new Object[]{"?q1=v1&q2=v2", null, null, null, "", null, "q1=v1&q2=v2", null}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testParseString(String input, String scheme, String host, Integer port, String path, String param, String query, String fragment) throws Exception {
        HttpURI httpUri = new HttpURI(input);
        try {
            new URI(input);
            MatcherAssert.assertThat((String)("[" + input + "] expected path (test case) cannot be null"), (Object)path, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)("[" + input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Object)scheme));
            MatcherAssert.assertThat((String)("[" + input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Object)host));
            MatcherAssert.assertThat((String)("[" + input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)(port == null ? -1 : port)));
            MatcherAssert.assertThat((String)("[" + input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Object)path));
            MatcherAssert.assertThat((String)("[" + input + "] .param"), (Object)httpUri.getParam(), (Matcher)Matchers.is((Object)param));
            MatcherAssert.assertThat((String)("[" + input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Object)query));
            MatcherAssert.assertThat((String)("[" + input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Object)fragment));
            MatcherAssert.assertThat((String)("[" + input + "] .toString"), (Object)httpUri.toString(), (Matcher)Matchers.is((Object)input));
        }
        catch (URISyntaxException e) {
            MatcherAssert.assertThat((String)("[" + input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((String)("[" + input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((String)("[" + input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)-1));
            MatcherAssert.assertThat((String)("[" + input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((String)("[" + input + "] .param"), (Object)httpUri.getParam(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((String)("[" + input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((String)("[" + input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testParseURI(String input, String scheme, String host, Integer port, String path, String param, String query, String fragment) throws Exception {
        URI javaUri = null;
        try {
            javaUri = new URI(input);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Assumptions.assumeTrue((javaUri != null ? 1 : 0) != 0, (String)"Skipping, not a valid input URI");
        HttpURI httpUri = new HttpURI(javaUri);
        MatcherAssert.assertThat((String)("[" + input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Object)scheme));
        MatcherAssert.assertThat((String)("[" + input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Object)host));
        MatcherAssert.assertThat((String)("[" + input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)(port == null ? -1 : port)));
        MatcherAssert.assertThat((String)("[" + input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Object)path));
        MatcherAssert.assertThat((String)("[" + input + "] .param"), (Object)httpUri.getParam(), (Matcher)Matchers.is((Object)param));
        MatcherAssert.assertThat((String)("[" + input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Object)query));
        MatcherAssert.assertThat((String)("[" + input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Object)fragment));
        MatcherAssert.assertThat((String)("[" + input + "] .toString"), (Object)httpUri.toString(), (Matcher)Matchers.is((Object)input));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCompareToJavaNetURI(String input, String scheme, String host, Integer port, String path, String param, String query, String fragment) throws Exception {
        URI javaUri = null;
        try {
            javaUri = new URI(input);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Assumptions.assumeTrue((javaUri != null ? 1 : 0) != 0, (String)"Skipping, not a valid input URI");
        HttpURI httpUri = new HttpURI(javaUri);
        MatcherAssert.assertThat((String)("[" + input + "] .scheme"), (Object)httpUri.getScheme(), (Matcher)Matchers.is((Object)javaUri.getScheme()));
        MatcherAssert.assertThat((String)("[" + input + "] .host"), (Object)httpUri.getHost(), (Matcher)Matchers.is((Object)javaUri.getHost()));
        MatcherAssert.assertThat((String)("[" + input + "] .port"), (Object)httpUri.getPort(), (Matcher)Matchers.is((Object)javaUri.getPort()));
        MatcherAssert.assertThat((String)("[" + input + "] .path"), (Object)httpUri.getPath(), (Matcher)Matchers.is((Object)javaUri.getRawPath()));
        MatcherAssert.assertThat((String)("[" + input + "] .query"), (Object)httpUri.getQuery(), (Matcher)Matchers.is((Object)javaUri.getRawQuery()));
        MatcherAssert.assertThat((String)("[" + input + "] .fragment"), (Object)httpUri.getFragment(), (Matcher)Matchers.is((Object)javaUri.getFragment()));
        MatcherAssert.assertThat((String)("[" + input + "] .toString"), (Object)httpUri.toString(), (Matcher)Matchers.is((Object)javaUri.toASCIIString()));
    }
}

