/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.HttpCookie;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpCookieTest {
    @Test
    public void testConstructFromSetCookie() {
        HttpCookie cookie = new HttpCookie("everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly");
    }

    @Test
    public void testSetRFC2965Cookie() throws Exception {
        HttpCookie httpCookie = new HttpCookie("null", null, null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"null=", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("minimal", "value", null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"minimal=value", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("everything", "something", "domain", "path", 0L, true, true, "noncomment", 0);
        Assertions.assertEquals((Object)"everything=something;Version=1;Path=path;Domain=domain;Expires=Thu, 01-Jan-1970 00:00:00 GMT;Max-Age=0;Secure;HttpOnly;Comment=noncomment", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, "comment", 0);
        Assertions.assertEquals((Object)"everything=value;Version=1;Path=path;Domain=domain;Expires=Thu, 01-Jan-1970 00:00:00 GMT;Max-Age=0;Secure;HttpOnly;Comment=comment", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("ev erything", "va lue", "do main", "pa th", 1L, true, true, "co mment", 1);
        String setCookie = httpCookie.getRFC2965SetCookie();
        MatcherAssert.assertThat((Object)setCookie, (Matcher)Matchers.startsWith((String)"\"ev erything\"=\"va lue\";Version=1;Path=\"pa th\";Domain=\"do main\";Expires="));
        MatcherAssert.assertThat((Object)setCookie, (Matcher)Matchers.endsWith((String)" GMT;Max-Age=1;Secure;HttpOnly;Comment=\"co mment\""));
        httpCookie = new HttpCookie("name", "value", null, null, -1L, false, false, null, 0);
        setCookie = httpCookie.getRFC2965SetCookie();
        Assertions.assertEquals((int)-1, (int)setCookie.indexOf("Version="));
        httpCookie = new HttpCookie("name", "v a l u e", null, null, -1L, false, false, null, 0);
        setCookie = httpCookie.getRFC2965SetCookie();
        httpCookie = new HttpCookie("json", "{\"services\":[\"cwa\",  \"aa\"]}", null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"json=\"{\\\"services\\\":[\\\"cwa\\\",  \\\"aa\\\"]}\"", (Object)httpCookie.getRFC2965SetCookie());
        httpCookie = new HttpCookie("name", "value%=", null, null, -1L, false, false, null, 0);
        setCookie = httpCookie.getRFC2965SetCookie();
        Assertions.assertEquals((Object)"name=value%=", (Object)setCookie);
    }

    @Test
    public void testSetRFC6265Cookie() throws Exception {
        String[] goodValueExamples;
        String[] goodNameExamples;
        String[] badValueExamples;
        String[] badNameExamples;
        HttpCookie httpCookie = new HttpCookie("null", null, null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"null=", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("minimal", "value", null, null, -1L, false, false, null, -1);
        Assertions.assertEquals((Object)"minimal=value", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "something", "domain", "path", 0L, true, true, null, -1);
        Assertions.assertEquals((Object)"everything=something; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1, HttpCookie.SameSite.NONE);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly; SameSite=None", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1, HttpCookie.SameSite.LAX);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly; SameSite=Lax", (Object)httpCookie.getRFC6265SetCookie());
        httpCookie = new HttpCookie("everything", "value", "domain", "path", 0L, true, true, null, -1, HttpCookie.SameSite.STRICT);
        Assertions.assertEquals((Object)"everything=value; Path=path; Domain=domain; Expires=Thu, 01-Jan-1970 00:00:00 GMT; Max-Age=0; Secure; HttpOnly; SameSite=Strict", (Object)httpCookie.getRFC6265SetCookie());
        for (String badNameExample : badNameExamples = new String[]{"\"name\"", "name\t", "na me", "name\u0082", "na\tme", "na;me", "{name}", "[name]", "\""}) {
            try {
                httpCookie = new HttpCookie(badNameExample, "value", null, "/", 1L, true, true, null, -1);
                httpCookie.getRFC6265SetCookie();
                Assertions.fail((String)badNameExample);
            }
            catch (IllegalArgumentException ex) {
                MatcherAssert.assertThat((String)("Testing bad name: [" + badNameExample + "]"), (Object)ex.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"RFC6265"), (Matcher)Matchers.containsString((String)"RFC2616")));
            }
        }
        for (String badValueExample : badValueExamples = new String[]{"va\tlue", "\t", "value\u0000", "val\u0082ue", "va lue", "va;lue", "\"value", "value\"", "val\\ue", "val\"ue", "\""}) {
            try {
                httpCookie = new HttpCookie("name", badValueExample, null, "/", 1L, true, true, null, -1);
                httpCookie.getRFC6265SetCookie();
                Assertions.fail();
            }
            catch (IllegalArgumentException ex) {
                MatcherAssert.assertThat((String)("Testing bad value [" + badValueExample + "]"), (Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"RFC6265"));
            }
        }
        for (String goodNameExample : goodNameExamples = new String[]{"name", "n.a.m.e", "na-me", "+name", "na*me", "na$me", "#name"}) {
            httpCookie = new HttpCookie(goodNameExample, "value", null, "/", 1L, true, true, null, -1);
        }
        for (String goodValueExample : goodValueExamples = new String[]{"value", "", null, "val=ue", "val-ue", "val/ue", "v.a.l.u.e"}) {
            httpCookie = new HttpCookie("name", goodValueExample, null, "/", 1L, true, true, null, -1);
        }
    }

    @Test
    public void testGetHttpOnlyFromComment() {
        Assertions.assertTrue((boolean)HttpCookie.isHttpOnlyInComment((String)"__HTTP_ONLY__"));
        Assertions.assertTrue((boolean)HttpCookie.isHttpOnlyInComment((String)"__HTTP_ONLY__comment"));
        Assertions.assertFalse((boolean)HttpCookie.isHttpOnlyInComment((String)"comment"));
    }

    @Test
    public void testGetSameSiteFromComment() {
        Assertions.assertEquals((Object)HttpCookie.getSameSiteFromComment((String)"__SAME_SITE_NONE__"), (Object)HttpCookie.SameSite.NONE);
        Assertions.assertEquals((Object)HttpCookie.getSameSiteFromComment((String)"__SAME_SITE_LAX__"), (Object)HttpCookie.SameSite.LAX);
        Assertions.assertEquals((Object)HttpCookie.getSameSiteFromComment((String)"__SAME_SITE_STRICT__"), (Object)HttpCookie.SameSite.STRICT);
        Assertions.assertEquals((Object)HttpCookie.getSameSiteFromComment((String)"__SAME_SITE_NONE____SAME_SITE_STRICT__"), (Object)HttpCookie.SameSite.NONE);
        Assertions.assertNull((Object)HttpCookie.getSameSiteFromComment((String)"comment"));
    }

    @Test
    public void getCommentWithoutAttributes() {
        Assertions.assertEquals((Object)HttpCookie.getCommentWithoutAttributes((String)"comment__SAME_SITE_NONE__"), (Object)"comment");
        Assertions.assertEquals((Object)HttpCookie.getCommentWithoutAttributes((String)"comment__HTTP_ONLY____SAME_SITE_NONE__"), (Object)"comment");
        Assertions.assertNull((Object)HttpCookie.getCommentWithoutAttributes((String)"__SAME_SITE_LAX__"));
    }
}

