/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class HttpFieldsTest {
    @Test
    public void testPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value:0");
        header.put("name1", "value1");
        Assertions.assertEquals((int)2, (int)header.size());
        Assertions.assertEquals((Object)"value:0", (Object)header.get("name0"));
        Assertions.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assertions.assertNull((Object)header.get("name2"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if (!"name1".equals(o)) continue;
            ++matches;
        }
        Assertions.assertEquals((int)2, (int)matches);
        e = header.getValues("name0");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value:0");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testPutTo() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value:A");
        header.add("name1", "value:B");
        header.add("name2", "");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String result = BufferUtil.toString((ByteBuffer)buffer);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name0: value0"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name1: value:A"));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"name1: value:B"));
    }

    @Test
    public void testGet() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "value1");
        Assertions.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assertions.assertEquals((Object)"value0", (Object)header.get("Name0"));
        Assertions.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assertions.assertEquals((Object)"value1", (Object)header.get("Name1"));
        Assertions.assertEquals(null, (Object)header.get("Name2"));
        Assertions.assertEquals((Object)"value0", (Object)header.getField("name0").getValue());
        Assertions.assertEquals((Object)"value0", (Object)header.getField("Name0").getValue());
        Assertions.assertEquals((Object)"value1", (Object)header.getField("name1").getValue());
        Assertions.assertEquals((Object)"value1", (Object)header.getField("Name1").getValue());
        Assertions.assertEquals(null, (Object)header.getField("Name2"));
        Assertions.assertEquals((Object)"value0", (Object)header.getField(0).getValue());
        Assertions.assertEquals((Object)"value1", (Object)header.getField(1).getValue());
        Assertions.assertThrows(NoSuchElementException.class, () -> header.getField(2));
    }

    @Test
    public void testGetKnown() throws Exception {
        HttpFields header = new HttpFields();
        header.put("Connection", "value0");
        header.put(HttpHeader.ACCEPT, "value1");
        Assertions.assertEquals((Object)"value0", (Object)header.get(HttpHeader.CONNECTION));
        Assertions.assertEquals((Object)"value1", (Object)header.get(HttpHeader.ACCEPT));
        Assertions.assertEquals((Object)"value0", (Object)header.getField(HttpHeader.CONNECTION).getValue());
        Assertions.assertEquals((Object)"value1", (Object)header.getField(HttpHeader.ACCEPT).getValue());
        Assertions.assertEquals(null, (Object)header.getField(HttpHeader.AGE));
        Assertions.assertEquals(null, (Object)header.get(HttpHeader.AGE));
    }

    @Test
    public void testCRLF() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value\r\n0");
        header.put("name\r\n1", "value1");
        header.put("name:2", "value:\r\n2");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String out = BufferUtil.toString((ByteBuffer)buffer);
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name0: value  0"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name??1: value1"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"name?2: value:  2"));
    }

    @Test
    public void testCachedPut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("Connection", "Keep-Alive");
        header.put("tRansfer-EncOding", "CHUNKED");
        header.put("CONTENT-ENCODING", "gZIP");
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        BufferUtil.flipToFill((ByteBuffer)buffer);
        HttpGenerator.putTo((HttpFields)header, (ByteBuffer)buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        String out = BufferUtil.toString((ByteBuffer)buffer).toLowerCase(Locale.ENGLISH);
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.CONNECTION + ": " + HttpHeaderValue.KEEP_ALIVE).toLowerCase(Locale.ENGLISH)));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.TRANSFER_ENCODING + ": " + HttpHeaderValue.CHUNKED).toLowerCase(Locale.ENGLISH)));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)(HttpHeader.CONTENT_ENCODING + ": " + HttpHeaderValue.GZIP).toLowerCase(Locale.ENGLISH)));
    }

    @Test
    public void testRePut() throws Exception {
        HttpFields header = new HttpFields();
        header.put("name0", "value0");
        header.put("name1", "xxxxxx");
        header.put("name2", "value2");
        Assertions.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assertions.assertEquals((Object)"xxxxxx", (Object)header.get("name1"));
        Assertions.assertEquals((Object)"value2", (Object)header.get("name2"));
        header.put("name1", "value1");
        Assertions.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assertions.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assertions.assertEquals((Object)"value2", (Object)header.get("name2"));
        Assertions.assertNull((Object)header.get("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            String o = (String)e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assertions.assertEquals((int)3, (int)matches);
        e = header.getValues("name1");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value1");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testRemovePut() throws Exception {
        HttpFields header = new HttpFields(1);
        header.put("name0", "value0");
        header.put("name1", "value1");
        header.put("name2", "value2");
        Assertions.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assertions.assertEquals((Object)"value1", (Object)header.get("name1"));
        Assertions.assertEquals((Object)"value2", (Object)header.get("name2"));
        header.remove("name1");
        Assertions.assertEquals((Object)"value0", (Object)header.get("name0"));
        Assertions.assertNull((Object)header.get("name1"));
        Assertions.assertEquals((Object)"value2", (Object)header.get("name2"));
        Assertions.assertNull((Object)header.get("name3"));
        int matches = 0;
        Enumeration e = header.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assertions.assertEquals((int)2, (int)matches);
        e = header.getValues("name1");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testAdd() throws Exception {
        HttpFields fields = new HttpFields();
        fields.add("name0", "value0");
        fields.add("name1", "valueA");
        fields.add("name2", "value2");
        Assertions.assertEquals((Object)"value0", (Object)fields.get("name0"));
        Assertions.assertEquals((Object)"valueA", (Object)fields.get("name1"));
        Assertions.assertEquals((Object)"value2", (Object)fields.get("name2"));
        fields.add("name1", "valueB");
        Assertions.assertEquals((Object)"value0", (Object)fields.get("name0"));
        Assertions.assertEquals((Object)"valueA", (Object)fields.get("name1"));
        Assertions.assertEquals((Object)"value2", (Object)fields.get("name2"));
        Assertions.assertNull((Object)fields.get("name3"));
        int matches = 0;
        Enumeration e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if ("name0".equals(o)) {
                ++matches;
            }
            if ("name1".equals(o)) {
                ++matches;
            }
            if (!"name2".equals(o)) continue;
            ++matches;
        }
        Assertions.assertEquals((int)3, (int)matches);
        e = fields.getValues("name1");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"valueA");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"valueB");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testPreEncodedField() {
        ByteBuffer buffer = BufferUtil.allocate((int)1024);
        PreEncodedHttpField known = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        BufferUtil.clearToFill((ByteBuffer)buffer);
        known.putTo(buffer, HttpVersion.HTTP_1_1);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)buffer), (Matcher)Matchers.is((Object)"Connection: close\r\n"));
        PreEncodedHttpField unknown = new PreEncodedHttpField(null, "Header", "Value");
        BufferUtil.clearToFill((ByteBuffer)buffer);
        unknown.putTo(buffer, HttpVersion.HTTP_1_1);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        MatcherAssert.assertThat((Object)BufferUtil.toString((ByteBuffer)buffer), (Matcher)Matchers.is((Object)"Header: Value\r\n"));
    }

    @Test
    public void testAddPreEncodedField() {
        PreEncodedHttpField X_XSS_PROTECTION_FIELD = new PreEncodedHttpField("X-XSS-Protection", "1; mode=block");
        HttpFields fields = new HttpFields();
        fields.add((HttpField)X_XSS_PROTECTION_FIELD);
        MatcherAssert.assertThat((String)"Fields output", (Object)fields.toString(), (Matcher)Matchers.containsString((String)"X-XSS-Protection: 1; mode=block"));
    }

    @Test
    public void testAddFinalHttpField() {
        HttpField X_XSS_PROTECTION_FIELD = new HttpField("X-XSS-Protection", "1; mode=block");
        HttpFields fields = new HttpFields();
        fields.add(X_XSS_PROTECTION_FIELD);
        MatcherAssert.assertThat((String)"Fields output", (Object)fields.toString(), (Matcher)Matchers.containsString((String)"X-XSS-Protection: 1; mode=block"));
    }

    @Test
    public void testGetValues() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("name0", "value0A,value0B");
        fields.add("name0", "value0C,value0D");
        fields.put("name1", "value1A, \"value\t, 1B\" ");
        fields.add("name1", "\"value1C\",\tvalue1D");
        Enumeration e = fields.getValues("name0");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0A,value0B");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0C,value0D");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = fields.getValues("name0", ",");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0A");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0B");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0C");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0D");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = fields.getValues("name1", ",");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value1A");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value\t, 1B");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value1C");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value1D");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testGetCSV() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("name0", "value0A,value0B");
        fields.add("name0", "value0C,value0D");
        fields.put("name1", "value1A, \"value\t, 1B\" ");
        fields.add("name1", "\"value1C\",\tvalue1D");
        Enumeration e = fields.getValues("name0");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0A,value0B");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0C,value0D");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = Collections.enumeration(fields.getCSV("name0", false));
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0A");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0B");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0C");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value0D");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
        e = Collections.enumeration(fields.getCSV("name1", false));
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value1A");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value\t, 1B");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value1C");
        Assertions.assertEquals((Object)true, (Object)e.hasMoreElements());
        Assertions.assertEquals(e.nextElement(), (Object)"value1D");
        Assertions.assertEquals((Object)false, (Object)e.hasMoreElements());
    }

    @Test
    public void testAddQuotedCSV() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("some", "value");
        fields.add("name", "\"zero\"");
        fields.add("name", "one, \"1 + 1\"");
        fields.put("other", "value");
        fields.add("name", "three");
        fields.add("name", "four, I V");
        List list = fields.getCSV("name", false);
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(0)), null), (Object)"zero");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(1)), null), (Object)"one");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(2)), null), (Object)"1 + 1");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(3)), null), (Object)"three");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(4)), null), (Object)"four");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(5)), null), (Object)"I V");
        fields.addCSV("name", new String[]{"six"});
        list = fields.getCSV("name", false);
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(0)), null), (Object)"zero");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(1)), null), (Object)"one");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(2)), null), (Object)"1 + 1");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(3)), null), (Object)"three");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(4)), null), (Object)"four");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(5)), null), (Object)"I V");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(6)), null), (Object)"six");
        fields.addCSV("name", new String[]{"1 + 1", "7", "zero"});
        list = fields.getCSV("name", false);
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(0)), null), (Object)"zero");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(1)), null), (Object)"one");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(2)), null), (Object)"1 + 1");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(3)), null), (Object)"three");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(4)), null), (Object)"four");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(5)), null), (Object)"I V");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(6)), null), (Object)"six");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(7)), null), (Object)"7");
    }

    @Test
    public void testGetQualityCSV() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("some", "value");
        fields.add("name", "zero;q=0.9,four;q=0.1");
        fields.put("other", "value");
        fields.add("name", "nothing;q=0");
        fields.add("name", "one;q=0.4");
        fields.add("name", "three;x=y;q=0.2;a=b,two;q=0.3");
        fields.add("name", "first;");
        List list = fields.getQualityCSV("name");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(0)), null), (Object)"first");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(1)), null), (Object)"zero");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(2)), null), (Object)"one");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(3)), null), (Object)"two");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(4)), null), (Object)"three");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(5)), null), (Object)"four");
    }

    @Test
    public void testGetQualityCSVHeader() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("some", "value");
        fields.add("Accept", "zero;q=0.9,four;q=0.1");
        fields.put("other", "value");
        fields.add("Accept", "nothing;q=0");
        fields.add("Accept", "one;q=0.4");
        fields.add("Accept", "three;x=y;q=0.2;a=b,two;q=0.3");
        fields.add("Accept", "first;");
        List list = fields.getQualityCSV(HttpHeader.ACCEPT);
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(0)), null), (Object)"first");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(1)), null), (Object)"zero");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(2)), null), (Object)"one");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(3)), null), (Object)"two");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(4)), null), (Object)"three");
        Assertions.assertEquals((Object)HttpFields.valueParameters((String)((String)list.get(5)), null), (Object)"four");
    }

    @Test
    public void testDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("D0", "Wed, 31 Dec 1969 23:59:59 GMT");
        fields.put("D1", "Fri, 31 Dec 1999 23:59:59 GMT");
        fields.put("D2", "Friday, 31-Dec-99 23:59:59 GMT");
        fields.put("D3", "Fri Dec 31 23:59:59 1999");
        fields.put("D4", "Mon Jan 1 2000 00:00:01");
        fields.put("D5", "Tue Feb 29 2000 12:00:00");
        long d1 = fields.getDateField("D1");
        long d0 = fields.getDateField("D0");
        long d2 = fields.getDateField("D2");
        long d3 = fields.getDateField("D3");
        long d4 = fields.getDateField("D4");
        long d5 = fields.getDateField("D5");
        Assertions.assertTrue((d0 != -1L ? 1 : 0) != 0);
        Assertions.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)d1, (long)d2);
        Assertions.assertEquals((long)d2, (long)d3);
        Assertions.assertEquals((long)(d3 + 2000L), (long)d4);
        Assertions.assertEquals((long)951825600000L, (long)d5);
        d1 = fields.getDateField("D1");
        d2 = fields.getDateField("D2");
        d3 = fields.getDateField("D3");
        d4 = fields.getDateField("D4");
        d5 = fields.getDateField("D5");
        Assertions.assertTrue((d1 > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((d2 > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)d1, (long)d2);
        Assertions.assertEquals((long)d2, (long)d3);
        Assertions.assertEquals((long)(d3 + 2000L), (long)d4);
        Assertions.assertEquals((long)951825600000L, (long)d5);
        fields.putDateField("D2", d1);
        Assertions.assertEquals((Object)"Fri, 31 Dec 1999 23:59:59 GMT", (Object)fields.get("D2"));
    }

    @Test
    public void testNegDateFields() throws Exception {
        HttpFields fields = new HttpFields();
        fields.putDateField("Dzero", 0L);
        Assertions.assertEquals((Object)"Thu, 01 Jan 1970 00:00:00 GMT", (Object)fields.get("Dzero"));
        fields.putDateField("Dminus", -1L);
        Assertions.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.get("Dminus"));
        fields.putDateField("Dminus", -1000L);
        Assertions.assertEquals((Object)"Wed, 31 Dec 1969 23:59:59 GMT", (Object)fields.get("Dminus"));
        fields.putDateField("Dancient", Long.MIN_VALUE);
        Assertions.assertEquals((Object)"Sun, 02 Dec 55 16:47:04 GMT", (Object)fields.get("Dancient"));
    }

    @Test
    public void testLongFields() throws Exception {
        HttpFields header = new HttpFields();
        header.put("I1", "42");
        header.put("I2", " 43 99");
        header.put("I3", "-44");
        header.put("I4", " - 45abc");
        header.put("N1", " - ");
        header.put("N2", "xx");
        long i1 = header.getLongField("I1");
        try {
            header.getLongField("I2");
            Assertions.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assertions.assertTrue((boolean)true);
        }
        long i3 = header.getLongField("I3");
        try {
            header.getLongField("I4");
            Assertions.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            header.getLongField("N1");
            Assertions.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            header.getLongField("N2");
            Assertions.assertTrue((boolean)false);
        }
        catch (NumberFormatException e) {
            Assertions.assertTrue((boolean)true);
        }
        Assertions.assertEquals((long)42L, (long)i1);
        Assertions.assertEquals((long)-44L, (long)i3);
        header.putLongField("I5", 46L);
        header.putLongField("I6", -47L);
        Assertions.assertEquals((Object)"46", (Object)header.get("I5"));
        Assertions.assertEquals((Object)"-47", (Object)header.get("I6"));
    }

    @Test
    public void testContains() throws Exception {
        HttpFields header = new HttpFields();
        header.add("n0", "");
        header.add("n1", ",");
        header.add("n2", ",,");
        header.add("N3", "abc");
        header.add("N4", "def");
        header.add("n5", "abc,def,hig");
        header.add("N6", "abc");
        header.add("n6", "def");
        header.add("N6", "hig");
        header.add("n7", "abc ,  def;q=0.9  ,  hig");
        header.add("n8", "abc ,  def;q=0  ,  hig");
        header.add(HttpHeader.ACCEPT, "abc ,  def;q=0  ,  hig");
        for (int i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)header.containsKey("n" + i));
            Assertions.assertTrue((boolean)header.containsKey("N" + i));
            Assertions.assertFalse((boolean)header.contains("n" + i, "xyz"), (String)("" + i));
            Assertions.assertEquals((Object)(i >= 4 ? 1 : 0), (Object)header.contains("n" + i, "def"), (String)("" + i));
        }
        Assertions.assertTrue((boolean)header.contains(new HttpField("N5", "def")));
        Assertions.assertTrue((boolean)header.contains(new HttpField("accept", "abc")));
        Assertions.assertTrue((boolean)header.contains(HttpHeader.ACCEPT, "abc"));
        Assertions.assertFalse((boolean)header.contains(new HttpField("N5", "xyz")));
        Assertions.assertFalse((boolean)header.contains(new HttpField("N8", "def")));
        Assertions.assertFalse((boolean)header.contains(HttpHeader.ACCEPT, "def"));
        Assertions.assertFalse((boolean)header.contains(HttpHeader.AGE, "abc"));
        Assertions.assertFalse((boolean)header.containsKey("n11"));
    }

    @ParameterizedTest
    @ValueSource(strings={"Host", "host", "HOST", "HoSt", "Connection", "CONNECTION", "connection", "CoNnEcTiOn"})
    public void testContainsKeyTrue(String keyName) {
        HttpFields fields = new HttpFields();
        fields.put("Host", "localhost");
        HttpField namelessField = new HttpField(HttpHeader.CONNECTION, null, "bogus");
        fields.put(namelessField);
        Assertions.assertTrue((boolean)fields.containsKey(keyName), (String)("containsKey('" + keyName + "')"));
    }

    @ParameterizedTest
    @ValueSource(strings={"Content-Type", "Content-Length", "X-Bogus", ""})
    public void testContainsKeyFalse(String keyName) {
        HttpFields fields = new HttpFields();
        fields.add("Host", "localhost");
        HttpField namelessField = new HttpField(HttpHeader.CONNECTION, null, "bogus");
        fields.put(namelessField);
        Assertions.assertFalse((boolean)fields.containsKey(keyName), (String)("containsKey('" + keyName + "')"));
    }

    @Test
    public void testPreventNullField() {
        HttpFields fields = new HttpFields();
        Assertions.assertThrows(NullPointerException.class, () -> {
            HttpField nullNullField = new HttpField(null, null, "bogus");
            fields.put(nullNullField);
        });
    }

    @Test
    public void testIteration() throws Exception {
        HttpFields header = new HttpFields();
        Iterator i = header.iterator();
        MatcherAssert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
        header.put("name1", "valueA");
        header.put("name2", "valueB");
        header.add("name3", "valueC");
        i = header.iterator();
        MatcherAssert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name1"));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name2"));
        i.remove();
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        MatcherAssert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
        i = header.iterator();
        MatcherAssert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name1"));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        MatcherAssert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
        ListIterator l = header.listIterator();
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        l.add(new HttpField("name0", "value"));
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"name1"));
        l.set(new HttpField("NAME1", "value"));
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)l.previous()).getName(), (Matcher)Matchers.is((Object)"NAME1"));
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)l.previous()).getName(), (Matcher)Matchers.is((Object)"name0"));
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"name0"));
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"NAME1"));
        l.add(new HttpField("name2", "value"));
        MatcherAssert.assertThat((Object)((HttpField)l.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        l.add(new HttpField("name4", "value"));
        MatcherAssert.assertThat((Object)l.hasNext(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)l.hasPrevious(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)l.previous()).getName(), (Matcher)Matchers.is((Object)"name4"));
        i = header.iterator();
        MatcherAssert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name0"));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"NAME1"));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name2"));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name3"));
        MatcherAssert.assertThat((Object)((HttpField)i.next()).getName(), (Matcher)Matchers.is((Object)"name4"));
        MatcherAssert.assertThat((Object)i.hasNext(), (Matcher)Matchers.is((Object)false));
    }
}

