/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class QuotedQualityCSVTest {
    private static final String[] preferBrotli = new String[]{"br", "gzip"};
    private static final String[] preferGzip = new String[]{"gzip", "br"};
    private static final String[] noFormats = new String[0];

    @Test
    public void test7231_5_3_2_example1() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue(" audio/*; q=0.2, audio/basic");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"audio/basic", "audio/*"}));
    }

    @Test
    public void test7231_5_3_2_example2() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("text/plain; q=0.5, text/html,");
        values.addValue("text/x-dvi; q=0.8, text/x-c");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/html", "text/x-c", "text/x-dvi", "text/plain"}));
    }

    @Test
    public void test7231_5_3_2_example3() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("text/*, text/plain, text/plain;format=flowed, */*");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/*", "text/plain", "text/plain;format=flowed", "*/*"}));
    }

    @Test
    public void test7231_5_3_2_example3_most_specific() {
        QuotedQualityCSV values = new QuotedQualityCSV(QuotedQualityCSV.MOST_SPECIFIC_MIME_ORDERING);
        values.addValue("text/*, text/plain, text/plain;format=flowed, */*");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/plain;format=flowed", "text/plain", "text/*", "*/*"}));
    }

    @Test
    public void test7231_5_3_2_example4() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("text/*;q=0.3, text/html;q=0.7, text/html;level=1,");
        values.addValue("text/html;level=2;q=0.4, */*;q=0.5");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"text/html;level=1", "text/html", "*/*", "text/html;level=2", "text/*"}));
    }

    @Test
    public void test7231_5_3_4_example1() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("compress, gzip");
        values.addValue("");
        values.addValue("*");
        values.addValue("compress;q=0.5, gzip;q=1.0");
        values.addValue("gzip;q=1.0, identity; q=0.5, *;q=0");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"compress", "gzip", "*", "gzip", "gzip", "compress", "identity"}));
    }

    @Test
    public void testOWS() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("  value 0.5  ;  p = v  ;  q =0.5  ,  value 1.0 ");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 1.0", "value 0.5;p=v"}));
    }

    @Test
    public void testEmpty() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue(",aaaa,  , bbbb ,,cccc,");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"aaaa", "bbbb", "cccc"}));
    }

    @Test
    public void testQuoted() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("  value 0.5  ;  p = \"v  ;  q = \\\"0.5\\\"  ,  value 1.0 \"  ");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 0.5;p=\"v  ;  q = \\\"0.5\\\"  ,  value 1.0 \""}));
    }

    @Test
    public void testOpenQuote() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("value;p=\"v");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value;p=\"v"}));
    }

    @Test
    public void testQuotedQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("  value 0.5  ;  p = v  ;  q = \"0.5\"  ,  value 1.0 ");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value 1.0", "value 0.5;p=v"}));
    }

    @Test
    public void testBadQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("value0.5;p=v;q=0.5,value1.0,valueBad;q=X");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"value1.0", "value0.5;p=v"}));
    }

    @Test
    public void testBad() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue(null);
        values.addValue("");
        values.addValue(";");
        values.addValue("=");
        values.addValue(",");
        values.addValue(";;");
        values.addValue(";=");
        values.addValue(";,");
        values.addValue("=;");
        values.addValue("==");
        values.addValue("=,");
        values.addValue(",;");
        values.addValue(",=");
        values.addValue(",,");
        values.addValue(";;;");
        values.addValue(";;=");
        values.addValue(";;,");
        values.addValue(";=;");
        values.addValue(";==");
        values.addValue(";=,");
        values.addValue(";,;");
        values.addValue(";,=");
        values.addValue(";,,");
        values.addValue("=;;");
        values.addValue("=;=");
        values.addValue("=;,");
        values.addValue("==;");
        values.addValue("===");
        values.addValue("==,");
        values.addValue("=,;");
        values.addValue("=,=");
        values.addValue("=,,");
        values.addValue(",;;");
        values.addValue(",;=");
        values.addValue(",;,");
        values.addValue(",=;");
        values.addValue(",==");
        values.addValue(",=,");
        values.addValue(",,;");
        values.addValue(",,=");
        values.addValue(",,,");
        values.addValue("x;=1");
        values.addValue("=1");
        values.addValue("q=x");
        values.addValue("q=0");
        values.addValue("q=");
        values.addValue("q=,");
        values.addValue("q=;");
    }

    @Test
    public void testFirefoxContentEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip, deflate, br");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"br", "gzip", "deflate"}));
    }

    @Test
    public void testFirefoxContentEncodingWithGzipPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferGzip);
        values.addValue("gzip, deflate, br");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"gzip", "br", "deflate"}));
    }

    @Test
    public void testFirefoxContentEncodingWithNoPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(noFormats);
        values.addValue("gzip, deflate, br");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"gzip", "deflate", "br"}));
    }

    @Test
    public void testChromeContentEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip, deflate, sdch, br");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"br", "gzip", "deflate", "sdch"}));
    }

    @Test
    public void testComplexEncodingWithGzipPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferGzip);
        values.addValue("gzip;q=0.9, identity;q=0.1, *;q=0.01, deflate;q=0.9, sdch;q=0.7, br;q=0.9");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"gzip", "br", "deflate", "sdch", "identity", "*"}));
    }

    @Test
    public void testComplexEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip;q=0.9, identity;q=0.1, *;q=0, deflate;q=0.9, sdch;q=0.7, br;q=0.99");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"br", "gzip", "deflate", "sdch", "identity"}));
    }

    @Test
    public void testStarEncodingWithGzipPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferGzip);
        values.addValue("br, *");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"*", "br"}));
    }

    @Test
    public void testStarEncodingWithBrotliPreference() {
        QuotedQualityCSV values = new QuotedQualityCSV(preferBrotli);
        values.addValue("gzip, *");
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"*", "gzip"}));
    }

    @Test
    public void testSameQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("one;q=0.5,two;q=0.5,three;q=0.5");
        MatcherAssert.assertThat((Object)values.getValues(), (Matcher)Matchers.contains((Object[])new String[]{"one", "two", "three"}));
    }

    @Test
    public void testNoQuality() {
        QuotedQualityCSV values = new QuotedQualityCSV();
        values.addValue("one,two;,three;x=y");
        MatcherAssert.assertThat((Object)values.getValues(), (Matcher)Matchers.contains((Object[])new String[]{"one", "two", "three;x=y"}));
    }

    @Test
    public void testQuality() {
        final ArrayList results = new ArrayList();
        QuotedQualityCSV values = new QuotedQualityCSV(){

            protected void parsedValue(StringBuffer buffer) {
                results.add("parsedValue: " + buffer.toString());
                super.parsedValue(buffer);
            }

            protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
                String param = buffer.substring(paramName, buffer.length());
                results.add("parsedParam: " + param);
                super.parsedParam(buffer, valueLength, paramName, paramValue);
            }
        };
        values.addValue("p=0.5,q=0.5");
        MatcherAssert.assertThat(results, (Matcher)Matchers.contains((Object[])new String[]{"parsedValue: ", "parsedParam: p=0.5", "parsedValue: ", "parsedParam: q=0.5"}));
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.contains((Object[])new String[]{"p=0.5", ""}));
    }
}

