/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpFieldTest {
    @Test
    public void testContainsSimple() {
        HttpField field = new HttpField("name", "SomeValue");
        Assertions.assertTrue((boolean)field.contains("somevalue"));
        Assertions.assertTrue((boolean)field.contains("sOmEvAlUe"));
        Assertions.assertTrue((boolean)field.contains("SomeValue"));
        Assertions.assertFalse((boolean)field.contains("other"));
        Assertions.assertFalse((boolean)field.contains("some"));
        Assertions.assertFalse((boolean)field.contains("Some"));
        Assertions.assertFalse((boolean)field.contains("value"));
        Assertions.assertFalse((boolean)field.contains("v"));
        Assertions.assertFalse((boolean)field.contains(""));
        Assertions.assertFalse((boolean)field.contains(null));
    }

    @Test
    public void testCaseInsensitiveHashcodeKnownField() {
        HttpField fieldFoo1 = new HttpField("Cookie", "foo");
        HttpField fieldFoo2 = new HttpField("cookie", "foo");
        MatcherAssert.assertThat((String)"Field hashcodes are case insensitive", (Object)fieldFoo1.hashCode(), (Matcher)Matchers.is((Object)fieldFoo2.hashCode()));
    }

    @Test
    public void testCaseInsensitiveHashcodeUnknownField() {
        HttpField fieldFoo1 = new HttpField("X-Foo", "bar");
        HttpField fieldFoo2 = new HttpField("x-foo", "bar");
        MatcherAssert.assertThat((String)"Field hashcodes are case insensitive", (Object)fieldFoo1.hashCode(), (Matcher)Matchers.is((Object)fieldFoo2.hashCode()));
    }

    @Test
    public void testContainsList() {
        HttpField field = new HttpField("name", ",aaa,Bbb,CCC, ddd , e e, \"\\\"f,f\\\"\", ");
        Assertions.assertTrue((boolean)field.contains("aaa"));
        Assertions.assertTrue((boolean)field.contains("bbb"));
        Assertions.assertTrue((boolean)field.contains("ccc"));
        Assertions.assertTrue((boolean)field.contains("Aaa"));
        Assertions.assertTrue((boolean)field.contains("Bbb"));
        Assertions.assertTrue((boolean)field.contains("Ccc"));
        Assertions.assertTrue((boolean)field.contains("AAA"));
        Assertions.assertTrue((boolean)field.contains("BBB"));
        Assertions.assertTrue((boolean)field.contains("CCC"));
        Assertions.assertTrue((boolean)field.contains("ddd"));
        Assertions.assertTrue((boolean)field.contains("e e"));
        Assertions.assertTrue((boolean)field.contains("\"f,f\""));
        Assertions.assertFalse((boolean)field.contains(""));
        Assertions.assertFalse((boolean)field.contains("aa"));
        Assertions.assertFalse((boolean)field.contains("bb"));
        Assertions.assertFalse((boolean)field.contains("cc"));
        Assertions.assertFalse((boolean)field.contains(null));
    }

    @Test
    public void testQualityContainsList() {
        HttpField field = new HttpField("name", "yes");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", ",yes,");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,yes,other");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  yes  ,other");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  y s  ,other");
        Assertions.assertTrue((boolean)field.contains("y s"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  \"yes\"  ,other");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "other,  \"\\\"yes\\\"\"  ,other");
        Assertions.assertTrue((boolean)field.contains("\"yes\""));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", ";no,yes,;no");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "no;q=0,yes;q=1,no; q = 0");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "no;q=0.0000,yes;q=0.0001,no; q = 0.00000");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
        field = new HttpField("name", "no;q=0.0000,Yes;Q=0.0001,no; Q = 0.00000");
        Assertions.assertTrue((boolean)field.contains("yes"));
        Assertions.assertFalse((boolean)field.contains("no"));
    }

    @Test
    public void testValues() {
        String[] values = new HttpField("name", "value").getValues();
        Assertions.assertEquals((int)1, (int)values.length);
        Assertions.assertEquals((Object)"value", (Object)values[0]);
        values = new HttpField("name", "a,b,c").getValues();
        Assertions.assertEquals((int)3, (int)values.length);
        Assertions.assertEquals((Object)"a", (Object)values[0]);
        Assertions.assertEquals((Object)"b", (Object)values[1]);
        Assertions.assertEquals((Object)"c", (Object)values[2]);
        values = new HttpField("name", "a,\"x,y,z\",c").getValues();
        Assertions.assertEquals((int)3, (int)values.length);
        Assertions.assertEquals((Object)"a", (Object)values[0]);
        Assertions.assertEquals((Object)"x,y,z", (Object)values[1]);
        Assertions.assertEquals((Object)"c", (Object)values[2]);
        values = new HttpField("name", "a,\"x,\\\"p,q\\\",z\",c").getValues();
        Assertions.assertEquals((int)3, (int)values.length);
        Assertions.assertEquals((Object)"a", (Object)values[0]);
        Assertions.assertEquals((Object)"x,\"p,q\",z", (Object)values[1]);
        Assertions.assertEquals((Object)"c", (Object)values[2]);
    }

    @Test
    public void testCachedField() {
        PreEncodedHttpField field = new PreEncodedHttpField(HttpHeader.ACCEPT, "something");
        ByteBuffer buf = BufferUtil.allocate((int)256);
        BufferUtil.clearToFill((ByteBuffer)buf);
        field.putTo(buf, HttpVersion.HTTP_1_0);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        String s = BufferUtil.toString((ByteBuffer)buf);
        Assertions.assertEquals((Object)"Accept: something\r\n", (Object)s);
    }

    @Test
    public void testCachedFieldWithHeaderName() {
        PreEncodedHttpField field = new PreEncodedHttpField("X-My-Custom-Header", "something");
        Assertions.assertNull((Object)field.getHeader());
        Assertions.assertEquals((Object)"X-My-Custom-Header", (Object)field.getName());
        Assertions.assertEquals((Object)"something", (Object)field.getValue());
    }
}

