/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.MultiMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpURITest {
    @Test
    public void testInvalidAddress() throws Exception {
        this.assertInvalidURI("http://[ffff::1:8080/", "Invalid URL; no closing ']' -- should throw exception");
        this.assertInvalidURI("**", "only '*', not '**'");
        this.assertInvalidURI("*/", "only '*', not '*/'");
    }

    private void assertInvalidURI(String invalidURI, String message) {
        HttpURI uri = new HttpURI();
        try {
            uri.parse(invalidURI);
            Assertions.fail((String)message);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testParse() {
        HttpURI uri = new HttpURI();
        uri.parse("*");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"*"));
        uri.parse("/foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/foo/bar"));
        uri.parse("//foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
        uri.parse("http://foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
    }

    @Test
    public void testParseRequestTarget() {
        HttpURI uri = new HttpURI();
        uri.parseRequestTarget("GET", "*");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"*"));
        uri.parseRequestTarget("GET", "/foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/foo/bar"));
        uri.parseRequestTarget("GET", "//foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"//foo/bar"));
        uri.parseRequestTarget("GET", "http://foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
    }

    @Test
    public void testExtB() throws Exception {
        for (String value : new String[]{"a", "abcdABCD", "\u00c0", "\u697c", "\ud869\uded5", "\ud840\udc08"}) {
            HttpURI uri = new HttpURI("/path?value=" + URLEncoder.encode(value, "UTF-8"));
            MultiMap parameters = new MultiMap();
            uri.decodeQueryTo(parameters, StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)value, (Object)parameters.getString("value"));
        }
    }

    @Test
    public void testAt() throws Exception {
        HttpURI uri = new HttpURI("/@foo/bar");
        Assertions.assertEquals((Object)"/@foo/bar", (Object)uri.getPath());
    }

    @Test
    public void testParams() throws Exception {
        HttpURI uri = new HttpURI("/foo/bar");
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals(null, (Object)uri.getParam());
        uri = new HttpURI("/foo/bar;jsessionid=12345");
        Assertions.assertEquals((Object)"/foo/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345");
        Assertions.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345?name=value");
        Assertions.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345#target");
        Assertions.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
    }

    @Test
    public void testMutableURI() {
        HttpURI uri = new HttpURI("/foo/bar");
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setScheme("http");
        Assertions.assertEquals((Object)"http:/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setAuthority("host", 0);
        Assertions.assertEquals((Object)"http://host/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setAuthority("host", 8888);
        Assertions.assertEquals((Object)"http://host:8888/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setPathQuery("/f%30%30;p0/bar;p1;p2");
        Assertions.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2", (Object)uri.toString());
        Assertions.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"p2", (Object)uri.getParam());
        Assertions.assertEquals(null, (Object)uri.getQuery());
        uri.setPathQuery("/f%30%30;p0/bar;p1;p2?name=value");
        Assertions.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2?name=value", (Object)uri.toString());
        Assertions.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"p2", (Object)uri.getParam());
        Assertions.assertEquals((Object)"name=value", (Object)uri.getQuery());
        uri.setQuery("other=123456");
        Assertions.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2?other=123456", (Object)uri.toString());
        Assertions.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"p2", (Object)uri.getParam());
        Assertions.assertEquals((Object)"other=123456", (Object)uri.getQuery());
    }

    @Test
    public void testSchemeAndOrAuthority() throws Exception {
        HttpURI uri = new HttpURI("/path/info");
        Assertions.assertEquals((Object)"/path/info", (Object)uri.toString());
        uri.setAuthority("host", 0);
        Assertions.assertEquals((Object)"//host/path/info", (Object)uri.toString());
        uri.setAuthority("host", 8888);
        Assertions.assertEquals((Object)"//host:8888/path/info", (Object)uri.toString());
        uri.setScheme("http");
        Assertions.assertEquals((Object)"http://host:8888/path/info", (Object)uri.toString());
        uri.setAuthority(null, 0);
        Assertions.assertEquals((Object)"http:/path/info", (Object)uri.toString());
    }

    @Test
    public void testBasicAuthCredentials() throws Exception {
        HttpURI uri = new HttpURI("http://user:password@example.com:8888/blah");
        Assertions.assertEquals((Object)"http://user:password@example.com:8888/blah", (Object)uri.toString());
        Assertions.assertEquals((Object)uri.getAuthority(), (Object)"example.com:8888");
        Assertions.assertEquals((Object)uri.getUser(), (Object)"user:password");
    }
}

