/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.MultiMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpURITest {
    @Test
    public void testInvalidAddress() throws Exception {
        this.assertInvalidURI("http://[ffff::1:8080/", "Invalid URL; no closing ']' -- should throw exception");
        this.assertInvalidURI("**", "only '*', not '**'");
        this.assertInvalidURI("*/", "only '*', not '*/'");
    }

    private void assertInvalidURI(String invalidURI, String message) {
        HttpURI uri = new HttpURI();
        try {
            uri.parse(invalidURI);
            Assertions.fail((String)message);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testParse() {
        HttpURI uri = new HttpURI();
        uri.parse("*");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"*"));
        uri.parse("/foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/foo/bar"));
        uri.parse("//foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
        uri.parse("http://foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
    }

    @Test
    public void testParseRequestTarget() {
        HttpURI uri = new HttpURI();
        uri.parseRequestTarget("GET", "*");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"*"));
        uri.parseRequestTarget("GET", "/foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/foo/bar"));
        uri.parseRequestTarget("GET", "//foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"//foo/bar"));
        uri.parseRequestTarget("GET", "http://foo/bar");
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/bar"));
    }

    @Test
    public void testExtB() throws Exception {
        for (String value : new String[]{"a", "abcdABCD", "\u00c0", "\u697c", "\ud869\uded5", "\ud840\udc08"}) {
            HttpURI uri = new HttpURI("/path?value=" + URLEncoder.encode(value, "UTF-8"));
            MultiMap parameters = new MultiMap();
            uri.decodeQueryTo(parameters, StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)value, (Object)parameters.getString("value"));
        }
    }

    @Test
    public void testAt() throws Exception {
        HttpURI uri = new HttpURI("/@foo/bar");
        Assertions.assertEquals((Object)"/@foo/bar", (Object)uri.getPath());
    }

    @Test
    public void testParams() throws Exception {
        HttpURI uri = new HttpURI("/foo/bar");
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals(null, (Object)uri.getParam());
        uri = new HttpURI("/foo/bar;jsessionid=12345");
        Assertions.assertEquals((Object)"/foo/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345");
        Assertions.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345?name=value");
        Assertions.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
        uri = new HttpURI("/foo;abc=123/bar;jsessionid=12345#target");
        Assertions.assertEquals((Object)"/foo;abc=123/bar;jsessionid=12345", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"jsessionid=12345", (Object)uri.getParam());
    }

    @Test
    public void testMutableURI() {
        HttpURI uri = new HttpURI("/foo/bar");
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setScheme("http");
        Assertions.assertEquals((Object)"http:/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setAuthority("host", 0);
        Assertions.assertEquals((Object)"http://host/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setAuthority("host", 8888);
        Assertions.assertEquals((Object)"http://host:8888/foo/bar", (Object)uri.toString());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/foo/bar", (Object)uri.getDecodedPath());
        uri.setPathQuery("/f%30%30;p0/bar;p1;p2");
        Assertions.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2", (Object)uri.toString());
        Assertions.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"p2", (Object)uri.getParam());
        Assertions.assertEquals(null, (Object)uri.getQuery());
        uri.setPathQuery("/f%30%30;p0/bar;p1;p2?name=value");
        Assertions.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2?name=value", (Object)uri.toString());
        Assertions.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"p2", (Object)uri.getParam());
        Assertions.assertEquals((Object)"name=value", (Object)uri.getQuery());
        uri.setQuery("other=123456");
        Assertions.assertEquals((Object)"http://host:8888/f%30%30;p0/bar;p1;p2?other=123456", (Object)uri.toString());
        Assertions.assertEquals((Object)"/f%30%30;p0/bar;p1;p2", (Object)uri.getPath());
        Assertions.assertEquals((Object)"/f00/bar", (Object)uri.getDecodedPath());
        Assertions.assertEquals((Object)"p2", (Object)uri.getParam());
        Assertions.assertEquals((Object)"other=123456", (Object)uri.getQuery());
    }

    @Test
    public void testSchemeAndOrAuthority() throws Exception {
        HttpURI uri = new HttpURI("/path/info");
        Assertions.assertEquals((Object)"/path/info", (Object)uri.toString());
        uri.setAuthority("host", 0);
        Assertions.assertEquals((Object)"//host/path/info", (Object)uri.toString());
        uri.setAuthority("host", 8888);
        Assertions.assertEquals((Object)"//host:8888/path/info", (Object)uri.toString());
        uri.setScheme("http");
        Assertions.assertEquals((Object)"http://host:8888/path/info", (Object)uri.toString());
        uri.setAuthority(null, 0);
        Assertions.assertEquals((Object)"http:/path/info", (Object)uri.toString());
    }

    @Test
    public void testSetters() throws Exception {
        HttpURI uri = new HttpURI();
        Assertions.assertEquals((Object)"", (Object)uri.toString());
        uri = new HttpURI(null, null, 0, null, null, null, null);
        Assertions.assertEquals((Object)"", (Object)uri.toString());
        uri.setPath("/path/info");
        Assertions.assertEquals((Object)"/path/info", (Object)uri.toString());
        uri.setAuthority("host", 8080);
        Assertions.assertEquals((Object)"//host:8080/path/info", (Object)uri.toString());
        uri.setParam("param");
        Assertions.assertEquals((Object)"//host:8080/path/info;param", (Object)uri.toString());
        uri.setQuery("a=b");
        Assertions.assertEquals((Object)"//host:8080/path/info;param?a=b", (Object)uri.toString());
        uri.setScheme("http");
        Assertions.assertEquals((Object)"http://host:8080/path/info;param?a=b", (Object)uri.toString());
        uri.setPathQuery("/other;xxx/path;ppp?query");
        Assertions.assertEquals((Object)"http://host:8080/other;xxx/path;ppp?query", (Object)uri.toString());
        MatcherAssert.assertThat((Object)uri.getScheme(), (Matcher)Matchers.is((Object)"http"));
        MatcherAssert.assertThat((Object)uri.getAuthority(), (Matcher)Matchers.is((Object)"host:8080"));
        MatcherAssert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"host"));
        MatcherAssert.assertThat((Object)uri.getPort(), (Matcher)Matchers.is((Object)8080));
        MatcherAssert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/other;xxx/path;ppp"));
        MatcherAssert.assertThat((Object)uri.getDecodedPath(), (Matcher)Matchers.is((Object)"/other/path"));
        MatcherAssert.assertThat((Object)uri.getParam(), (Matcher)Matchers.is((Object)"ppp"));
        MatcherAssert.assertThat((Object)uri.getQuery(), (Matcher)Matchers.is((Object)"query"));
        MatcherAssert.assertThat((Object)uri.getPathQuery(), (Matcher)Matchers.is((Object)"/other;xxx/path;ppp?query"));
        uri.setPathQuery(null);
        Assertions.assertEquals((Object)"http://host:8080?query", (Object)uri.toString());
        uri.setQuery(null);
        Assertions.assertEquals((Object)"http://host:8080", (Object)uri.toString());
        uri.setPathQuery("/other;xxx/path;ppp?query");
        Assertions.assertEquals((Object)"http://host:8080/other;xxx/path;ppp?query", (Object)uri.toString());
        uri.setScheme(null);
        Assertions.assertEquals((Object)"//host:8080/other;xxx/path;ppp?query", (Object)uri.toString());
        uri.setAuthority(null, -1);
        Assertions.assertEquals((Object)"/other;xxx/path;ppp?query", (Object)uri.toString());
        uri.setParam(null);
        Assertions.assertEquals((Object)"/other;xxx/path?query", (Object)uri.toString());
        uri.setQuery(null);
        Assertions.assertEquals((Object)"/other;xxx/path", (Object)uri.toString());
        uri.setPath(null);
        Assertions.assertEquals((Object)"", (Object)uri.toString());
    }

    public static Stream<Arguments> decodePathTests() {
        return Arrays.stream(new Object[][]{{"http://host/path/info", "/path/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"//host/path/info", "/path/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"/path/info", "/path/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"http://host/../path/info", null, EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"http://host/path/../info", "/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"http://host/path/./info", "/path/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"//host/path/../info", "/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"//host/path/./info", "/path/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"/path/../info", "/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"/path/./info", "/path/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"path/../info", "info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"path/./info", "path/info", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"//host/../path/info", null, EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"/../path/info", null, EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"../path/info", null, EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"/path/%XX/info", null, EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"/path/%2/F/info", null, EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"scheme://host/path/%2e/info", "/path/./info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"scheme:/path/%2e/info", "/path/./info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"/path/%2e/info", "/path/./info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"path/%2e/info/", "path/./info/", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"/path/%2e%2e/info", "/path/../info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"/path/%2e%2e;/info", "/path/../info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"/path/%2e%2e;param/info", "/path/../info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"/path/%2e%2e;param;other/info;other", "/path/../info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"%2e/info", "./info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"%2e%2e/info", "../info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"%2e%2e;/info", "../info", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"%2e", ".", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"%2e.", "..", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {".%2e", "..", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"%2e%2e", "..", EnumSet.of(HttpURI.Ambiguous.SEGMENT)}, {"/path/.;/info", "/path/./info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {"/path/.;param/info", "/path/./info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {"/path/..;/info", "/path/../info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {"/path/..;param/info", "/path/../info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {".;/info", "./info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {".;param/info", "./info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {"..;/info", "../info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {"..;param/info", "../info", EnumSet.of(HttpURI.Ambiguous.PARAM)}, {"/path/%2f/info", "/path///info", EnumSet.of(HttpURI.Ambiguous.SEPARATOR)}, {"%2f/info", "//info", EnumSet.of(HttpURI.Ambiguous.SEPARATOR)}, {"%2F/info", "//info", EnumSet.of(HttpURI.Ambiguous.SEPARATOR)}, {"/path/%2f../info", "/path//../info", EnumSet.of(HttpURI.Ambiguous.SEPARATOR)}, {"/path/%2f/..;/info", "/path///../info", EnumSet.of(HttpURI.Ambiguous.SEPARATOR, HttpURI.Ambiguous.PARAM)}, {"/path/%2f/..;/%2e/info", "/path///.././info", EnumSet.of(HttpURI.Ambiguous.SEPARATOR, HttpURI.Ambiguous.PARAM, HttpURI.Ambiguous.SEGMENT)}, {"http://localhost:9000/x\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32", "/x\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32", EnumSet.noneOf(HttpURI.Ambiguous.class)}, {"http://localhost:9000/\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32", "/\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32\ud83c\udf32", EnumSet.noneOf(HttpURI.Ambiguous.class)}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"decodePathTests"})
    public void testDecodedPath(String input, String decodedPath, EnumSet<HttpURI.Ambiguous> expected) {
        try {
            HttpURI uri = new HttpURI(input);
            MatcherAssert.assertThat((Object)uri.getDecodedPath(), (Matcher)Matchers.is((Object)decodedPath));
            MatcherAssert.assertThat((Object)uri.isAmbiguous(), (Matcher)Matchers.is((Object)(!expected.isEmpty() ? 1 : 0)));
            MatcherAssert.assertThat((Object)uri.hasAmbiguousSegment(), (Matcher)Matchers.is((Object)expected.contains(HttpURI.Ambiguous.SEGMENT)));
            MatcherAssert.assertThat((Object)uri.hasAmbiguousSeparator(), (Matcher)Matchers.is((Object)expected.contains(HttpURI.Ambiguous.SEPARATOR)));
            MatcherAssert.assertThat((Object)uri.hasAmbiguousParameter(), (Matcher)Matchers.is((Object)expected.contains(HttpURI.Ambiguous.PARAM)));
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)decodedPath, (Matcher)Matchers.nullValue());
        }
    }
}

