/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.MimeTypes;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MimeTypesTest {
    @Test
    public void testGetMimeByExtensionGzip() {
        this.assertMimeTypeByExtension("application/gzip", "test.gz");
    }

    @Test
    public void testGetMimeByExtensionPng() {
        this.assertMimeTypeByExtension("image/png", "test.png");
        this.assertMimeTypeByExtension("image/png", "TEST.PNG");
        this.assertMimeTypeByExtension("image/png", "Test.Png");
    }

    @Test
    public void testGetMimeByExtensionPngMultiDot() {
        this.assertMimeTypeByExtension("image/png", "org.eclipse.jetty.Logo.png");
    }

    @Test
    public void testGetMimeByExtensionPngDeepPath() {
        this.assertMimeTypeByExtension("image/png", "/org/eclipse/jetty/Logo.png");
    }

    @Test
    public void testGetMimeByExtensionText() {
        this.assertMimeTypeByExtension("text/plain", "test.txt");
        this.assertMimeTypeByExtension("text/plain", "TEST.TXT");
    }

    @Test
    public void testGetMimeByExtensionNoExtension() {
        MimeTypes mimetypes = new MimeTypes();
        String contentType = mimetypes.getMimeByExtension("README");
        Assertions.assertNull((Object)contentType);
    }

    private void assertMimeTypeByExtension(String expectedMimeType, String filename) {
        MimeTypes mimetypes = new MimeTypes();
        String contentType = mimetypes.getMimeByExtension(filename);
        String prefix = "MimeTypes.getMimeByExtension(" + filename + ")";
        Assertions.assertNotNull((Object)contentType, (String)prefix);
        Assertions.assertEquals((Object)expectedMimeType, (Object)contentType, (String)prefix);
    }

    private void assertCharsetFromContentType(String contentType, String expectedCharset) {
        MatcherAssert.assertThat((String)("getCharsetFromContentType(\"" + contentType + "\")"), (Object)MimeTypes.getCharsetFromContentType((String)contentType), (Matcher)Matchers.is((Object)expectedCharset));
    }

    @Test
    public void testCharsetFromContentType() {
        this.assertCharsetFromContentType("foo/bar;charset=abc;some=else", "abc");
        this.assertCharsetFromContentType("foo/bar;charset=abc", "abc");
        this.assertCharsetFromContentType("foo/bar ; charset = abc", "abc");
        this.assertCharsetFromContentType("foo/bar ; charset = abc ; some=else", "abc");
        this.assertCharsetFromContentType("foo/bar;other=param;charset=abc;some=else", "abc");
        this.assertCharsetFromContentType("foo/bar;other=param;charset=abc", "abc");
        this.assertCharsetFromContentType("foo/bar other = param ; charset = abc", "abc");
        this.assertCharsetFromContentType("foo/bar other = param ; charset = abc ; some=else", "abc");
        this.assertCharsetFromContentType("foo/bar other = param ; charset = abc", "abc");
        this.assertCharsetFromContentType("foo/bar other = param ; charset = \"abc\" ; some=else", "abc");
        this.assertCharsetFromContentType("foo/bar", null);
        this.assertCharsetFromContentType("foo/bar;charset=uTf8", "utf-8");
        this.assertCharsetFromContentType("foo/bar;other=\"charset=abc\";charset=uTf8", "utf-8");
        this.assertCharsetFromContentType("application/pdf; charset=UTF-8", "utf-8");
        this.assertCharsetFromContentType("application/pdf;; charset=UTF-8", "utf-8");
        this.assertCharsetFromContentType("application/pdf;;; charset=UTF-8", "utf-8");
        this.assertCharsetFromContentType("application/pdf;;;; charset=UTF-8", "utf-8");
        this.assertCharsetFromContentType("text/html;charset=utf-8", "utf-8");
    }

    @Test
    public void testContentTypeWithoutCharset() {
        Assertions.assertEquals((Object)"foo/bar;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;charset=abc;some=else"));
        Assertions.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;charset=abc"));
        Assertions.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; charset = abc"));
        Assertions.assertEquals((Object)"foo/bar;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; charset = abc ; some=else"));
        Assertions.assertEquals((Object)"foo/bar;other=param;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;other=param;charset=abc;some=else"));
        Assertions.assertEquals((Object)"foo/bar;other=param", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;other=param;charset=abc"));
        Assertions.assertEquals((Object)"foo/bar ; other = param", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = abc"));
        Assertions.assertEquals((Object)"foo/bar ; other = param;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = abc ; some=else"));
        Assertions.assertEquals((Object)"foo/bar ; other = param", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = abc"));
        Assertions.assertEquals((Object)"foo/bar ; other = param;some=else", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar ; other = param ; charset = \"abc\" ; some=else"));
        Assertions.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar"));
        Assertions.assertEquals((Object)"foo/bar", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;charset=uTf8"));
        Assertions.assertEquals((Object)"foo/bar;other=\"charset=abc\"", (Object)MimeTypes.getContentTypeWithoutCharset((String)"foo/bar;other=\"charset=abc\";charset=uTf8"));
        Assertions.assertEquals((Object)"text/html", (Object)MimeTypes.getContentTypeWithoutCharset((String)"text/html;charset=utf-8"));
    }
}

