/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.util.stream.Stream;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class UriTemplatePathSpecBadSpecsTest {
    public static Stream<Arguments> data() {
        String[] badSpecs = new String[]{"/a/b{var}", "a/{var}", "/a/{var/b}", "/{var}/*", "/{var}.do", "/a/{var*}", "/a/{}", "{var}", "/a/{my special variable}", "/a/{var}/{var}", "/a/../../../{var}", "/a/./{var}", "/a//{var}"};
        return Stream.of(badSpecs).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"data"})
    public void testBadPathSpec(String pathSpec) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new UriTemplatePathSpec(pathSpec));
    }
}

