/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpScheme;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpSchemeTest {
    @Test
    public void testIsReturningTrue() {
        HttpScheme httpScheme = HttpScheme.HTTPS;
        Assertions.assertTrue((boolean)httpScheme.is("https"));
        Assertions.assertEquals((Object)"https", (Object)httpScheme.asString());
        Assertions.assertEquals((Object)"https", (Object)httpScheme.toString());
    }

    @Test
    public void testIsReturningFalse() {
        HttpScheme httpScheme = HttpScheme.HTTP;
        Assertions.assertFalse((boolean)httpScheme.is(",CPL@@4'U4p"));
    }

    @Test
    public void testIsWithNull() {
        HttpScheme httpScheme = HttpScheme.HTTPS;
        Assertions.assertFalse((boolean)httpScheme.is(null));
    }

    @Test
    public void testAsByteBuffer() {
        HttpScheme httpScheme = HttpScheme.WS;
        ByteBuffer byteBuffer = httpScheme.asByteBuffer();
        Assertions.assertEquals((Object)"ws", (Object)httpScheme.asString());
        Assertions.assertEquals((Object)"ws", (Object)httpScheme.toString());
        Assertions.assertEquals((int)2, (int)byteBuffer.capacity());
        Assertions.assertEquals((int)2, (int)byteBuffer.remaining());
        Assertions.assertEquals((int)2, (int)byteBuffer.limit());
        Assertions.assertFalse((boolean)byteBuffer.hasArray());
        Assertions.assertEquals((int)0, (int)byteBuffer.position());
        Assertions.assertTrue((boolean)byteBuffer.isReadOnly());
        Assertions.assertFalse((boolean)byteBuffer.isDirect());
        Assertions.assertTrue((boolean)byteBuffer.hasRemaining());
    }
}

