/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecAssert;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathMappingsTest {
    private void assertMatch(PathMappings<String> pathmap, String path, String expectedValue) {
        String msg = String.format(".getMatched(\"%s\")", path);
        MatchedResource matched = pathmap.getMatched(path);
        MatcherAssert.assertThat((String)msg, (Object)matched, (Matcher)Matchers.notNullValue());
        String actualMatch = (String)matched.getResource();
        Assertions.assertEquals((Object)expectedValue, (Object)actualMatch, (String)msg);
    }

    @Test
    public void testMixedMatchOrder() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec(""), (Object)"root");
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        p.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        p.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        p.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        p.put((PathSpec)new RegexPathSpec("^/animal/.*/chat$"), (Object)"animalChat");
        p.put((PathSpec)new RegexPathSpec("^/animal/.*/cam$"), (Object)"animalCam");
        p.put((PathSpec)new RegexPathSpec("^/entrance/cam$"), (Object)"entranceCam");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle", "birds");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/bass/sea", "fishes");
        this.assertMatch((PathMappings<String>)p, "/animal/peccary/javalina/evolution", "animals");
        this.assertMatch((PathMappings<String>)p, "/", "root");
        this.assertMatch((PathMappings<String>)p, "/other", "default");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/penguin/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/trout/cam", "animalCam");
        this.assertMatch((PathMappings<String>)p, "/entrance/cam", "entranceCam");
    }

    @Test
    public void testServletMatchDefault() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        p.put((PathSpec)new ServletPathSpec("/*"), (Object)"any");
        this.assertMatch((PathMappings<String>)p, "/abs/path", "any");
        this.assertMatch((PathMappings<String>)p, "/abs/path/xxx", "any");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle/bald", "any");
        this.assertMatch((PathMappings<String>)p, "/", "any");
    }

    @Test
    public void testMixedMatchUriOrder() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        p.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"birds");
        p.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"fishes");
        p.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"animals");
        p.put((PathSpec)new UriTemplatePathSpec("/animal/{type}/{name}/chat"), (Object)"animalChat");
        p.put((PathSpec)new UriTemplatePathSpec("/animal/{type}/{name}/cam"), (Object)"animalCam");
        p.put((PathSpec)new UriTemplatePathSpec("/entrance/cam"), (Object)"entranceCam");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle", "birds");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/bass/sea", "fishes");
        this.assertMatch((PathMappings<String>)p, "/animal/peccary/javalina/evolution", "animals");
        this.assertMatch((PathMappings<String>)p, "/", "default");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/eagle/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/bird/penguin/chat", "animalChat");
        this.assertMatch((PathMappings<String>)p, "/animal/fish/trout/cam", "animalCam");
        this.assertMatch((PathMappings<String>)p, "/entrance/cam", "entranceCam");
    }

    @Test
    public void testUriTemplateMatchOrder() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new UriTemplatePathSpec("/a/{var}/c"), (Object)"endpointA");
        p.put((PathSpec)new UriTemplatePathSpec("/a/b/c"), (Object)"endpointB");
        p.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/{var2}"), (Object)"endpointC");
        p.put((PathSpec)new UriTemplatePathSpec("/{var1}/d"), (Object)"endpointD");
        p.put((PathSpec)new UriTemplatePathSpec("/b/{var2}"), (Object)"endpointE");
        this.assertMatch((PathMappings<String>)p, "/a/b/c", "endpointB");
        this.assertMatch((PathMappings<String>)p, "/a/d/c", "endpointA");
        this.assertMatch((PathMappings<String>)p, "/a/x/y", "endpointC");
        this.assertMatch((PathMappings<String>)p, "/b/d", "endpointE");
    }

    @Test
    public void testServletAndRegexMatchOrder() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/a/*"), (Object)"endpointA");
        p.put((PathSpec)new RegexPathSpec("^.*/middle/.*$"), (Object)"middle");
        p.put((PathSpec)new ServletPathSpec("*.do"), (Object)"endpointDo");
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"default");
        this.assertMatch((PathMappings<String>)p, "/a/b/c", "endpointA");
        this.assertMatch((PathMappings<String>)p, "/a/middle/c", "endpointA");
        this.assertMatch((PathMappings<String>)p, "/b/middle/c", "middle");
        this.assertMatch((PathMappings<String>)p, "/x/y.do", "endpointDo");
        this.assertMatch((PathMappings<String>)p, "/b/d", "default");
    }

    @Test
    public void testPathMap() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/abs/path"), (Object)"1");
        p.put((PathSpec)new ServletPathSpec("/abs/path/longer"), (Object)"2");
        p.put((PathSpec)new ServletPathSpec("/animal/bird/*"), (Object)"3");
        p.put((PathSpec)new ServletPathSpec("/animal/fish/*"), (Object)"4");
        p.put((PathSpec)new ServletPathSpec("/animal/*"), (Object)"5");
        p.put((PathSpec)new ServletPathSpec("*.tar.gz"), (Object)"6");
        p.put((PathSpec)new ServletPathSpec("*.gz"), (Object)"7");
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"8");
        p.put((PathSpec)new ServletPathSpec(""), (Object)"10");
        p.put((PathSpec)new ServletPathSpec("/\u20acuro/*"), (Object)"11");
        p.put((PathSpec)new ServletPathSpec("/*"), (Object)"0");
        Assertions.assertEquals((Object)"/abs/path", (Object)p.getMatched("/abs/path").getPathSpec().getDeclaration(), (String)"Match absolute path");
        Assertions.assertEquals((Object)"1", (Object)p.getMatched("/abs/path").getResource(), (String)"Match absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatched("/abs/path/xxx").getResource(), (String)"Mismatch absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatched("/abs/pith").getResource(), (String)"Mismatch absolute path");
        Assertions.assertEquals((Object)"2", (Object)p.getMatched("/abs/path/longer").getResource(), (String)"Match longer absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatched("/abs/path/").getResource(), (String)"Not exact absolute path");
        Assertions.assertEquals((Object)"0", (Object)p.getMatched("/abs/path/xxx").getResource(), (String)"Not exact absolute path");
        Assertions.assertEquals((Object)"3", (Object)p.getMatched("/animal/bird/eagle/bald").getResource(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"4", (Object)p.getMatched("/animal/fish/shark/grey").getResource(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatched("/animal/insect/bug").getResource(), (String)"Match longest prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatched("/animal").getResource(), (String)"mismatch exact prefix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatched("/animal/").getResource(), (String)"mismatch exact prefix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatched("/suffix/path.tar.gz").getResource(), (String)"Match longest suffix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatched("/suffix/path.gz").getResource(), (String)"Match longest suffix");
        Assertions.assertEquals((Object)"5", (Object)p.getMatched("/animal/path.gz").getResource(), (String)"prefix rather than suffix");
        Assertions.assertEquals((Object)"0", (Object)p.getMatched("/Other/path").getResource(), (String)"default");
        Assertions.assertEquals((Object)"10", (Object)p.getMatched("/").getResource(), (String)"match / with ''");
    }

    @Test
    public void testPathMappingsOnlyMatchOnDirectoryNames() {
        ServletPathSpec spec = new ServletPathSpec("/xyz/*");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/123");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/123/");
        PathSpecAssert.assertMatch((PathSpec)spec, "/xyz/123.txt");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123;jessionid=99");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123/");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz123/456");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz.123");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz;123");
        PathSpecAssert.assertNotMatch((PathSpec)spec, "/xyz?123");
    }

    @Test
    public void testPrecedenceVsOrdering() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/dump/gzip/*"), (Object)"prefix");
        p.put((PathSpec)new ServletPathSpec("*.txt"), (Object)"suffix");
        Assertions.assertNull((Object)p.getMatched("/foo/bar"));
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatched("/dump/gzip/something").getResource());
        Assertions.assertEquals((Object)"suffix", (Object)p.getMatched("/foo/something.txt").getResource());
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatched("/dump/gzip/something.txt").getResource());
        p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("*.txt"), (Object)"suffix");
        p.put((PathSpec)new ServletPathSpec("/dump/gzip/*"), (Object)"prefix");
        Assertions.assertNull((Object)p.getMatched("/foo/bar"));
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatched("/dump/gzip/something").getResource());
        Assertions.assertEquals((Object)"suffix", (Object)p.getMatched("/foo/something.txt").getResource());
        Assertions.assertEquals((Object)"prefix", (Object)p.getMatched("/dump/gzip/something.txt").getResource());
    }

    @Test
    public void testPutRejectsDuplicates() {
        PathMappings p = new PathMappings();
        MatcherAssert.assertThat((Object)p.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/c"), (Object)"resourceA"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.put((PathSpec)new UriTemplatePathSpec("/a/{var2}/c"), (Object)"resourceAA"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.put((PathSpec)new UriTemplatePathSpec("/a/b/c"), (Object)"resourceB"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.put((PathSpec)new UriTemplatePathSpec("/a/b/c"), (Object)"resourceBB"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.put((PathSpec)new ServletPathSpec("/a/b/c"), (Object)"resourceBB"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.put((PathSpec)new RegexPathSpec("/a/b/c"), (Object)"resourceBB"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.put((PathSpec)new ServletPathSpec("/*"), (Object)"resourceC"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.put((PathSpec)new RegexPathSpec("/(.*)"), (Object)"resourceCC"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetUriTemplatePathSpec() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/c"), (Object)"resourceA");
        p.put((PathSpec)new UriTemplatePathSpec("/a/b/c"), (Object)"resourceB");
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new UriTemplatePathSpec("/a/{var1}/c"))), (Matcher)CoreMatchers.equalTo((Object)"resourceA"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new UriTemplatePathSpec("/a/{foo}/c"))), (Matcher)CoreMatchers.equalTo((Object)"resourceA"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new UriTemplatePathSpec("/a/b/c"))), (Matcher)CoreMatchers.equalTo((Object)"resourceB"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new UriTemplatePathSpec("/a/d/c"))), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new RegexPathSpec("/a/b/c"))), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetRegexPathSpec() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new RegexPathSpec("/a/b/c"), (Object)"resourceA");
        p.put((PathSpec)new RegexPathSpec("/(.*)/b/c"), (Object)"resourceB");
        p.put((PathSpec)new RegexPathSpec("/a/(.*)/c"), (Object)"resourceC");
        p.put((PathSpec)new RegexPathSpec("/a/b/(.*)"), (Object)"resourceD");
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new RegexPathSpec("/a/(.*)/c"))), (Matcher)CoreMatchers.equalTo((Object)"resourceC"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new RegexPathSpec("/a/b/c"))), (Matcher)CoreMatchers.equalTo((Object)"resourceA"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new RegexPathSpec("/(.*)/b/c"))), (Matcher)CoreMatchers.equalTo((Object)"resourceB"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new RegexPathSpec("/a/b/(.*)"))), (Matcher)CoreMatchers.equalTo((Object)"resourceD"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new RegexPathSpec("/a/d/c"))), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("/a/b/c"))), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testGetServletPathSpec() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"resourceA");
        p.put((PathSpec)new ServletPathSpec("/*"), (Object)"resourceB");
        p.put((PathSpec)new ServletPathSpec("/a/*"), (Object)"resourceC");
        p.put((PathSpec)new ServletPathSpec("*.do"), (Object)"resourceD");
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("/"))), (Matcher)CoreMatchers.equalTo((Object)"resourceA"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("/*"))), (Matcher)CoreMatchers.equalTo((Object)"resourceB"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("/a/*"))), (Matcher)CoreMatchers.equalTo((Object)"resourceC"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("*.do"))), (Matcher)CoreMatchers.equalTo((Object)"resourceD"));
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("*.gz"))), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("/a/b/*"))), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new ServletPathSpec("/a/d/c"))), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((String)p.get((PathSpec)new RegexPathSpec("/a/b/c"))), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testRemoveUriTemplatePathSpec() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/c"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/{var1}/c")), (Matcher)CoreMatchers.is((Object)true));
        p.put((PathSpec)new UriTemplatePathSpec("/a/{var1}/c"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/{b}/c")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/{b}/c")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new UriTemplatePathSpec("/{var1}/b/c"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/{a}/b/c")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/{a}/b/c")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new UriTemplatePathSpec("/a/b/{var1}"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/b/{c}")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/b/{c}")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new UriTemplatePathSpec("/{var1}/{var2}/{var3}"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/{a}/{b}/{c}")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new UriTemplatePathSpec("/{a}/{b}/{c}")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testRemoveRegexPathSpec() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new RegexPathSpec("/a/(.*)/c"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/(.*)/c")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/(.*)/c")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new RegexPathSpec("/(.*)/b/c"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/(.*)/b/c")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/(.*)/b/c")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new RegexPathSpec("/a/b/(.*)"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/(.*)")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/(.*)")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new RegexPathSpec("/a/b/c"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/d")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new RegexPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testRemoveServletPathSpec() {
        PathMappings p = new PathMappings();
        p.put((PathSpec)new ServletPathSpec("/a/*"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/b")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/*")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/*")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new ServletPathSpec("/a/b/*"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/b/*")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/b/*")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new ServletPathSpec("*.do"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("*.gz")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("*.do")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("*.do")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new ServletPathSpec("/"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new ServletPathSpec(""), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("")), (Matcher)CoreMatchers.is((Object)false));
        p.put((PathSpec)new ServletPathSpec("/a/b/c"), (Object)"resourceA");
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/b/d")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)p.remove((PathSpec)new ServletPathSpec("/a/b/c")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testAsPathSpec() {
        MatcherAssert.assertThat((Object)PathSpec.from((String)""), (Matcher)Matchers.instanceOf(ServletPathSpec.class));
        MatcherAssert.assertThat((Object)PathSpec.from((String)"/"), (Matcher)Matchers.instanceOf(ServletPathSpec.class));
        MatcherAssert.assertThat((Object)PathSpec.from((String)"/*"), (Matcher)Matchers.instanceOf(ServletPathSpec.class));
        MatcherAssert.assertThat((Object)PathSpec.from((String)"/foo/*"), (Matcher)Matchers.instanceOf(ServletPathSpec.class));
        MatcherAssert.assertThat((Object)PathSpec.from((String)"*.jsp"), (Matcher)Matchers.instanceOf(ServletPathSpec.class));
        MatcherAssert.assertThat((Object)PathSpec.from((String)"^$"), (Matcher)Matchers.instanceOf(RegexPathSpec.class));
        MatcherAssert.assertThat((Object)PathSpec.from((String)"^.*"), (Matcher)Matchers.instanceOf(RegexPathSpec.class));
        MatcherAssert.assertThat((Object)PathSpec.from((String)"^/"), (Matcher)Matchers.instanceOf(RegexPathSpec.class));
    }
}

