/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public interface ClientConnectionFactory {
    public static final String CLIENT_CONTEXT_KEY = "org.eclipse.jetty.client";

    public Connection newConnection(EndPoint var1, Map<String, Object> var2) throws IOException;

    default public Connection customize(Connection connection, Map<String, Object> context) {
        ContainerLifeCycle client = (ContainerLifeCycle)context.get(CLIENT_CONTEXT_KEY);
        if (client != null) {
            client.getBeans(Connection.Listener.class).forEach(connection::addListener);
        }
        return connection;
    }

    public static class Info {
        private final List<String> protocols;
        private final ClientConnectionFactory factory;

        public Info(List<String> protocols, ClientConnectionFactory factory) {
            this.protocols = protocols;
            this.factory = factory;
        }

        public List<String> getProtocols() {
            return this.protocols;
        }

        public ClientConnectionFactory getClientConnectionFactory() {
            return this.factory;
        }

        public boolean matches(List<String> candidates) {
            return this.protocols.stream().anyMatch(candidates::contains);
        }
    }
}

