/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class AsyncContent
implements Content.Sink,
Content.Source,
Closeable {
    private static final int UNDETERMINED_LENGTH = -2;
    private final AutoLock.WithCondition lock = new AutoLock.WithCondition();
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final Queue<ChunkCallback> chunks = new ArrayDeque<ChunkCallback>();
    private Content.Chunk.Error errorChunk;
    private boolean readClosed;
    private boolean writeClosed;
    private Runnable demandCallback;
    private long length = -2L;

    @Override
    public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
        this.write(Content.Chunk.from(byteBuffer, last, () -> ((Callback)callback).succeeded()), callback);
    }

    public void write(Content.Chunk chunk, Callback callback) {
        Throwable failure = null;
        boolean wasEmpty = false;
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.writeClosed) {
                failure = new IOException("closed");
            } else if (this.errorChunk != null) {
                failure = this.errorChunk.getCause();
            } else if (chunk instanceof Content.Chunk.Error) {
                Content.Chunk.Error error;
                this.errorChunk = error = (Content.Chunk.Error)chunk;
                failure = this.errorChunk.getCause();
                wasEmpty = this.chunks.isEmpty();
            } else {
                wasEmpty = this.chunks.isEmpty();
                this.chunks.offer(new ChunkCallback(chunk, callback));
                if (chunk.isLast()) {
                    this.writeClosed = true;
                    if (this.length == -2L) {
                        this.length = this.chunks.stream().mapToLong(cc -> cc.chunk().remaining()).sum();
                    }
                }
            }
        }
        if (failure != null) {
            callback.failed(failure);
        }
        if (wasEmpty) {
            this.invoker.run(this::invokeDemandCallback);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws IOException {
        try (AutoLock.WithCondition l = this.lock.lock();){
            while (true) {
                Content.Chunk chunk;
                if (this.errorChunk != null) {
                    throw new IOException(this.errorChunk.getCause());
                }
                if (this.chunks.isEmpty()) {
                    return;
                }
                if (this.writeClosed && this.chunks.size() == 1 && (chunk = this.chunks.peek().chunk()).isLast() && !chunk.hasRemaining()) {
                    return;
                }
                l.await();
                continue;
                break;
            }
        }
    }

    @Override
    public void close() {
        this.write(Content.Chunk.EOF, Callback.NOOP);
    }

    public boolean isClosed() {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            boolean bl = this.writeClosed;
            return bl;
        }
    }

    @Override
    public long getLength() {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            long l = this.length < 0L ? -1L : this.length;
            return l;
        }
    }

    @Override
    public Content.Chunk read() {
        ChunkCallback current;
        try (AutoLock.WithCondition l = this.lock.lock();){
            if (this.length == -2L) {
                this.length = -1L;
            }
            if ((current = this.chunks.poll()) == null) {
                if (this.readClosed) {
                    Content.Chunk chunk = Content.Chunk.EOF;
                    return chunk;
                }
                if (this.errorChunk != null) {
                    Content.Chunk.Error error = this.errorChunk;
                    return error;
                }
                Content.Chunk chunk = null;
                return chunk;
            }
            this.readClosed = current.chunk().isLast();
            if (this.chunks.isEmpty()) {
                l.signal();
            }
        }
        return current.chunk();
    }

    @Override
    public void demand(Runnable demandCallback) {
        boolean invoke;
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = Objects.requireNonNull(demandCallback);
            invoke = !this.chunks.isEmpty() || this.readClosed || this.errorChunk != null;
        }
        if (invoke) {
            this.invoker.run(this::invokeDemandCallback);
        }
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            this.runDemandCallback(demandCallback);
        }
    }

    private void runDemandCallback(Runnable demandCallback) {
        try {
            demandCallback.run();
        }
        catch (Throwable x) {
            this.fail(x);
        }
    }

    @Override
    public void fail(Throwable failure) {
        List<ChunkCallback> drained;
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.readClosed) {
                return;
            }
            if (this.errorChunk != null) {
                return;
            }
            this.errorChunk = Content.Chunk.from(failure);
            drained = List.copyOf(this.chunks);
            this.chunks.clear();
        }
        drained.forEach(cc -> cc.callback().failed(failure));
        this.invoker.run(this::invokeDemandCallback);
    }

    public int count() {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            int n = this.chunks.size();
            return n;
        }
    }

    private record ChunkCallback(Content.Chunk chunk, Callback callback) {
    }
}

