/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.BufferUtil;

public abstract class ByteBufferChunk
implements Content.Chunk {
    public static final ByteBufferChunk EMPTY = new ByteBufferChunk(BufferUtil.EMPTY_BUFFER, false){

        @Override
        public String toString() {
            return "%s[EMPTY]".formatted(ByteBufferChunk.class.getSimpleName());
        }
    };
    public static final ByteBufferChunk EOF = new ByteBufferChunk(BufferUtil.EMPTY_BUFFER, true){

        @Override
        public String toString() {
            return "%s[EOF]".formatted(ByteBufferChunk.class.getSimpleName());
        }
    };
    private final ByteBuffer byteBuffer;
    private final boolean last;

    public ByteBufferChunk(ByteBuffer byteBuffer, boolean last) {
        this.byteBuffer = Objects.requireNonNull(byteBuffer);
        this.last = last;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public void retain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean release() {
        return true;
    }

    public String toString() {
        return "%s@%x[l=%b,b=%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.isLast(), BufferUtil.toDetailString((ByteBuffer)this.getByteBuffer()));
    }

    public static class WithRetainable
    extends ByteBufferChunk {
        private final Retainable retainable;

        public WithRetainable(ByteBuffer byteBuffer, boolean last, Retainable retainable) {
            super(byteBuffer, last);
            this.retainable = retainable;
        }

        @Override
        public void retain() {
            this.retainable.retain();
        }

        @Override
        public boolean release() {
            return this.retainable.release();
        }
    }

    public static class ReleasedByConsumer
    extends WithReferenceCount {
        private final AtomicReference<Consumer<ByteBuffer>> releaser;

        public ReleasedByConsumer(ByteBuffer byteBuffer, boolean last, Consumer<ByteBuffer> releaser) {
            super(byteBuffer, last);
            this.releaser = new AtomicReference<Consumer<ByteBuffer>>(releaser);
        }

        @Override
        public boolean release() {
            Consumer consumer;
            boolean released = super.release();
            if (released && (consumer = (Consumer)this.releaser.getAndSet(null)) != null) {
                consumer.accept(this.getByteBuffer());
            }
            return released;
        }
    }

    public static class ReleasedByRunnable
    extends WithReferenceCount {
        private final AtomicReference<Runnable> releaser;

        public ReleasedByRunnable(ByteBuffer byteBuffer, boolean last, Runnable releaser) {
            super(byteBuffer, last);
            this.releaser = new AtomicReference<Runnable>(releaser);
        }

        @Override
        public boolean release() {
            Runnable runnable;
            boolean released = super.release();
            if (released && (runnable = (Runnable)this.releaser.getAndSet(null)) != null) {
                runnable.run();
            }
            return released;
        }
    }

    public static class WithReferenceCount
    extends ByteBufferChunk {
        private final Retainable.ReferenceCounter references = new Retainable.ReferenceCounter();

        public WithReferenceCount(ByteBuffer byteBuffer, boolean last) {
            super(byteBuffer, last);
        }

        @Override
        public void retain() {
            this.references.retain();
        }

        @Override
        public boolean release() {
            return this.references.release();
        }
    }
}

