/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.util.function.BiPredicate;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.thread.Invocable;

public class ContentCopier
extends IteratingNestedCallback {
    private final Content.Source source;
    private final Content.Sink sink;
    private final BiPredicate<Content.Chunk, Callback> chunkHandler;
    private Content.Chunk current;
    private boolean terminated;

    public ContentCopier(Content.Source source, Content.Sink sink, BiPredicate<Content.Chunk, Callback> chunkHandler, Callback callback) {
        super(callback);
        this.source = source;
        this.sink = sink;
        this.chunkHandler = chunkHandler;
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.NON_BLOCKING;
    }

    protected IteratingCallback.Action process() throws Throwable {
        if (this.terminated) {
            return IteratingCallback.Action.SUCCEEDED;
        }
        this.current = this.source.read();
        if (this.current == null) {
            this.source.demand(() -> ((ContentCopier)this).iterate());
            return IteratingCallback.Action.IDLE;
        }
        if (this.chunkHandler != null && this.chunkHandler.test(this.current, (Callback)this)) {
            return IteratingCallback.Action.SCHEDULED;
        }
        Content.Chunk chunk = this.current;
        if (chunk instanceof Error) {
            Error error = (Error)((Object)chunk);
            throw error.getCause();
        }
        this.sink.write(this.current.isLast(), this.current.getByteBuffer(), (Callback)this);
        return IteratingCallback.Action.SCHEDULED;
    }

    public void succeeded() {
        this.terminated = this.current.isLast();
        this.current.release();
        this.current = null;
        super.succeeded();
    }

    public void failed(Throwable x) {
        if (this.current != null) {
            this.current.release();
        }
        this.current = null;
        this.source.fail(x);
        super.failed(x);
    }
}

