/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.NanoTime;

public class RetainableByteBuffer
extends Retainable.ReferenceCounter {
    private final ByteBuffer buffer;
    private final Consumer<RetainableByteBuffer> releaser;
    private final AtomicLong lastUpdate = new AtomicLong(NanoTime.now());

    RetainableByteBuffer(ByteBuffer buffer, Consumer<RetainableByteBuffer> releaser) {
        super(0);
        this.releaser = releaser;
        this.buffer = buffer;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getLastUpdate() {
        return this.lastUpdate.getOpaque();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    protected void acquire() {
        super.acquire();
    }

    @Override
    public boolean release() {
        boolean released = super.release();
        if (released) {
            this.lastUpdate.setOpaque(NanoTime.now());
            this.releaser.accept(this);
        }
        return released;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public boolean isEmpty() {
        return !this.hasRemaining();
    }

    public void clear() {
        BufferUtil.clear((ByteBuffer)this.buffer);
    }

    @Override
    public String toString() {
        return "%s[%s]".formatted(super.toString(), BufferUtil.toDetailString((ByteBuffer)this.buffer));
    }
}

