/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class ChunksContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final long length;
    private final Collection<Content.Chunk> chunks;
    private Iterator<Content.Chunk> iterator;
    private Content.Chunk terminated;
    private Runnable demandCallback;

    public ChunksContentSource(Collection<Content.Chunk> chunks) {
        this.chunks = chunks;
        this.length = chunks.stream().mapToLong(c -> c.getByteBuffer().remaining()).sum();
    }

    public Collection<Content.Chunk> getChunks() {
        return this.chunks;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Content.Chunk read() {
        Content.Chunk chunk;
        try (AutoLock ignored = this.lock.lock();){
            boolean last;
            if (this.terminated != null) {
                Content.Chunk chunk2 = this.terminated;
                return chunk2;
            }
            if (this.iterator == null) {
                this.iterator = this.chunks.iterator();
            }
            if (!this.iterator.hasNext()) {
                Content.Chunk chunk3 = this.terminated = Content.Chunk.EOF;
                return chunk3;
            }
            chunk = this.iterator.next();
            boolean bl = last = !this.iterator.hasNext();
            if (last) {
                this.terminated = Content.Chunk.EOF;
            }
        }
        return Content.Chunk.from(chunk.getByteBuffer().slice(), chunk.isLast(), chunk);
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            this.runDemandCallback(demandCallback);
        }
    }

    private void runDemandCallback(Runnable demandCallback) {
        try {
            demandCallback.run();
        }
        catch (Throwable x) {
            this.fail(x);
        }
    }

    @Override
    public void fail(Throwable failure) {
        List toFail = List.of();
        try (AutoLock ignored = this.lock.lock();){
            if (this.terminated != null) {
                return;
            }
            this.terminated = Content.Chunk.from(failure);
            if (this.iterator != null) {
                toFail = new ArrayList();
                this.iterator.forEachRemaining(toFail::add);
            }
        }
        toFail.forEach(Retainable::release);
    }
}

