/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.util.Objects;
import org.eclipse.jetty.io.Content;

public abstract class ContentSourceTransformer
implements Content.Source {
    private final Content.Source rawSource;
    private Content.Chunk rawChunk;
    private Content.Chunk transformedChunk;
    private boolean needsRawRead;
    private Runnable demandCallback;

    public ContentSourceTransformer(Content.Source rawSource) {
        this.rawSource = rawSource;
    }

    @Override
    public Content.Chunk read() {
        while (true) {
            if (this.needsRawRead) {
                this.rawChunk = this.rawSource.read();
                boolean bl = this.needsRawRead = this.rawChunk == null;
                if (this.rawChunk == null) {
                    return null;
                }
            }
            if (this.rawChunk instanceof Content.Chunk.Error) {
                return this.rawChunk;
            }
            if (this.transformedChunk instanceof Content.Chunk.Error) {
                return this.transformedChunk;
            }
            this.transformedChunk = this.process(this.rawChunk);
            if (this.rawChunk != null && this.rawChunk != this.transformedChunk) {
                this.rawChunk.release();
            }
            this.rawChunk = null;
            if (this.transformedChunk != null) {
                Content.Chunk result = this.transformedChunk;
                this.transformedChunk = Content.Chunk.next(result);
                return result;
            }
            this.needsRawRead = true;
        }
    }

    @Override
    public void demand(Runnable demandCallback) {
        this.demandCallback = Objects.requireNonNull(demandCallback);
        this.rawSource.demand(this::onRawAvailable);
    }

    @Override
    public void fail(Throwable failure) {
        this.rawSource.fail(failure);
    }

    private void onRawAvailable() {
        Runnable demandCallback = this.demandCallback;
        this.demandCallback = null;
        this.runDemandCallback(demandCallback);
    }

    private void runDemandCallback(Runnable demandCallback) {
        try {
            demandCallback.run();
        }
        catch (Throwable x) {
            this.fail(x);
        }
    }

    private Content.Chunk process(Content.Chunk rawChunk) {
        try {
            return this.transform(rawChunk);
        }
        catch (Throwable x) {
            this.fail(x);
            return Content.Chunk.from(x);
        }
    }

    protected abstract Content.Chunk transform(Content.Chunk var1);
}

