/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.internal.ByteBufferChunk;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class AsyncContent
implements Content.Sink,
Content.Source,
Closeable {
    private static final int UNDETERMINED_LENGTH = -2;
    private static final AsyncChunk ASYNC_EOF = new AsyncChunk(true, BufferUtil.EMPTY_BUFFER, Callback.NOOP){

        @Override
        public String toString() {
            return "ASYNC_EOF";
        }
    };
    private final AutoLock.WithCondition lock = new AutoLock.WithCondition();
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final Queue<AsyncChunk> chunks = new ArrayDeque<AsyncChunk>();
    private Content.Chunk.Error errorChunk;
    private boolean readClosed;
    private boolean writeClosed;
    private Runnable demandCallback;
    private long length = -2L;

    @Override
    public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
        this.offer(new AsyncChunk(last, byteBuffer, callback));
    }

    private void offer(AsyncChunk chunk) {
        Throwable failure = null;
        boolean wasEmpty = false;
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.writeClosed) {
                failure = new IOException("closed");
            } else if (this.errorChunk != null) {
                failure = this.errorChunk.getCause();
            } else {
                wasEmpty = this.chunks.isEmpty();
                this.chunks.offer(chunk);
                if (chunk.isLast()) {
                    this.writeClosed = true;
                    if (this.length == -2L) {
                        this.length = 0L;
                        for (AsyncChunk c : this.chunks) {
                            this.length += (long)c.remaining();
                        }
                    }
                }
            }
        }
        if (failure != null) {
            chunk.failed(failure);
        }
        if (wasEmpty) {
            this.invoker.run(this::invokeDemandCallback);
        }
    }

    public void flush() throws IOException {
        try (AutoLock.WithCondition condition = this.lock.lock();){
            while (true) {
                AsyncChunk chunk;
                if (this.errorChunk != null) {
                    throw new IOException(this.errorChunk.getCause());
                }
                if (this.chunks.isEmpty()) {
                    return;
                }
                if (this.writeClosed && this.chunks.size() == 1 && (chunk = this.chunks.peek()).isLast() && !chunk.hasRemaining()) {
                    return;
                }
                condition.await();
            }
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public void close() {
        this.offer(ASYNC_EOF);
    }

    public boolean isClosed() {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            boolean bl = this.writeClosed;
            return bl;
        }
    }

    @Override
    public long getLength() {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            long l = this.length < 0L ? -1L : this.length;
            return l;
        }
    }

    @Override
    public Content.Chunk read() {
        AsyncChunk current;
        try (AutoLock.WithCondition condition = this.lock.lock();){
            if (this.length == -2L) {
                this.length = -1L;
            }
            if ((current = this.chunks.poll()) == null) {
                if (this.readClosed) {
                    Content.Chunk chunk = Content.Chunk.EOF;
                    return chunk;
                }
                if (this.errorChunk != null) {
                    Content.Chunk.Error error = this.errorChunk;
                    return error;
                }
                Content.Chunk chunk = null;
                return chunk;
            }
            this.readClosed = current.isLast();
            if (this.chunks.isEmpty()) {
                condition.signal();
            }
        }
        if (current.canRetain()) {
            return current;
        }
        current.succeeded();
        return current.isLast() ? Content.Chunk.EOF : Content.Chunk.EMPTY;
    }

    @Override
    public void demand(Runnable demandCallback) {
        boolean invoke;
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = Objects.requireNonNull(demandCallback);
            invoke = !this.chunks.isEmpty() || this.readClosed || this.errorChunk != null;
        }
        if (invoke) {
            this.invoker.run(this::invokeDemandCallback);
        }
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            this.runDemandCallback(demandCallback);
        }
    }

    private void runDemandCallback(Runnable demandCallback) {
        try {
            demandCallback.run();
        }
        catch (Throwable x) {
            this.fail(x);
        }
    }

    @Override
    public void fail(Throwable failure) {
        List<AsyncChunk> drained;
        try (AutoLock.WithCondition condition = this.lock.lock();){
            if (this.readClosed) {
                return;
            }
            if (this.errorChunk != null) {
                return;
            }
            this.errorChunk = Content.Chunk.from(failure);
            drained = List.copyOf(this.chunks);
            this.chunks.clear();
            condition.signal();
        }
        drained.forEach(ac -> ac.failed(failure));
        this.invoker.run(this::invokeDemandCallback);
    }

    public int count() {
        try (AutoLock.WithCondition ignored = this.lock.lock();){
            int n = this.chunks.size();
            return n;
        }
    }

    private static class AsyncChunk
    extends ByteBufferChunk
    implements Callback {
        private final Callback callback;
        private final Retainable.ReferenceCounter referenceCounter;

        public AsyncChunk(boolean last, ByteBuffer byteBuffer, Callback callback) {
            super(byteBuffer.hasRemaining() ? byteBuffer : BufferUtil.EMPTY_BUFFER, last);
            this.callback = callback;
            this.referenceCounter = this.getByteBuffer() == BufferUtil.EMPTY_BUFFER ? null : new Retainable.ReferenceCounter();
        }

        @Override
        public boolean canRetain() {
            return this.referenceCounter != null;
        }

        @Override
        public void retain() {
            if (this.canRetain()) {
                this.referenceCounter.retain();
            }
        }

        @Override
        public boolean release() {
            if (!this.canRetain()) {
                return true;
            }
            boolean released = this.referenceCounter.release();
            if (released) {
                this.succeeded();
            }
            return released;
        }

        public void succeeded() {
            this.callback.succeeded();
        }

        public void failed(Throwable x) {
            this.callback.failed(x);
        }
    }
}

