/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.IO;

public class ContentSourceInputStream
extends InputStream {
    private final Blocker.Shared blocking = new Blocker.Shared();
    private final byte[] oneByte = new byte[1];
    private final Content.Source content;
    private Content.Chunk chunk;

    public ContentSourceInputStream(Content.Source content) {
        this.content = content;
    }

    @Override
    public int read() throws IOException {
        int read = this.read(this.oneByte, 0, 1);
        return read < 0 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (true) {
            if (this.chunk != null) {
                Content.Chunk chunk = this.chunk;
                if (chunk instanceof Content.Chunk.Error) {
                    Content.Chunk.Error error = (Content.Chunk.Error)chunk;
                    throw IO.rethrow((Throwable)error.getCause());
                }
                ByteBuffer byteBuffer = this.chunk.getByteBuffer();
                if (this.chunk.isLast() && !byteBuffer.hasRemaining()) {
                    return -1;
                }
                int l = Math.min(byteBuffer.remaining(), len);
                byteBuffer.get(b, off, l);
                if (!byteBuffer.hasRemaining()) {
                    this.chunk.release();
                    this.chunk = this.chunk.isLast() ? Content.Chunk.EOF : null;
                }
                return l;
            }
            this.chunk = this.content.read();
            if (this.chunk != null) continue;
            Blocker.Runnable callback = this.blocking.runnable();
            try {
                this.content.demand((Runnable)callback);
                callback.block();
                continue;
            }
            finally {
                if (callback == null) continue;
                callback.close();
                continue;
            }
            break;
        }
    }

    @Override
    public int available() throws IOException {
        ByteBuffer available;
        ByteBuffer byteBuffer = available = this.chunk == null ? null : this.chunk.getByteBuffer();
        if (available != null) {
            return available.remaining();
        }
        return 0;
    }

    @Override
    public void close() {
        if (this.chunk == Content.Chunk.EOF || this.chunk instanceof Content.Chunk.Error) {
            return;
        }
        if (this.chunk != null) {
            this.chunk.release();
            if (this.chunk.isLast()) {
                return;
            }
        }
        IOException closed = new IOException("closed before EOF");
        this.chunk = Content.Chunk.from(closed);
        this.content.fail(closed);
    }
}

