/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.eclipse.jetty.util.Pool;

public class QueuedPool<P>
implements Pool<P> {
    private final int maxSize;
    private final Queue<Pool.Entry<P>> queue = new ConcurrentLinkedQueue<Pool.Entry<P>>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean terminated;

    public QueuedPool(int maxSize) {
        this.maxSize = maxSize;
    }

    public Pool.Entry<P> reserve() {
        this.rwLock.readLock().lock();
        try {
            if (this.terminated || this.queue.size() == this.maxSize) {
                Pool.Entry<P> entry = null;
                return entry;
            }
            QueuedEntry queuedEntry = new QueuedEntry(this);
            return queuedEntry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private boolean requeue(Pool.Entry<P> entry) {
        this.rwLock.readLock().lock();
        try {
            if (this.terminated || this.queue.size() == this.maxSize) {
                boolean bl = false;
                return bl;
            }
            this.queue.add(entry);
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Pool.Entry<P> acquire() {
        this.rwLock.readLock().lock();
        try {
            if (this.terminated) {
                Pool.Entry<P> entry = null;
                return entry;
            }
            QueuedEntry entry = (QueuedEntry)this.queue.poll();
            if (entry != null) {
                entry.acquire();
            }
            QueuedEntry queuedEntry = entry;
            return queuedEntry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean isTerminated() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.terminated;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Collection<Pool.Entry<P>> terminate() {
        this.rwLock.writeLock().lock();
        try {
            this.terminated = true;
            ArrayList<Pool.Entry<P>> copy = new ArrayList<Pool.Entry<P>>(this.queue);
            this.queue.clear();
            ArrayList<Pool.Entry<P>> arrayList = copy;
            return arrayList;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int size() {
        return this.queue.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Stream<Pool.Entry<P>> stream() {
        return this.queue.stream();
    }

    private static class QueuedEntry<P>
    implements Pool.Entry<P> {
        private final QueuedPool<P> pool;
        private final AtomicMarkableReference<P> pooled = new AtomicMarkableReference<Object>(null, false);

        private QueuedEntry(QueuedPool<P> pool) {
            this.pool = pool;
        }

        public boolean enable(P pooled, boolean acquire) {
            Objects.requireNonNull(pooled);
            boolean[] inUse = new boolean[1];
            P p = this.pooled.get(inUse);
            if (p != null) {
                if (this.pool.isTerminated()) {
                    return false;
                }
                throw new IllegalStateException("Entry already enabled " + String.valueOf(this) + " for " + String.valueOf(this.pool));
            }
            if (inUse[0]) {
                return false;
            }
            this.pooled.set(pooled, acquire);
            if (acquire) {
                if (this.pool.isTerminated()) {
                    this.pooled.set(null, false);
                    return false;
                }
                return true;
            }
            return this.pool.requeue(this);
        }

        public P getPooled() {
            return this.pooled.getReference();
        }

        void acquire() {
            boolean[] inUse = new boolean[1];
            P p = this.pooled.get(inUse);
            if (p == null || inUse[0]) {
                return;
            }
            this.pooled.set(p, true);
        }

        public boolean release() {
            boolean[] inUse = new boolean[1];
            P p = this.pooled.get(inUse);
            if (p == null || !inUse[0]) {
                return false;
            }
            this.pooled.set(p, false);
            return this.pool.requeue(this);
        }

        public boolean remove() {
            boolean[] inUse = new boolean[1];
            P p = this.pooled.get(inUse);
            if (p == null && inUse[0]) {
                return false;
            }
            this.pooled.set(null, true);
            return true;
        }

        public boolean isReserved() {
            return this.pooled.getReference() == null;
        }

        public boolean isIdle() {
            return !this.pooled.isMarked();
        }

        public boolean isInUse() {
            return this.pooled.isMarked();
        }

        public boolean isTerminated() {
            boolean[] inUse = new boolean[1];
            P p = this.pooled.get(inUse);
            return p == null && inUse[0];
        }
    }
}

