/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.content.ContentSinkOutputStream;
import org.eclipse.jetty.io.content.ContentSinkSubscriber;
import org.eclipse.jetty.io.content.ContentSourceInputStream;
import org.eclipse.jetty.io.content.ContentSourcePublisher;
import org.eclipse.jetty.io.internal.ByteBufferChunk;
import org.eclipse.jetty.io.internal.ContentCopier;
import org.eclipse.jetty.io.internal.ContentSourceByteBuffer;
import org.eclipse.jetty.io.internal.ContentSourceConsumer;
import org.eclipse.jetty.io.internal.ContentSourceString;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;

public class Content {
    private Content() {
    }

    public static void copy(Source source, Sink sink, Callback callback) {
        Content.copy(source, sink, null, callback);
    }

    public static void copy(Source source, Sink sink, Chunk.Processor chunkProcessor, Callback callback) {
        new ContentCopier(source, sink, chunkProcessor, callback).iterate();
    }

    public static interface Source {
        public static void asByteBuffer(Source source, Promise<ByteBuffer> promise) {
            new ContentSourceByteBuffer(source, promise).run();
        }

        public static ByteBuffer asByteBuffer(Source source) throws IOException {
            try {
                FuturePromise promise = new FuturePromise();
                Source.asByteBuffer(source, (Promise<ByteBuffer>)promise);
                return (ByteBuffer)promise.get();
            }
            catch (Throwable x) {
                throw IO.rethrow((Throwable)x);
            }
        }

        public static void asString(Source source, Charset charset, Promise<String> promise) {
            new ContentSourceString(source, charset, promise).convert();
        }

        public static String asString(Source source) throws IOException {
            return Source.asString(source, StandardCharsets.UTF_8);
        }

        public static String asString(Source source, Charset charset) throws IOException {
            try {
                return Source.asStringAsync(source, charset).get();
            }
            catch (Throwable x) {
                throw IO.rethrow((Throwable)x);
            }
        }

        public static CompletableFuture<String> asStringAsync(Source source, Charset charset) {
            Promise.Completable completable = new Promise.Completable();
            Source.asString(source, charset, (Promise<String>)completable);
            return completable;
        }

        public static InputStream asInputStream(Source source) {
            return new ContentSourceInputStream(source);
        }

        public static Flow.Publisher<Chunk> asPublisher(Source source) {
            return new ContentSourcePublisher(source);
        }

        public static void consumeAll(Source source, Callback callback) {
            new ContentSourceConsumer(source, callback).run();
        }

        public static void consumeAll(Source source) throws IOException {
            try {
                FutureCallback callback = new FutureCallback();
                Source.consumeAll(source, (Callback)callback);
                callback.get();
            }
            catch (Throwable x) {
                throw IO.rethrow((Throwable)x);
            }
        }

        default public long getLength() {
            return -1L;
        }

        public Chunk read();

        public void demand(Runnable var1);

        public void fail(Throwable var1);

        default public void fail(Throwable failure, boolean last) {
            this.fail(failure);
        }

        default public boolean rewind() {
            return false;
        }
    }

    public static interface Sink {
        public static OutputStream asOutputStream(Sink sink) {
            return new ContentSinkOutputStream(sink);
        }

        public static Flow.Subscriber<Chunk> asSubscriber(Sink sink, Callback callback) {
            return new ContentSinkSubscriber(sink, callback);
        }

        public static void write(Sink sink, boolean last, ByteBuffer byteBuffer) throws IOException {
            try (Blocker.Callback callback = Blocker.callback();){
                sink.write(last, byteBuffer, (Callback)callback);
                callback.block();
            }
        }

        public static void write(Sink sink, boolean last, String utf8Content, Callback callback) {
            sink.write(last, StandardCharsets.UTF_8.encode(utf8Content), callback);
        }

        public void write(boolean var1, ByteBuffer var2, Callback var3);
    }

    public static interface Chunk
    extends Retainable {
        public static final Chunk EMPTY = new Chunk(){

            @Override
            public ByteBuffer getByteBuffer() {
                return BufferUtil.EMPTY_BUFFER;
            }

            @Override
            public boolean isLast() {
                return false;
            }

            public String toString() {
                return "EMPTY";
            }
        };
        public static final Chunk EOF = new Chunk(){

            @Override
            public ByteBuffer getByteBuffer() {
                return BufferUtil.EMPTY_BUFFER;
            }

            @Override
            public boolean isLast() {
                return true;
            }

            public String toString() {
                return "EOF";
            }
        };

        public static Chunk from(ByteBuffer byteBuffer, boolean last) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.WithReferenceCount(byteBuffer, last);
            }
            return last ? EOF : EMPTY;
        }

        public static Chunk from(ByteBuffer byteBuffer, boolean last, Runnable releaser) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.ReleasedByRunnable(byteBuffer, last, Objects.requireNonNull(releaser));
            }
            releaser.run();
            return last ? EOF : EMPTY;
        }

        public static Chunk from(ByteBuffer byteBuffer, boolean last, Consumer<ByteBuffer> releaser) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.ReleasedByConsumer(byteBuffer, last, Objects.requireNonNull(releaser));
            }
            releaser.accept(byteBuffer);
            return last ? EOF : EMPTY;
        }

        public static Chunk asChunk(ByteBuffer byteBuffer, boolean last, Retainable retainable) {
            if (!retainable.canRetain()) {
                throw new IllegalArgumentException("Cannot create chunk from non-retainable " + String.valueOf(retainable));
            }
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.WithRetainable(byteBuffer, last, Objects.requireNonNull(retainable));
            }
            retainable.release();
            return last ? EOF : EMPTY;
        }

        public static Chunk from(Throwable failure) {
            return Chunk.from(failure, true);
        }

        public static Chunk from(final Throwable failure, final boolean last) {
            return new Chunk(){

                @Override
                public Throwable getFailure() {
                    return failure;
                }

                @Override
                public ByteBuffer getByteBuffer() {
                    return BufferUtil.EMPTY_BUFFER;
                }

                @Override
                public boolean isLast() {
                    return last;
                }

                public String toString() {
                    return String.format("Chunk@%x{c=%s,l=%b}", this.hashCode(), failure, last);
                }
            };
        }

        public static Chunk next(Chunk chunk) {
            if (chunk == null) {
                return null;
            }
            if (Chunk.isFailure(chunk)) {
                return chunk.isLast() ? chunk : null;
            }
            if (chunk.isLast()) {
                return EOF;
            }
            return null;
        }

        public static boolean isFailure(Chunk chunk) {
            return chunk != null && chunk.getFailure() != null;
        }

        public static boolean isFailure(Chunk chunk, boolean last) {
            return chunk != null && chunk.getFailure() != null && chunk.isLast() == last;
        }

        public ByteBuffer getByteBuffer();

        default public Throwable getFailure() {
            return null;
        }

        public boolean isLast();

        default public int remaining() {
            return this.getByteBuffer().remaining();
        }

        default public boolean hasRemaining() {
            return this.getByteBuffer().hasRemaining();
        }

        default public int get(byte[] bytes, int offset, int length) {
            ByteBuffer b = this.getByteBuffer();
            if (b == null || !b.hasRemaining()) {
                return 0;
            }
            length = Math.min(length, b.remaining());
            b.get(bytes, offset, length);
            return length;
        }

        default public int skip(int length) {
            if (length == 0) {
                return 0;
            }
            ByteBuffer byteBuffer = this.getByteBuffer();
            length = Math.min(byteBuffer.remaining(), length);
            byteBuffer.position(byteBuffer.position() + length);
            return length;
        }

        default public Chunk asReadOnly() {
            if (!this.canRetain()) {
                return this;
            }
            return Chunk.asChunk(this.getByteBuffer().asReadOnlyBuffer(), this.isLast(), this);
        }

        public static interface Processor {
            public boolean process(Chunk var1, Callback var2);
        }
    }
}

