/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.internal.NonRetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public interface RetainableByteBuffer
extends Retainable {
    public static final RetainableByteBuffer EMPTY = RetainableByteBuffer.wrap(BufferUtil.EMPTY_BUFFER);

    public static RetainableByteBuffer wrap(ByteBuffer byteBuffer) {
        return new NonRetainableByteBuffer(byteBuffer);
    }

    public boolean isRetained();

    public ByteBuffer getByteBuffer();

    default public boolean isDirect() {
        return this.getByteBuffer().isDirect();
    }

    default public int remaining() {
        return this.getByteBuffer().remaining();
    }

    default public boolean hasRemaining() {
        return this.getByteBuffer().hasRemaining();
    }

    default public int capacity() {
        return this.getByteBuffer().capacity();
    }

    default public void clear() {
        BufferUtil.clear((ByteBuffer)this.getByteBuffer());
    }

    public static class Wrapper
    extends Retainable.Wrapper
    implements RetainableByteBuffer {
        public Wrapper(RetainableByteBuffer wrapped) {
            super(wrapped);
        }

        @Override
        public RetainableByteBuffer getWrapped() {
            return (RetainableByteBuffer)super.getWrapped();
        }

        @Override
        public boolean isRetained() {
            return this.getWrapped().isRetained();
        }

        @Override
        public ByteBuffer getByteBuffer() {
            return this.getWrapped().getByteBuffer();
        }

        @Override
        public boolean isDirect() {
            return this.getWrapped().isDirect();
        }

        @Override
        public int remaining() {
            return this.getWrapped().remaining();
        }

        @Override
        public boolean hasRemaining() {
            return this.getWrapped().hasRemaining();
        }

        @Override
        public int capacity() {
            return this.getWrapped().capacity();
        }

        @Override
        public void clear() {
            this.getWrapped().clear();
        }
    }
}

