/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentSourceTransformer
implements Content.Source {
    private static final Logger LOG = LoggerFactory.getLogger(ContentSourceTransformer.class);
    private final Content.Source rawSource;
    private Content.Chunk rawChunk;
    private Content.Chunk transformedChunk;
    private volatile boolean needsRawRead;
    private boolean finished;

    protected ContentSourceTransformer(Content.Source rawSource) {
        this.rawSource = rawSource;
        this.needsRawRead = true;
    }

    protected Content.Source getContentSource() {
        return this.rawSource;
    }

    @Override
    public Content.Chunk read() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading {}", (Object)this);
        }
        while (true) {
            if (this.needsRawRead) {
                this.rawChunk = this.rawSource.read();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Raw chunk {} {}", (Object)this.rawChunk, (Object)this);
                }
                boolean bl = this.needsRawRead = this.rawChunk == null;
                if (this.rawChunk == null) {
                    return null;
                }
            }
            if (Content.Chunk.isFailure(this.rawChunk)) {
                Content.Chunk failure = this.rawChunk;
                this.rawChunk = Content.Chunk.next(this.rawChunk);
                boolean bl = this.needsRawRead = this.rawChunk == null;
                if (this.rawChunk != null) {
                    this.finished = true;
                    this.release();
                }
                return failure;
            }
            if (Content.Chunk.isFailure(this.transformedChunk)) {
                return this.transformedChunk;
            }
            if (this.finished) {
                return Content.Chunk.EOF;
            }
            boolean rawLast = this.rawChunk != null && this.rawChunk.isLast();
            this.transformedChunk = this.process(this.rawChunk != null ? this.rawChunk : Content.Chunk.EMPTY);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Transformed chunk {} {}", (Object)this.transformedChunk, (Object)this);
            }
            if (this.rawChunk == null && (this.transformedChunk == null || this.transformedChunk == Content.Chunk.EMPTY)) {
                this.needsRawRead = true;
                continue;
            }
            if (this.transformedChunk == this.rawChunk) {
                this.rawChunk = null;
            }
            if (this.rawChunk != null && this.rawChunk.isEmpty()) {
                this.rawChunk.release();
                this.rawChunk = Content.Chunk.next(this.rawChunk);
            }
            if (this.transformedChunk != null) {
                boolean transformedLast = this.transformedChunk.isLast();
                boolean transformedFailure = Content.Chunk.isFailure(this.transformedChunk);
                if (transformedLast && !transformedFailure && !rawLast) {
                    this.transformedChunk = this.transformedChunk.isEmpty() ? Content.Chunk.EMPTY : Content.Chunk.asChunk(this.transformedChunk.getByteBuffer(), false, this.transformedChunk);
                }
                boolean terminated = rawLast && transformedLast;
                boolean terminalFailure = transformedFailure && transformedLast;
                Content.Chunk result = this.transformedChunk;
                this.transformedChunk = Content.Chunk.next(result);
                if (terminated || terminalFailure) {
                    this.finished = true;
                    this.release();
                }
                return result;
            }
            this.needsRawRead = this.rawChunk == null;
        }
    }

    @Override
    public void demand(Runnable demandCallback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Demanding {} {}", (Object)demandCallback, (Object)this);
        }
        if (this.needsRawRead) {
            this.rawSource.demand(demandCallback);
        } else {
            ExceptionUtil.run((Runnable)demandCallback, this::fail);
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failing {}", (Object)this, (Object)failure);
        }
        this.rawSource.fail(failure);
    }

    private Content.Chunk process(Content.Chunk rawChunk) {
        try {
            return this.transform(rawChunk);
        }
        catch (Throwable x) {
            this.fail(x);
            return Content.Chunk.from(x);
        }
    }

    protected abstract Content.Chunk transform(Content.Chunk var1);

    protected void release() {
    }

    public String toString() {
        return "%s@%x[finished=%b,source=%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.finished, this.rawSource);
    }
}

