/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public void register(SocketChannel channel, Object att) throws IOException {
        int s = this._set++;
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) throws IOException {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        SelectSet[] sets = this._selectSet;
        if (sets != null && sets.length > acceptorID && sets[acceptorID] != null) {
            sets[acceptorID].doSelect();
        }
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1);

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (int i = 0; i < sets.length; ++i) {
                SelectSet set = sets[i];
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        Log.warn((Throwable)ex);
    }

    private static class AttachedSocketChannel {
        final SocketChannel _channel;
        final Object _attachment;

        public AttachedSocketChannel(SocketChannel channel, Object attachment) {
            this._channel = channel;
            this._attachment = attachment;
        }
    }

    public class SelectSet {
        private transient int _change;
        private transient List<Object>[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _timeout;
        private transient Selector _selector;
        private transient int _setID;
        private transient int _jvmBug;
        private volatile boolean _selecting;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout((Object)this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._timeout = new Timeout((Object)this);
            this._timeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new List[]{new ArrayList(), new ArrayList()};
            this._change = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List<Object>[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void addChange(SocketChannel channel, Object att) {
            this.addChange(new AttachedSocketChannel(channel, att));
        }

        public void cancelIdle(Timeout.Task task) {
            task.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doSelect() throws IOException {
            try {
                List<Object>[] listArray = this._changes;
                synchronized (this._changes) {
                    Object endpoint;
                    List<Object> changes = this._changes[this._change];
                    this._change = this._change == 0 ? 1 : 0;
                    this._selecting = true;
                    Selector selector = this._selector;
                    // ** MonitorExit[var3_1] (shouldn't be in output)
                    int size = changes.size();
                    for (int i = 0; i < size; ++i) {
                        try {
                            AbstractSelectableChannel channel;
                            Object o = changes.get(i);
                            if (o instanceof EndPoint) {
                                SelectChannelEndPoint endpoint2 = (SelectChannelEndPoint)o;
                                endpoint2.doUpdateKey();
                                continue;
                            }
                            if (o instanceof Runnable) {
                                SelectorManager.this.dispatch((Runnable)o);
                                continue;
                            }
                            if (o instanceof AttachedSocketChannel) {
                                AttachedSocketChannel asc = (AttachedSocketChannel)o;
                                SocketChannel channel2 = asc._channel;
                                Object att = asc._attachment;
                                if (channel2.isConnected()) {
                                    SelectionKey key = channel2.register(selector, 1, att);
                                    endpoint = SelectorManager.this.newEndPoint(channel2, this, key);
                                    key.attach(endpoint);
                                    ((SelectChannelEndPoint)endpoint).schedule();
                                    continue;
                                }
                                channel2.register(selector, 8, att);
                                continue;
                            }
                            if (o instanceof SocketChannel) {
                                channel = (SocketChannel)o;
                                if (((SocketChannel)channel).isConnected()) {
                                    SelectionKey key = channel.register(selector, 1, null);
                                    SelectChannelEndPoint endpoint3 = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key);
                                    key.attach(endpoint3);
                                    endpoint3.schedule();
                                    continue;
                                }
                                channel.register(selector, 8, null);
                                continue;
                            }
                            if (o instanceof ServerSocketChannel) {
                                channel = (ServerSocketChannel)o;
                                channel.register(this.getSelector(), 16);
                                continue;
                            }
                            throw new IllegalArgumentException(o.toString());
                        }
                        catch (CancelledKeyException e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn((Throwable)e);
                                continue;
                            }
                            Log.debug((Throwable)e);
                        }
                    }
                    changes.clear();
                    long idle_next = 0L;
                    long retry_next = 0L;
                    long now = System.currentTimeMillis();
                    endpoint = this;
                    synchronized (endpoint) {
                        this._idleTimeout.setNow(now);
                        this._timeout.setNow(now);
                        if (SelectorManager.this._lowResourcesConnections > 0L && (long)selector.keys().size() > SelectorManager.this._lowResourcesConnections) {
                            this._idleTimeout.setDuration(SelectorManager.this._lowResourcesMaxIdleTime);
                        } else {
                            this._idleTimeout.setDuration(SelectorManager.this._maxIdleTime);
                        }
                        idle_next = this._idleTimeout.getTimeToNext();
                        retry_next = this._timeout.getTimeToNext();
                    }
                    long wait = 1000L;
                    if (idle_next >= 0L && wait > idle_next) {
                        wait = idle_next;
                    }
                    if (wait > 0L && retry_next >= 0L && wait > retry_next) {
                        wait = retry_next;
                    }
                    if (wait > 0L) {
                        long before = now;
                        int selected = selector.select(wait);
                        now = System.currentTimeMillis();
                        this._idleTimeout.setNow(now);
                        this._timeout.setNow(now);
                        if (selected == 0 && now - before < wait / 2L) {
                            ++this._jvmBug;
                            if (this._jvmBug > 4) {
                                for (SelectionKey key : selector.keys()) {
                                    if (key.interestOps() != 0 || !key.isValid()) continue;
                                    key.cancel();
                                }
                                selector.selectNow();
                            } else if (this._jvmBug > 8) {
                                SelectSet i$ = this;
                                synchronized (i$) {
                                    System.err.println("SUN BUG WORKAROUND!!!!");
                                    Selector new_selector = Selector.open();
                                    for (SelectionKey key : this._selector.keys()) {
                                        SocketChannel channel = (SocketChannel)key.channel();
                                        Object attachment = key.attachment();
                                        key.cancel();
                                        if (attachment == null) {
                                            this.addChange(channel);
                                            continue;
                                        }
                                        this.addChange(attachment);
                                    }
                                    this._selector.close();
                                    this._selector = new_selector;
                                }
                            }
                        } else {
                            this._jvmBug = 0;
                        }
                    } else {
                        selector.selectNow();
                        this._jvmBug = 0;
                    }
                    if (this._selector == null || !selector.isOpen()) {
                        return;
                    }
                    for (SelectionKey key : selector.selectedKeys()) {
                        try {
                            SelectChannelEndPoint endpoint4;
                            SocketChannel channel;
                            if (!key.isValid()) {
                                key.cancel();
                                SelectChannelEndPoint endpoint5 = (SelectChannelEndPoint)key.attachment();
                                if (endpoint5 == null) continue;
                                endpoint5.doUpdateKey();
                                continue;
                            }
                            Object att = key.attachment();
                            if (att instanceof SelectChannelEndPoint) {
                                ((SelectChannelEndPoint)att).schedule();
                            } else if (key.isAcceptable()) {
                                channel = SelectorManager.this.acceptChannel(key);
                                if (channel == null) continue;
                                channel.configureBlocking(false);
                                ++this._nextSet;
                                this._nextSet %= SelectorManager.this._selectSet.length;
                                if (this._nextSet == this._setID) {
                                    SelectionKey cKey = channel.register(SelectorManager.this._selectSet[this._nextSet].getSelector(), 1);
                                    endpoint4 = SelectorManager.this.newEndPoint(channel, SelectorManager.this._selectSet[this._nextSet], cKey);
                                    cKey.attach(endpoint4);
                                    if (endpoint4 != null) {
                                        endpoint4.schedule();
                                    }
                                } else {
                                    SelectorManager.this._selectSet[this._nextSet].addChange(channel);
                                    SelectorManager.this._selectSet[this._nextSet].wakeup();
                                }
                            } else if (key.isConnectable()) {
                                channel = (SocketChannel)key.channel();
                                boolean connected = false;
                                try {
                                    connected = channel.finishConnect();
                                }
                                catch (Exception e) {
                                    SelectorManager.this.connectionFailed(channel, e, att);
                                }
                                finally {
                                    if (connected) {
                                        key.interestOps(1);
                                        endpoint4 = SelectorManager.this.newEndPoint(channel, this, key);
                                        key.attach(endpoint4);
                                        endpoint4.schedule();
                                    } else {
                                        key.cancel();
                                    }
                                }
                            } else {
                                channel = (SocketChannel)key.channel();
                                SelectChannelEndPoint endpoint6 = SelectorManager.this.newEndPoint(channel, this, key);
                                key.attach(endpoint6);
                                if (key.isReadable()) {
                                    endpoint6.schedule();
                                }
                            }
                            key = null;
                        }
                        catch (CancelledKeyException e) {
                            Log.ignore((Throwable)e);
                        }
                        catch (Exception e) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn((Throwable)e);
                            } else {
                                Log.ignore((Throwable)e);
                            }
                            if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                            key.cancel();
                        }
                    }
                    selector.selectedKeys().clear();
                    this._idleTimeout.tick(now);
                    this._timeout.tick(now);
                }
            }
            catch (CancelledKeyException e) {
                Log.ignore((Throwable)e);
            }
            finally {
                this._selecting = false;
            }
            {
                return;
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        public void scheduleIdle(Timeout.Task task) {
            if (this._idleTimeout.getDuration() <= 0L) {
                return;
            }
            this._idleTimeout.schedule(task);
        }

        public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
            this._timeout.schedule(task, timeoutMs);
        }

        public void cancelTimeout(Timeout.Task task) {
            task.cancel();
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                selecting = this._selecting;
            }
            ArrayList<SelectionKey> keys = new ArrayList<SelectionKey>(this._selector.keys());
            for (SelectionKey key : keys) {
                EndPoint endpoint;
                if (key == null || (endpoint = (EndPoint)key.attachment()) == null) continue;
                try {
                    endpoint.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                selecting = this._selecting;
                while (selecting) {
                    this.wakeup();
                    selecting = this._selecting;
                }
                this._idleTimeout.cancelAll();
                this._timeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                this._selector = null;
            }
        }
    }
}

