/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements Runnable,
AsyncEndPoint {
    protected SelectorManager _manager;
    protected SelectorManager.SelectSet _selectSet;
    protected boolean _dispatched = false;
    protected boolean _redispatched = false;
    protected boolean _writable = true;
    protected SelectionKey _key;
    protected int _interestOps;
    protected boolean _readBlocked;
    protected boolean _writeBlocked;
    protected Connection _connection;
    private boolean _open;
    private Timeout.Task _idleTask = new IdleTask();

    public Connection getConnection() {
        return this._connection;
    }

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) {
        super(channel);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._connection = this._manager.newConnection(channel, this);
        this._dispatched = false;
        this._redispatched = false;
        this._open = true;
        this._manager.endPointOpened(this);
        this._key = key;
        this.scheduleIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key == null || !this._key.isValid()) {
                this._readBlocked = false;
                this._writeBlocked = false;
                this.notifyAll();
                return;
            }
            if (this._readBlocked || this._writeBlocked) {
                if (this._readBlocked && this._key.isReadable()) {
                    this._readBlocked = false;
                }
                if (this._writeBlocked && this._key.isWritable()) {
                    this._writeBlocked = false;
                }
                this.notifyAll();
                this._key.interestOps(0);
                return;
            }
            if (!this.isReadyForDispatch()) {
                this._key.interestOps(0);
                return;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
                this._writable = true;
            }
            if (!this.dispatch()) {
                this.updateKey();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._dispatched) {
                this._redispatched = true;
                return true;
            }
            this._dispatched = this._manager.dispatch(this);
            if (!this._dispatched) {
                Log.warn((String)"Dispatched Failed!");
            }
            return this._dispatched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean undispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._redispatched) {
                this._redispatched = false;
                return false;
            }
            this._dispatched = false;
            this.updateKey();
        }
        return true;
    }

    public void scheduleIdle() {
        this._selectSet.scheduleIdle(this._idleTask);
    }

    public void cancelIdle() {
        this._selectSet.cancelIdle(this._idleTask);
    }

    protected void idleExpired() {
        try {
            this.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
    }

    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int l = super.flush(header, buffer, trailer);
        this._writable = l != 0;
        return l;
    }

    public int flush(Buffer buffer) throws IOException {
        int l = super.flush(buffer);
        this._writable = l != 0;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadyForDispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return !this._dispatched && !this.getConnection().isSuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockReadable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long start = this._selectSet.getNow();
            try {
                boolean bl;
                block9: {
                    this._readBlocked = true;
                    while (this.isOpen()) {
                        if (!this._readBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(timeoutMs);
                            if (!this._readBlocked || timeoutMs >= this._selectSet.getNow() - start) continue;
                            bl = false;
                            break block9;
                        }
                        catch (InterruptedException e) {
                            Log.warn((Throwable)e);
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._readBlocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockWritable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long start = this._selectSet.getNow();
            try {
                boolean bl;
                block9: {
                    this._writeBlocked = true;
                    while (this.isOpen()) {
                        if (!this._writeBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(timeoutMs);
                            if (!this._writeBlocked || timeoutMs >= this._selectSet.getNow() - start) continue;
                            bl = false;
                            break block9;
                        }
                        catch (InterruptedException e) {
                            Log.warn((Throwable)e);
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._writeBlocked = false;
            }
        }
    }

    public void setWritable(boolean writable) {
        this._writable = writable;
    }

    public void scheduleWrite() {
        this._writable = false;
        this.updateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            int ops = -1;
            if (this.getChannel().isOpen()) {
                this._interestOps = (!this._dispatched || this._readBlocked ? 1 : 0) | (!this._writable || this._writeBlocked ? 4 : 0);
                try {
                    ops = this._key != null && this._key.isValid() ? this._key.interestOps() : -1;
                }
                catch (Exception e) {
                    this._key = null;
                    Log.ignore((Throwable)e);
                }
            }
            if (this._interestOps == ops && this.getChannel().isOpen()) {
                return;
            }
        }
        this._selectSet.addChange(this);
        this._selectSet.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpdateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.getChannel().isOpen()) {
                if (this._interestOps > 0) {
                    if (this._key == null || !this._key.isValid()) {
                        SelectableChannel sc = (SelectableChannel)((Object)this.getChannel());
                        if (sc.isRegistered()) {
                            this.updateKey();
                        } else {
                            try {
                                this._key = ((SelectableChannel)((Object)this.getChannel())).register(this._selectSet.getSelector(), this._interestOps, this);
                            }
                            catch (Exception e) {
                                Log.ignore((Throwable)e);
                                if (this._key != null && this._key.isValid()) {
                                    this._key.cancel();
                                }
                                this.cancelIdle();
                                if (this._open) {
                                    this._manager.endPointClosed(this);
                                }
                                this._open = false;
                                this._key = null;
                            }
                        }
                    } else {
                        this._key.interestOps(this._interestOps);
                    }
                } else if (this._key.isValid()) {
                    this._key.interestOps(0);
                } else {
                    this._key = null;
                }
            } else {
                if (this._key != null && this._key.isValid()) {
                    this._key.cancel();
                }
                this.cancelIdle();
                if (this._open) {
                    this._manager.endPointClosed(this);
                }
                this._open = false;
                this._key = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
        finally {
            this.updateKey();
        }
    }

    public String toString() {
        return "SCEP@" + this.hashCode() + "[d=" + this._dispatched + ",io=" + ((0x10 & this._interestOps) != 0 ? "A" : "") + ((8 & this._interestOps) != 0 ? "C" : "") + ((1 & this._interestOps) != 0 ? "R" : "") + ((4 & this._interestOps) != 0 ? "W" : "") + ",w=" + this._writable + ",b=" + this._readBlocked + "|" + this._writeBlocked + "]";
    }

    public Timeout.Task getTimeoutTask() {
        return this._idleTask;
    }

    public SelectorManager.SelectSet getSelectSet() {
        return this._selectSet;
    }

    public class IdleTask
    extends Timeout.Task {
        public void expired() {
            SelectChannelEndPoint.this.idleExpired();
        }

        public String toString() {
            return "TimeoutTask:" + SelectChannelEndPoint.this.toString();
        }
    }
}

