/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements SelectorManager.SelectableEndPoint {
    public static final Logger LOG = Log.getLogger(SelectChannelEndPoint.class);
    private final Runnable _updateTask = new Runnable(){

        @Override
        public void run() {
            try {
                if (SelectChannelEndPoint.this.getChannel().isOpen()) {
                    int oldInterestOps = SelectChannelEndPoint.this._key.interestOps();
                    int newInterestOps = SelectChannelEndPoint.this._interestOps;
                    if (newInterestOps != oldInterestOps) {
                        SelectChannelEndPoint.this.setKeyInterests(oldInterestOps, newInterestOps);
                    }
                }
            }
            catch (CancelledKeyException x) {
                LOG.debug("Ignoring key update for concurrently closed channel {}", new Object[]{this});
                SelectChannelEndPoint.this.close();
            }
            catch (Exception x) {
                LOG.warn("Ignoring key update for " + this, (Throwable)x);
                SelectChannelEndPoint.this.close();
            }
        }
    };
    private final AtomicBoolean _open = new AtomicBoolean();
    private final SelectorManager.ManagedSelector _selector;
    private final SelectionKey _key;
    private volatile int _interestOps;

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key, Scheduler scheduler, long idleTimeout) {
        super(scheduler, channel);
        this._selector = selector;
        this._key = key;
        this.setIdleTimeout(idleTimeout);
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        this.scheduleIdleTimeout(idleTimeout);
    }

    @Override
    protected boolean needsFill() {
        this.updateLocalInterests(1, true);
        return false;
    }

    @Override
    protected void onIncompleteFlush() {
        this.updateLocalInterests(4, true);
    }

    @Override
    public void onSelected() {
        int oldInterestOps = this._key.interestOps();
        int readyOps = this._key.readyOps();
        int newInterestOps = oldInterestOps & ~readyOps;
        this.setKeyInterests(oldInterestOps, newInterestOps);
        this.updateLocalInterests(readyOps, false);
        if (this._key.isReadable()) {
            this.getFillInterest().fillable();
        }
        if (this._key.isWritable()) {
            this.getWriteFlusher().completeWrite();
        }
    }

    private void updateLocalInterests(int operation, boolean add) {
        int oldInterestOps = this._interestOps;
        int newInterestOps = add ? oldInterestOps | operation : oldInterestOps & ~operation;
        if (this.isInputShutdown()) {
            newInterestOps &= 0xFFFFFFFE;
        }
        if (this.isOutputShutdown()) {
            newInterestOps &= 0xFFFFFFFB;
        }
        if (newInterestOps != oldInterestOps) {
            this._interestOps = newInterestOps;
            LOG.debug("Local interests updated {} -> {} for {}", new Object[]{oldInterestOps, newInterestOps, this});
            this._selector.submit(this._updateTask);
        } else {
            LOG.debug("Ignoring local interests update {} -> {} for {}", new Object[]{oldInterestOps, newInterestOps, this});
        }
    }

    private void setKeyInterests(int oldInterestOps, int newInterestOps) {
        LOG.debug("Key interests updated {} -> {}", new Object[]{oldInterestOps, newInterestOps});
        this._key.interestOps(newInterestOps);
    }

    @Override
    public void close() {
        if (this._open.compareAndSet(true, false)) {
            super.close();
            this._selector.destroyEndPoint(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this._open.get();
    }

    @Override
    public void onOpen() {
        if (this._open.compareAndSet(false, true)) {
            super.onOpen();
            this.scheduleIdleTimeout(this.getIdleTimeout());
        }
    }

    @Override
    public String toString() {
        String keyString = "";
        if (this._key.isValid()) {
            if (this._key.isReadable()) {
                keyString = keyString + "r";
            }
            if (this._key.isWritable()) {
                keyString = keyString + "w";
            }
        } else {
            keyString = keyString + "!";
        }
        return String.format("%s{io=%d,k=%s}", super.toString(), this._interestOps, keyString);
    }
}

