/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExecutorCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    private final List<Connection.Listener> listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final AtomicReference<State> _state = new AtomicReference<State>(State.IDLE);
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private final Callback<Void> _readCallback;
    private int _inputBufferSize = 2048;
    final AtomicReference<Throwable> _opened = new AtomicReference<Object>(null);

    public AbstractConnection(EndPoint endp, Executor executor) {
        this(endp, executor, true);
    }

    public AbstractConnection(EndPoint endp, Executor executor, final boolean executeOnfillable) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = endp;
        this._executor = executor;
        this._readCallback = new ExecutorCallback<Void>(executor, 0){

            public void completed(Void context) {
                if (executeOnfillable) {
                    super.completed((Object)context);
                } else {
                    this.onCompleted(context);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void onCompleted(Void context) {
                if (!AbstractConnection.this._state.compareAndSet(State.INTERESTED, State.FILLING)) {
                    LOG.warn(new Throwable());
                    return;
                }
                try {
                    AbstractConnection.this.onFillable();
                }
                catch (Throwable throwable) {
                    while (true) {
                        switch ((State)((Object)AbstractConnection.this._state.get())) {
                            case IDLE: 
                            case INTERESTED: {
                                throw new IllegalStateException();
                            }
                            case FILLING: {
                                if (!AbstractConnection.this._state.compareAndSet(State.FILLING, State.IDLE)) break;
                                throw throwable;
                            }
                            case FILLING_INTERESTED: {
                                if (!AbstractConnection.this._state.compareAndSet(State.FILLING_INTERESTED, State.INTERESTED)) break;
                                AbstractConnection.this.getEndPoint().fillInterested(null, AbstractConnection.this._readCallback);
                                throw throwable;
                            }
                        }
                    }
                }
                while (true) {
                    switch ((State)((Object)AbstractConnection.this._state.get())) {
                        case IDLE: 
                        case INTERESTED: {
                            throw new IllegalStateException();
                        }
                        case FILLING: {
                            if (!AbstractConnection.this._state.compareAndSet(State.FILLING, State.IDLE)) break;
                            return;
                        }
                        case FILLING_INTERESTED: {
                            if (!AbstractConnection.this._state.compareAndSet(State.FILLING_INTERESTED, State.INTERESTED)) break;
                            AbstractConnection.this.getEndPoint().fillInterested(null, AbstractConnection.this._readCallback);
                            return;
                        }
                    }
                }
            }

            protected void onFailed(Void context, Throwable x) {
                AbstractConnection.this.onFillInterestedFailed(x);
            }

            public String toString() {
                return String.format("AC.ExReadCB@%x", AbstractConnection.this.hashCode());
            }
        };
    }

    @Override
    public void addListener(Connection.Listener listener) {
        this.listeners.add(listener);
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this._inputBufferSize = inputBufferSize;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fillInterested() {
        LOG.debug("fillInterested {}", new Object[]{this});
        while (true) {
            switch (this._state.get()) {
                case IDLE: {
                    if (!this._state.compareAndSet(State.IDLE, State.INTERESTED)) break;
                    this.getEndPoint().fillInterested(null, this._readCallback);
                    return;
                }
                case FILLING: {
                    if (!this._state.compareAndSet(State.FILLING, State.FILLING_INTERESTED)) break;
                    return;
                }
                case INTERESTED: 
                case FILLING_INTERESTED: {
                    return;
                }
            }
        }
    }

    public abstract void onFillable();

    protected void onFillInterestedFailed(Throwable cause) {
        LOG.debug("{} onFillInterestedFailed {}", new Object[]{this, cause});
        if (this._endPoint.isOpen()) {
            boolean close = true;
            if (cause instanceof TimeoutException) {
                close = this.onReadTimeout();
            }
            if (close) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                } else {
                    this._endPoint.shutdownOutput();
                }
            }
        }
    }

    protected boolean onReadTimeout() {
        return true;
    }

    @Override
    public void onOpen() {
        LOG.debug("onOpen {}", new Object[]{this});
        for (Connection.Listener listener : this.listeners) {
            listener.onOpened(this);
        }
        if (!this._opened.compareAndSet(null, new Throwable())) {
            LOG.warn("ALREADY OPENED ", this._opened.get());
            LOG.warn("EXTRA OPEN AT ", new Throwable());
        }
    }

    @Override
    public void onClose() {
        LOG.debug("onClose {}", new Object[]{this});
        for (Connection.Listener listener : this.listeners) {
            listener.onClosed(this);
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public int getMessagesIn() {
        return 0;
    }

    @Override
    public int getMessagesOut() {
        return 0;
    }

    @Override
    public long getBytesIn() {
        return 0L;
    }

    @Override
    public long getBytesOut() {
        return 0L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    public String toString() {
        return String.format("%s@%x{%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state.get()});
    }

    private static enum State {
        IDLE,
        INTERESTED,
        FILLING,
        FILLING_INTERESTED;

    }
}

