/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FilterConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(FilterConnection.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private final ByteBufferPool _bufferPool;
    private final FilteredEndPoint _filterEndPoint;
    private final int _outputBufferSize;
    private final List<Filter> _filters = new CopyOnWriteArrayList<Filter>();

    public FilterConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, int outputBufferSize) {
        super(endPoint, executor, false);
        this._bufferPool = byteBufferPool;
        this._filterEndPoint = this.newFilterEndPoint();
        this._outputBufferSize = outputBufferSize;
    }

    protected FilteredEndPoint newFilterEndPoint() {
        return new FilteredEndPoint();
    }

    public FilteredEndPoint getFilterEndPoint() {
        return this._filterEndPoint;
    }

    public void addFilter(Filter filter) {
        this._filters.add(filter);
    }

    public boolean removeFilter(Filter listener) {
        return this._filters.remove(listener);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        for (Filter filter : this._filters) {
            filter.opened(this.getEndPoint());
        }
        this.getFilterEndPoint().getConnection().onOpen();
    }

    @Override
    public void onClose() {
        for (Filter filter : this._filters) {
            filter.closed(this.getEndPoint());
        }
        this._filterEndPoint.getConnection().onClose();
        super.onClose();
    }

    @Override
    public int getMessagesIn() {
        return this._filterEndPoint.getConnection().getMessagesIn();
    }

    @Override
    public int getMessagesOut() {
        return this._filterEndPoint.getConnection().getMessagesOut();
    }

    @Override
    public void close() {
        this.getFilterEndPoint().getConnection().close();
    }

    @Override
    public void onFillable() {
        if (DEBUG) {
            LOG.debug("onFillable enter {}", new Object[]{this.getEndPoint()});
        }
        this._filterEndPoint.getFillInterest().fillable();
        if (DEBUG) {
            LOG.debug("onFillable exit {}", new Object[]{this.getEndPoint()});
        }
    }

    @Override
    public void onFillInterestedFailed(Throwable cause) {
        this._filterEndPoint.getFillInterest().onFail(cause);
    }

    @Override
    public String toString() {
        return String.format("%s@%x -> %s", FilterConnection.class.getSimpleName(), this.hashCode(), this._filterEndPoint.getConnection());
    }

    public class FilteredEndPoint
    extends AbstractEndPoint {
        private final Callback<Void> _writeCB;
        private ByteBuffer _outBuffer;

        public FilteredEndPoint() {
            super(null, FilterConnection.this.getEndPoint().getLocalAddress(), FilterConnection.this.getEndPoint().getRemoteAddress());
            this._writeCB = new Callback<Void>(){

                public void completed(Void context) {
                    if (BufferUtil.isEmpty((ByteBuffer)FilteredEndPoint.this._outBuffer)) {
                        FilterConnection.this._bufferPool.release(FilteredEndPoint.this._outBuffer);
                        FilteredEndPoint.this._outBuffer = null;
                    }
                    FilteredEndPoint.this.getWriteFlusher().completeWrite();
                }

                public void failed(Void context, Throwable x) {
                    if (BufferUtil.isEmpty((ByteBuffer)FilteredEndPoint.this._outBuffer)) {
                        FilterConnection.this._bufferPool.release(FilteredEndPoint.this._outBuffer);
                        FilteredEndPoint.this._outBuffer = null;
                    }
                    FilteredEndPoint.this.getWriteFlusher().onFail(x);
                }
            };
            this.setIdleTimeout(FilterConnection.this.getEndPoint().getIdleTimeout());
        }

        @Override
        public void setIdleTimeout(long idleTimeout) {
            super.setIdleTimeout(idleTimeout);
            FilterConnection.this.getEndPoint().setIdleTimeout(idleTimeout);
        }

        @Override
        protected void onIncompleteFlush() {
            if (BufferUtil.isEmpty((ByteBuffer)this._outBuffer)) {
                FilterConnection.this._bufferPool.release(this._outBuffer);
                this._outBuffer = null;
                this.getWriteFlusher().completeWrite();
            } else {
                FilterConnection.this.getEndPoint().write(null, this._writeCB, this._outBuffer);
            }
        }

        @Override
        protected boolean needsFill() throws IOException {
            FilterConnection.this.fillInterested();
            return false;
        }

        @Override
        public synchronized int fill(ByteBuffer buffer) throws IOException {
            if (DEBUG) {
                LOG.debug("{} fill enter", new Object[]{FilterConnection.this});
            }
            int orig = buffer.remaining();
            int filled = FilterConnection.this.getEndPoint().fill(buffer);
            if (orig > 0) {
                buffer.position(buffer.position() + orig);
            }
            for (Filter filter : FilterConnection.this._filters) {
                filter.incoming(FilterConnection.this.getEndPoint(), buffer);
            }
            if (orig > 0) {
                buffer.position(buffer.position() - orig);
            }
            if (DEBUG) {
                LOG.debug("{} fill {} exit", new Object[]{FilterConnection.this, filled});
            }
            return filled;
        }

        @Override
        public synchronized boolean flush(ByteBuffer ... buffers) throws IOException {
            if (DEBUG) {
                LOG.debug("{} flush enter {}", new Object[]{FilterConnection.this, Arrays.toString(buffers)});
            }
            if (BufferUtil.hasContent((ByteBuffer)this._outBuffer)) {
                return false;
            }
            if (this._outBuffer == null) {
                this._outBuffer = FilterConnection.this._bufferPool.acquire(FilterConnection.this._outputBufferSize, true);
            }
            boolean all_taken = true;
            for (ByteBuffer buffer : buffers) {
                if (buffer == null) continue;
                BufferUtil.flipPutFlip((ByteBuffer)buffer, (ByteBuffer)this._outBuffer);
                if (!BufferUtil.hasContent((ByteBuffer)buffer)) continue;
                all_taken = false;
                break;
            }
            for (Filter filter : FilterConnection.this._filters) {
                filter.outgoing(FilterConnection.this.getEndPoint(), this._outBuffer);
            }
            boolean flushed = FilterConnection.this.getEndPoint().flush(this._outBuffer);
            if (BufferUtil.isEmpty((ByteBuffer)this._outBuffer)) {
                FilterConnection.this._bufferPool.release(this._outBuffer);
                this._outBuffer = null;
            }
            if (DEBUG) {
                LOG.debug("{} flush exit, consumed {}", new Object[]{FilterConnection.this, flushed});
            }
            return all_taken && flushed;
        }

        @Override
        public void shutdownOutput() {
            FilterConnection.this.getEndPoint().shutdownOutput();
        }

        @Override
        public boolean isOutputShutdown() {
            return FilterConnection.this.getEndPoint().isOutputShutdown();
        }

        @Override
        public void close() {
            FilterConnection.this.getEndPoint().close();
        }

        @Override
        public boolean isOpen() {
            return FilterConnection.this.getEndPoint().isOpen();
        }

        @Override
        public Object getTransport() {
            return FilterConnection.this.getEndPoint();
        }

        @Override
        public boolean isInputShutdown() {
            return FilterConnection.this.getEndPoint().isInputShutdown();
        }

        public EndPoint getWrappedEndPoint() {
            return FilterConnection.this.getEndPoint();
        }

        @Override
        public String toString() {
            return super.toString() + "->" + FilterConnection.this.getEndPoint().toString();
        }
    }

    public static class DumpToFileFilter
    implements Filter {
        final ConcurrentHashMap<EndPoint, OutputStream> _in = new ConcurrentHashMap();
        final ConcurrentHashMap<EndPoint, OutputStream> _out = new ConcurrentHashMap();
        final File _directory;
        final String _prefix;
        final boolean _deleteOnExit;

        public DumpToFileFilter() {
            this(new File(System.getProperty("java.io.tmpdir") + File.separator + "FilterConnection"), true);
        }

        public DumpToFileFilter(File directory, boolean deleteOnExit) {
            this(directory, "dump-", deleteOnExit);
        }

        public DumpToFileFilter(String prefix) {
            this(new File(System.getProperty("java.io.tmpdir") + File.separator + "FilterConnection"), prefix, true);
        }

        public DumpToFileFilter(@Name(value="directory") File directory, @Name(value="prefix") String prefix, @Name(value="deleteOnExit") boolean deleteOnExit) {
            this._directory = directory;
            this._prefix = prefix;
            this._deleteOnExit = deleteOnExit;
            if (!this._directory.exists() && !this._directory.mkdirs()) {
                throw new IllegalArgumentException("cannot create " + directory);
            }
            if (!this._directory.isDirectory()) {
                throw new IllegalArgumentException("not directory " + directory);
            }
            if (!this._directory.canWrite()) {
                throw new IllegalArgumentException("cannot write " + directory);
            }
        }

        @Override
        public void opened(EndPoint endpoint) {
            try {
                File in = new File(this._directory, this._prefix + Integer.toHexString(endpoint.hashCode()) + ".in");
                File out = new File(this._directory, this._prefix + Integer.toHexString(endpoint.hashCode()) + ".out");
                if (this._deleteOnExit) {
                    in.deleteOnExit();
                    out.deleteOnExit();
                }
                this._in.put(endpoint, new FileOutputStream(in));
                this._out.put(endpoint, new FileOutputStream(out));
            }
            catch (FileNotFoundException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Override
        public void incoming(EndPoint endpoint, ByteBuffer bytes) {
            try {
                OutputStream out = this._in.get(endpoint);
                if (out != null) {
                    out.write(BufferUtil.toArray((ByteBuffer)bytes));
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Override
        public void outgoing(EndPoint endpoint, ByteBuffer bytes) {
            try {
                OutputStream out = this._out.get(endpoint);
                if (out != null) {
                    out.write(BufferUtil.toArray((ByteBuffer)bytes));
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Override
        public void closed(EndPoint endpoint) {
            OutputStream out;
            try {
                out = this._in.remove(endpoint);
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            try {
                out = this._out.remove(endpoint);
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    public static class DebugFilter
    implements Filter {
        @Override
        public void opened(EndPoint endpoint) {
            if (DEBUG) {
                LOG.debug("{}@{} opened%n", new Object[]{endpoint.getClass().getSimpleName(), Integer.toString(endpoint.hashCode(), 16)});
            }
        }

        @Override
        public void incoming(EndPoint endpoint, ByteBuffer bytes) {
            if (DEBUG) {
                LOG.debug("{}@{} >>> {}%n", new Object[]{endpoint.getClass().getSimpleName(), Integer.toString(endpoint.hashCode(), 16), BufferUtil.toDetailString((ByteBuffer)bytes)});
            }
        }

        @Override
        public void outgoing(EndPoint endpoint, ByteBuffer bytes) {
            if (DEBUG) {
                LOG.debug("{}@{} <<< {}%n", new Object[]{endpoint.getClass().getSimpleName(), Integer.toString(endpoint.hashCode(), 16), BufferUtil.toDetailString((ByteBuffer)bytes)});
            }
        }

        @Override
        public void closed(EndPoint endpoint) {
            if (DEBUG) {
                LOG.debug("{}@{} closed%n", new Object[]{endpoint.getClass().getSimpleName(), Integer.toString(endpoint.hashCode(), 16)});
            }
        }
    }

    public static interface Filter {
        public void opened(EndPoint var1);

        public void incoming(EndPoint var1, ByteBuffer var2);

        public void outgoing(EndPoint var1, ByteBuffer var2);

        public void closed(EndPoint var1);
    }
}

