/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class IdleTimeout {
    private static final Logger LOG = Log.getLogger(IdleTimeout.class);
    private final Scheduler _scheduler;
    private final AtomicReference<Scheduler.Task> _timeout = new AtomicReference();
    private volatile long _idleTimeout;
    private volatile long _idleTimestamp = System.currentTimeMillis();
    private final Runnable _idleTask = new Runnable(){

        @Override
        public void run() {
            long idleLeft = IdleTimeout.this.checkIdleTimeout();
            if (idleLeft >= 0L) {
                IdleTimeout.this.scheduleIdleTimeout(idleLeft > 0L ? idleLeft : IdleTimeout.this.getIdleTimeout());
            }
        }
    };

    public IdleTimeout(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public long getIdleTimestamp() {
        return this._idleTimestamp;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        long old = this._idleTimeout;
        this._idleTimeout = idleTimeout;
        if (old > 0L) {
            if (old <= this._idleTimeout) {
                return;
            }
            Scheduler.Task oldTimeout = this._timeout.getAndSet(null);
            if (oldTimeout != null) {
                oldTimeout.cancel();
            }
        }
        if (this._idleTimeout > 0L && this.isOpen()) {
            this._idleTask.run();
        }
    }

    public void notIdle() {
        this._idleTimestamp = System.currentTimeMillis();
    }

    private void scheduleIdleTimeout(long delay) {
        Scheduler.Task oldTimeout;
        Scheduler.Task newTimeout = null;
        if (this.isOpen() && delay > 0L && this._scheduler != null) {
            newTimeout = this._scheduler.schedule(this._idleTask, delay, TimeUnit.MILLISECONDS);
        }
        if ((oldTimeout = (Scheduler.Task)this._timeout.getAndSet(newTimeout)) != null) {
            oldTimeout.cancel();
        }
    }

    public void onOpen() {
        if (this._idleTimeout > 0L) {
            this._idleTask.run();
        }
    }

    protected void close() {
        Scheduler.Task oldTimeout = this._timeout.getAndSet(null);
        if (oldTimeout != null) {
            oldTimeout.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long checkIdleTimeout() {
        if (this.isOpen()) {
            long idleTimestamp = this.getIdleTimestamp();
            long idleTimeout = this.getIdleTimeout();
            long idleElapsed = System.currentTimeMillis() - idleTimestamp;
            long idleLeft = idleTimeout - idleElapsed;
            LOG.debug("{} idle timeout check, elapsed: {} ms, remaining: {} ms", new Object[]{this, idleElapsed, idleLeft});
            if (idleTimestamp != 0L && idleTimeout > 0L && idleLeft <= 0L) {
                LOG.debug("{} idle timeout expired", new Object[]{this});
                try {
                    this.onIdleExpired(new TimeoutException("Idle timeout expired: " + idleElapsed + "/" + idleTimeout + " ms"));
                }
                finally {
                    this.notIdle();
                }
            }
            return idleLeft >= 0L ? idleLeft : 0L;
        }
        return -1L;
    }

    protected abstract void onIdleExpired(TimeoutException var1);

    protected abstract boolean isOpen();
}

